/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.generator;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.generator.SingleControlGenerator;
import com.ibm.etools.jsf.internal.databind.templates.TemplateGenerator;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IGenerationTemplate;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Interface;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class ActionGenerator
extends SingleControlGenerator {
    private PageActionNode actionNode;
    private String buttonType;
    private String actionAttribute;
    private String tagLabel;
    private String tagId;
    private boolean forceJavajet = false;

    @Override
    protected void clear() {
        super.clear();
        this.actionNode = null;
        this.buttonType = null;
        this.actionAttribute = null;
        this.tagLabel = null;
        this.tagId = null;
        this.forceJavajet = false;
    }

    @Override
    public String perform(ICodeGenNode node) {
        try {
            this.setCodeGenNode(node);
            String generatedCode = "";
            if (!TemplateProvider.useJavajetTemplates() && !this.forceJavajet) {
                if (node.getControlId() == null || "".equals(node.getControlId())) {
                    if (JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)EditDomainUtil.getEditDomain().getModel().getDocument()))) {
                        node.setControlId("jsf.method.commandExButton");
                    } else {
                        node.setControlId("jsf.base.method.commandButton");
                    }
                }
                BaseVariableResolver baseResolver = new BaseVariableResolver(node, this.getRootCodeGenNode(), this.getParentBeanName(), null, this.actionAttribute);
                TemplateGenerator t = new TemplateGenerator(baseResolver);
                generatedCode = t.resolvePropertyTemplates();
                this.getModel().addCustomProperty((Object)"requires_form", (Object)Boolean.TRUE);
            }
            if (generatedCode.equals("")) {
                if (node.getEnclosedNode() instanceof PageActionNode) {
                    this.actionNode = (PageActionNode)node.getEnclosedNode();
                }
                this.getModel().addCustomProperty((Object)"requires_form", (Object)Boolean.TRUE);
                this.setVariables();
                IGenerationTemplate template = this.getTemplate();
                if (template != null) {
                    generatedCode = template.generate((Interface)this);
                }
            }
            String string = generatedCode;
            return string;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return "";
        }
        finally {
            this.clear();
        }
    }

    protected void setVariables() {
        if ("".equals(this.getCodeGenNode().getControlId()) || this.getCodeGenNode().getControlId() == null) {
            this.setControlId();
        }
        if ("".equals(this.actionAttribute) || this.actionAttribute == null) {
            this.setActionAttribute();
        }
        if ("".equals(this.buttonType) || this.buttonType == null) {
            this.setButtonType();
        }
        if ("".equals(this.tagLabel) || this.tagLabel == null) {
            this.setTagLabel();
        }
        if ("".equals(this.tagId) || this.tagId == null) {
            this.setTagId();
        }
    }

    protected void setControlId() {
        IFile file;
        IPageDataModel pdModel;
        IProject project = null;
        IPageDataNode pdNode = this.getCodeGenNode().getEnclosedNode();
        if (pdNode != null && (pdModel = pdNode.getPageDataModel()) != null && (file = pdModel.getResource()) != null) {
            project = file.getProject();
        }
        if (project != null && JsfTagModeUtil.isUsingIbmTags(project)) {
            this.getCodeGenNode().setControlId("commandExButton");
        } else {
            this.getCodeGenNode().setControlId("commandButton");
        }
    }

    protected void setButtonType() {
        this.buttonType = "submit";
    }

    protected void setButtonType(String type) {
        this.buttonType = type;
    }

    protected void setTagLabel() {
        String modelLabel = this.getModel().getSubmitButtonLabel();
        this.tagLabel = "".equals(modelLabel) || modelLabel == null ? Messages.ActionGenerator_DefaultLabel : modelLabel;
    }

    protected void setTagLabel(String label) {
        this.tagLabel = label;
    }

    protected void setTagId() {
        String controlId = this.getCodeGenNode().getControlId();
        if ("commandExButton".equals(controlId)) {
            this.setTaglibUri("http://www.ibm.com/jsf/html_extended");
            this.setTagName("commandExButton");
            this.tagId = this.getId();
        } else if ("commandButton".equals(controlId)) {
            this.setTaglibUri("http://java.sun.com/jsf/html");
            this.setTagName("commandButton");
            this.tagId = this.getId();
        } else if ("commandLink".equals(controlId)) {
            this.setTaglibUri("http://java.sun.com/jsf/html");
            this.setTagName("commandLink");
            this.tagId = this.getId();
        } else {
            this.tagId = this.getId();
        }
    }

    protected void setTagId(String id) {
        this.tagId = id;
    }

    protected void setTagId(String taglib, String tagName) {
        this.tagId = this.getId(taglib, tagName);
    }

    protected void setActionAttribute() {
        this.setActionAttribute(this.actionNode);
    }

    protected void setActionAttribute(PageActionNode node) {
        this.actionAttribute = "";
        if (node != null) {
            IBindingAttribute attr = (IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY);
            String action = attr.getReferenceString((IPageDataNode)node);
            if (!TemplateProvider.useJavajetTemplates() && !this.forceJavajet) {
                if (!"".equals(action) && action != null) {
                    this.actionAttribute = action;
                }
            } else if (!"".equals(action) && action != null) {
                this.actionAttribute = " action=\"#{" + action + "}\"";
            }
        }
    }

    protected void setActionAttribute(String attr) {
        this.actionAttribute = attr;
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public String getActionAttribute() {
        return this.actionAttribute;
    }

    public String getTagLabel() {
        return this.tagLabel;
    }

    public String getTagId() {
        return this.tagId;
    }

    protected void setForceJavajet(boolean force) {
        this.forceJavajet = force;
    }
}

