/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.dnd;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webtools.pagedataview.util.TagUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableInspectorUtil {
    private TableInspectorUtil() {
    }

    public static boolean isUnderExpandableTable(Node dropTarget) {
        Node tableNode = dropTarget;
        String templateContentArea = new String("tpl:put");
        while (tableNode != null) {
            if (templateContentArea.equals(tableNode.getNodeName())) {
                return false;
            }
            if ("TABLE".equalsIgnoreCase(tableNode.getNodeName())) break;
            if (JsfComponentUtil.isJsfTag((Node)dropTarget)) {
                tableNode = null;
                break;
            }
            tableNode = tableNode.getParentNode();
        }
        return TableInspectorUtil.getColumnCount(tableNode) >= 3;
    }

    public static int getColumnCount(Node dropTarget) {
        Node tr;
        int columns = 0;
        Node tableNode = dropTarget;
        while (tableNode != null) {
            if ("TABLE".equalsIgnoreCase(tableNode.getNodeName())) break;
            tableNode = tableNode.getParentNode();
        }
        if (tableNode != null && (tr = TableInspectorUtil.findLastRow(tableNode)) != null) {
            Node child = tr.getFirstChild();
            while (child != null) {
                if ("TD".equalsIgnoreCase(child.getNodeName())) {
                    ++columns;
                    String colspan = ((Element)child).getAttribute("colspan");
                    if (colspan != null && !"".equals(colspan)) {
                        columns += Integer.parseInt(colspan) - 1;
                    }
                }
                child = child.getNextSibling();
            }
        }
        return columns;
    }

    public static Node rowNodeToAppendAfter(Node dropTarget) {
        Node cursorNode = dropTarget;
        while (cursorNode != null) {
            if ("TR".equalsIgnoreCase(cursorNode.getNodeName())) {
                return cursorNode;
            }
            if ("TBODY".equalsIgnoreCase(cursorNode.getNodeName())) {
                return TableInspectorUtil.findLastRow(cursorNode);
            }
            if ("TABLE".equalsIgnoreCase(cursorNode.getNodeName())) {
                Node tbody = TagUtil.findNode((Node)cursorNode, (String)"TBODY");
                if (tbody != null) {
                    return TableInspectorUtil.findLastRow(tbody);
                }
                return TableInspectorUtil.findLastRow(cursorNode);
            }
            cursorNode = cursorNode.getParentNode();
        }
        return null;
    }

    private static Node findLastRow(Node tableNode) {
        Node tbody = TagUtil.findNode((Node)tableNode, (String)"TBODY");
        if (tbody == null) {
            tbody = tableNode;
        }
        Node child = tbody.getLastChild();
        while (child != null) {
            if ("TR".equalsIgnoreCase(child.getNodeName())) {
                return child;
            }
            child = child.getPreviousSibling();
        }
        return null;
    }

    public static Node getParentDataTable(Node dropTarget) {
        while (dropTarget != null) {
            if ("dataTable".equals(dropTarget.getLocalName()) || "dataTableEx".equals(dropTarget.getLocalName())) {
                return dropTarget;
            }
            dropTarget = dropTarget.getParentNode();
        }
        return null;
    }

    public static Node getParentColumn(Node dropTarget) {
        while (dropTarget != null) {
            if ("column".equals(dropTarget.getLocalName()) || "columnEx".equals(dropTarget.getLocalName())) {
                return dropTarget;
            }
            dropTarget = dropTarget.getParentNode();
        }
        return null;
    }

    public static Node checkDropIntoTable(Node dropTarget) {
        boolean validLocation = true;
        Node loopTarget = dropTarget;
        while (loopTarget != null && loopTarget.getNodeType() != 9) {
            if ("TD".equalsIgnoreCase(loopTarget.getLocalName())) break;
            if ("TR".equalsIgnoreCase(loopTarget.getLocalName()) || "TBODY".equalsIgnoreCase(loopTarget.getLocalName()) || "TABLE".equalsIgnoreCase(loopTarget.getLocalName())) {
                validLocation = false;
                break;
            }
            loopTarget = loopTarget.getParentNode();
        }
        if (!validLocation) {
            Node tableNode = dropTarget;
            while (tableNode != null) {
                if ("TABLE".equalsIgnoreCase(tableNode.getLocalName())) {
                    return tableNode;
                }
                tableNode = tableNode.getParentNode();
            }
        }
        return dropTarget;
    }

    public static boolean isUnderHtmlTable(Node target) {
        while (target != null && target.getNodeType() != 9) {
            if ("TABLE".equalsIgnoreCase(target.getNodeName())) {
                return true;
            }
            target = target.getParentNode();
        }
        return false;
    }

    public static Node getParentTable(Node target) {
        while (target != null && target.getNodeType() != 9) {
            if ("TABLE".equalsIgnoreCase(target.getNodeName())) {
                return target;
            }
            target = target.getParentNode();
        }
        return null;
    }
}

