/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.dnd;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.ICodeGenInsertOperation;
import com.ibm.etools.jsf.databind.commands.builder.BindingCommandFactory;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.dnd.TableInspectorUtil;
import com.ibm.etools.jsf.databind.generator.ICGInsertionProvider;
import com.ibm.etools.jsf.internal.databind.LibraryBindingUtil;
import com.ibm.etools.jsf.internal.databind.templates.DataTemplate;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.vis.databind.BindingHelper;
import com.ibm.etools.jsf.library.emf.ChildTagsTemplateType;
import com.ibm.etools.jsf.library.emf.DataBindingType;
import com.ibm.etools.jsf.library.emf.DropIntentType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.extension.DropTargetObject;
import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.WebModelCreationException;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.model.api.WebPage;
import com.ibm.etools.webtools.model.util.ModelUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.exceptions.UserCancelledException;
import com.ibm.etools.webtools.pagedataview.PageDataViewRegistryReader;
import com.ibm.etools.webtools.pagedataview.data.IEClassPageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropActionConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropHint;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetConfig;
import com.ibm.etools.webtools.pagedataview.ui.dnd.DropTargetDescription;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropActionMediator;
import com.ibm.etools.webtools.pagedataview.ui.dnd.IDropColleague;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class JSFDropActionMediator
implements IDropActionMediator {
    private static final String invalidDrop = new String("invalidDrop");
    private static final String insertCase = new String("insertCase");
    private static final String bindCase = new String("bindCase");
    private static final String bindAndInsert = new String("bindAndInsert");
    private static final String insertChildTags = new String("insertChildTags");
    private String result = null;

    public DropTargetConfig getDropTargetConfig(IDropColleague colleague, IPageDataNode[] dropObjects, DropTargetDescription target) {
        Node targetNode = target.getTargetNode();
        if (targetNode != null && JsfComponentUtil.isJsfPage((Document)JsfCommandUtil.getDocument(targetNode))) {
            try {
                DropTargetConfig config = new DropTargetConfig(0, null);
                this.checkDrop(dropObjects, null, target.getTargetNode());
                if (invalidDrop.equals(this.result)) {
                    config.dropOperation = (short)3;
                } else if (insertCase.equals(this.result)) {
                    config.dropOperation = 1;
                } else {
                    config.dropOperation = (short)2;
                    config.dropTarget = new DropTargetObject(target.getTargetNode());
                }
                return config;
            }
            catch (Exception e) {
                JsfPlugin.log(e);
                return new DropTargetConfig(2, null);
            }
        }
        return null;
    }

    public DropHint getDropHint(IDropColleague colleague, IPageDataNode[] dropObjects, DropTargetDescription target, short type) {
        String msg;
        String dataName;
        if (dropObjects.length > 1) {
            dataName = Messages.JSFDropActionMediator_SelectedData;
        } else {
            IBindingAttribute attrs = (IBindingAttribute)dropObjects[0].getAdapter(IBindingAttribute.ADAPTER_KEY);
            dataName = "\"" + attrs.getName(dropObjects[0]) + "\"";
        }
        if (type == 2) {
            Node targetNode = target.getTargetNode();
            String componentName = null;
            if (targetNode.getNodeType() == 1) {
                componentName = ((Element)targetNode).getAttribute("id");
            }
            if (componentName == null) {
                componentName = targetNode.getNodeName();
            }
            String msg2 = MessageFormat.format(Messages.JSFDropActionMediator_BindControl, dataName, componentName);
            String uri = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(targetNode)).getUriForPrefix(targetNode.getPrefix());
            String tagName = targetNode.getLocalName();
            IPageDataNode commonRootNode = BindingUtil.findCommonRootNode(dropObjects);
            if (this.standardDataTableTargeted(uri, tagName)) {
                if (BindingUtil.isListNode(commonRootNode)) {
                    if (dropObjects.length > 1 || BindingUtil.isListNode(dropObjects[0])) {
                        msg2 = MessageFormat.format(Messages.JsfDropActionMediator_InsertMultipleColumns, dataName);
                        return new DropHint(DropHint.DEFAULT_INSERT_IMAGE, msg2);
                    }
                    msg2 = MessageFormat.format(Messages.JsfDropActionMediator_InsertSingleColumn, dataName);
                    return new DropHint(DropHint.DEFAULT_INSERT_IMAGE, msg2);
                }
                msg2 = Messages.JsfDropActionMediator_InvalidLocation;
                return new DropHint(DropHint.DEFAULT_NOOP_IMAGE, msg2);
            }
            if (bindAndInsert.equals(this.result)) {
                msg2 = MessageFormat.format(Messages.JSFDropActionMediator_BindAndInsertControls, dataName, componentName);
                return new DropHint(DropHint.DEFAULT_BIND_IMAGE, msg2);
            }
            if (insertChildTags.equals(this.result)) {
                msg2 = MessageFormat.format(Messages.JSFDropActionMediator_InsertNewControls, dataName);
                return new DropHint(DropHint.DEFAULT_INSERT_IMAGE, msg2);
            }
            return new DropHint(DropHint.DEFAULT_BIND_IMAGE, msg2);
        }
        if (type == 1) {
            msg = MessageFormat.format(Messages.JSFDropActionMediator_InsertNewControls, dataName);
            return new DropHint(DropHint.DEFAULT_INSERT_IMAGE, msg);
        }
        msg = Messages.JsfDropActionMediator_InvalidLocation;
        return new DropHint(DropHint.DEFAULT_NOOP_IMAGE, msg);
    }

    public DropActionConfig getDropActionConfig(IDropColleague colleague, IPageDataNode[] dropObjects, DropTargetDescription target, short type) {
        DropActionConfig ret = new DropActionConfig();
        Node targetNode = target.getTargetNode();
        try {
            IDOMDocument d = (IDOMDocument)JsfCommandUtil.getDocument(targetNode);
            IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)d);
            Path jspPath = new Path(d.getModel().getBaseLocation());
            IFile file = (IFile)project.getWorkspace().getRoot().findMember((IPath)jspPath);
            JSP jsp = ModelManager.getModel((IResource)project).getJSP(file);
            EditDomainUtil.setEditDomain((HTMLEditDomain)ModelUtil.getEditDomain((WebPage)jsp));
            if (type == 1) {
                try {
                    ICodeGenModel model = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])dropObjects, null, (JSP)jsp, (String)PageDataViewRegistryReader.getPageTypeOfMediator((Object)this), (boolean)true);
                    if (insertChildTags.equals(this.result)) {
                        CodeGenModelFactory.configureInWizard((ICodeGenModel)model);
                    } else if (this.checkSpecialGridCase(target, model)) {
                        CodeGenModelFactory.configureInWizard((ICodeGenModel)model, (boolean)true);
                    } else {
                        CodeGenModelFactory.configureInWizard((ICodeGenModel)model);
                    }
                    this.runInsertOperation(model);
                }
                catch (UserCancelledException userCancelledException) {
                }
                catch (Exception e) {
                    JsfPlugin.log(e);
                    try {
                        try {
                            ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)EditDomainUtil.getEditDomain());
                        }
                        catch (Exception e2) {
                            JsfPlugin.log(e2);
                            EditDomainUtil.unsetEditDomain();
                        }
                    }
                    finally {
                        EditDomainUtil.unsetEditDomain();
                    }
                    return null;
                }
            } else {
                try {
                    ICodeGenModel model = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])dropObjects, null, (JSP)jsp, (String)PageDataViewRegistryReader.getPageTypeOfMediator((Object)this), (boolean)true);
                    CodeGenModelFactory.finalizeModel((ICodeGenModel)model);
                    HTMLCommand cmd = this.createBindingCommand(targetNode, model);
                    ret.addCustomProperty(DropActionConfig.COMMAND_BEFORE_ACTION, (Object)cmd);
                }
                catch (Exception e) {
                    JsfPlugin.log(e);
                    try {
                        try {
                            ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)EditDomainUtil.getEditDomain());
                        }
                        catch (Exception e3) {
                            JsfPlugin.log(e3);
                            EditDomainUtil.unsetEditDomain();
                        }
                    }
                    finally {
                        EditDomainUtil.unsetEditDomain();
                    }
                    return null;
                }
            }
            DropActionConfig dropActionConfig = ret;
            return dropActionConfig;
        }
        catch (WebModelCreationException e) {
            JsfPlugin.log(e);
            return null;
        }
        finally {
            block43: {
                try {
                    try {
                        ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)EditDomainUtil.getEditDomain());
                    }
                    catch (Exception e) {
                        JsfPlugin.log(e);
                        EditDomainUtil.unsetEditDomain();
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    EditDomainUtil.unsetEditDomain();
                    throw throwable;
                }
                EditDomainUtil.unsetEditDomain();
            }
        }
    }

    public void handlePaletteDrop(ICodeGenModel model, Node target) {
        block24: {
            HTMLEditDomain editDomain = null;
            CodeGenModelFactory.finalizeModel((ICodeGenModel)model);
            try {
                try {
                    IDOMDocument d = (IDOMDocument)JsfCommandUtil.getDocument(target);
                    IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)d);
                    Path jspPath = new Path(d.getModel().getBaseLocation());
                    IFile file = (IFile)project.getWorkspace().getRoot().findMember((IPath)jspPath);
                    JSP jsp = ModelManager.getModel((IResource)project).getJSP(file);
                    editDomain = ModelUtil.getEditDomain((WebPage)jsp);
                    EditDomainUtil.setEditDomain((HTMLEditDomain)editDomain);
                    target = this.ignoreTextNode(target);
                    this.checkDrop(null, model, target);
                    if (insertCase.equals(this.result) || bindCase.equals(this.result)) {
                        this.runInsertOperation(model);
                    } else if (invalidDrop.equals(this.result)) {
                        if (Display.getCurrent() != null && EditDomainUtil.getEditDomain().getDialogParent() != null) {
                            MessageDialog.openInformation((Shell)EditDomainUtil.getEditDomain().getDialogParent(), (String)Messages.JSFDropActionMediator_InvalidDrop, (String)Messages.JSFDropActionMediator_InvalidDropDesc);
                        } else {
                            System.out.println(Messages.JSFDropActionMediator_InvalidDrop);
                            System.out.println(Messages.JSFDropActionMediator_InvalidDropDesc);
                        }
                    }
                }
                catch (WebModelCreationException e) {
                    JsfPlugin.log(e);
                    try {
                        try {
                            ModelUtil.releaseAndSaveIfNecessaryEditDomain(editDomain);
                        }
                        catch (Exception e2) {
                            JsfPlugin.log(e2);
                            EditDomainUtil.unsetEditDomain();
                        }
                        break block24;
                    }
                    finally {
                        EditDomainUtil.unsetEditDomain();
                    }
                }
            }
            catch (Throwable throwable) {
                block26: {
                    try {
                        try {
                            ModelUtil.releaseAndSaveIfNecessaryEditDomain(editDomain);
                        }
                        catch (Exception e) {
                            JsfPlugin.log(e);
                            EditDomainUtil.unsetEditDomain();
                            break block26;
                        }
                    }
                    catch (Throwable throwable2) {
                        EditDomainUtil.unsetEditDomain();
                        throw throwable2;
                    }
                    EditDomainUtil.unsetEditDomain();
                }
                throw throwable;
            }
            try {
                try {
                    ModelUtil.releaseAndSaveIfNecessaryEditDomain((HTMLEditDomain)editDomain);
                }
                catch (Exception e) {
                    JsfPlugin.log(e);
                    EditDomainUtil.unsetEditDomain();
                }
            }
            finally {
                EditDomainUtil.unsetEditDomain();
            }
        }
    }

    private void checkDrop(IPageDataNode[] pdNodes, ICodeGenModel codeGenModel, Node targetNode) {
        if (targetNode != null) {
            if (JsfComponentUtil.isJsfTag((Node)targetNode)) {
                String intent;
                String tagName;
                IPageDataNode node;
                if (this.isWhitespaceTag(targetNode)) {
                    this.result = insertCase;
                    return;
                }
                if (pdNodes != null && (node = pdNodes[0]) != null && "Action".equals(node.getDataCategory()) && !JsfComponentUtil.checkComponentSuperclass((Node)targetNode, (String)"javax.faces.component.UICommand") && !JsfComponentUtil.checkComponentSuperclass((Node)targetNode, (String)"com.ibm.faces.component.UIRequest")) {
                    this.result = invalidDrop;
                    return;
                }
                String uri = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(targetNode)).getUriForPrefix(targetNode.getPrefix());
                if (this.standardDataTableTargeted(uri, tagName = targetNode.getLocalName())) {
                    if (codeGenModel != null) {
                        if (!codeGenModel.getRoot().isListNode()) {
                            this.result = invalidDrop;
                            return;
                        }
                    } else {
                        IPageDataNode commonRootNode = BindingUtil.findCommonRootNode(pdNodes);
                        if (!BindingUtil.isListNode(commonRootNode)) {
                            this.result = invalidDrop;
                            return;
                        }
                    }
                }
                if (!TemplateProvider.useJavajetTemplates() && (intent = this.checkLibraryTagDropIntent(uri, tagName)) != null) {
                    this.result = intent;
                    return;
                }
                if ("http://www.ibm.com/jsf/html_extended".equals(uri) && "progressBar".equals(tagName)) {
                    this.result = invalidDrop;
                    return;
                }
                if (!this.checkTreeAndGraph(uri, tagName, targetNode, pdNodes, codeGenModel)) {
                    this.result = invalidDrop;
                    return;
                }
                this.result = bindCase;
                return;
            }
            this.result = insertCase;
            return;
        }
        this.result = invalidDrop;
    }

    private void runInsertOperation(ICodeGenModel model) {
        String beanType = BindingUtil.getType(model.getRoot().getEnclosedNode());
        ICodeGenInsertOperation operation = null;
        boolean getNext = true;
        Iterator providersIter = ExtensionRegistry.getRegistry().getCGInsertionProviders().iterator();
        while (providersIter.hasNext() && getNext) {
            ICGInsertionProvider provider = (ICGInsertionProvider)providersIter.next();
            operation = provider.getOperation(beanType, model, EditDomainUtil.getEditDomain());
            if (operation == null) continue;
            getNext = false;
        }
        try {
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            monitorDialog.run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            JsfPlugin.log(e);
        }
    }

    private HTMLCommand createBindingCommand(Node targetNode, ICodeGenModel model) {
        DocumentRange doc = (DocumentRange)((Object)targetNode.getOwnerDocument());
        Range newRange = doc.createRange();
        newRange.setStart(targetNode, 0);
        newRange.setEnd(targetNode, 0);
        EditDomainUtil.getEditDomain().getSelectionMediator().setRange(newRange);
        return BindingCommandFactory.generateCommand(targetNode, "value", model, false);
    }

    private Node ignoreTextNode(Node target) {
        if (target.getNodeType() == 3) {
            target = target.getParentNode();
        }
        return target;
    }

    protected boolean isWhitespaceTag(Node targetNode) {
        String uri = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(targetNode)).getUriForPrefix(targetNode.getPrefix());
        String tagName = targetNode.getLocalName();
        return "http://java.sun.com/jsf/core".equals(uri) && "view".equals(tagName) || "http://java.sun.com/jsf/core".equals(uri) && "facet".equals(tagName) || "http://java.sun.com/jsf/html".equals(uri) && "form".equals(tagName) || "http://java.sun.com/jsf/html".equals(uri) && "panelGrid".equals(tagName) || "http://java.sun.com/jsf/html".equals(uri) && "panelGroup".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelBox".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelLayout".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelSection".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelMenu".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelActionbar".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelGroupEx".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelDialog".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "jspPanel".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "scriptCollector".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "viewFragment".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelFormBox".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "formItem".equals(tagName) || "http://www.ibm.com/jsf/BrowserFramework".equals(uri) && "bfPanel".equals(tagName) || "http://www.ibm.com/jsf/BrowserFramework".equals(uri) && "tabbedPanel".equals(tagName);
    }

    protected String checkForInsertCase(Node targetNode) {
        return null;
    }

    protected boolean checkSpecialGridCase(DropTargetDescription target, ICodeGenModel model) {
        if (!JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProject())) {
            return false;
        }
        Node targetNode = target.getTargetNode();
        boolean specialCase = false;
        if (targetNode != null && model != null) {
            TaglibPrefixUtil mapper;
            Node parentColumn = TableInspectorUtil.getParentColumn(targetNode);
            Node parentDataTable = TableInspectorUtil.getParentDataTable(targetNode);
            if (parentColumn != null && parentDataTable != null && model.getRoot().isListNode() && (mapper = TaglibPrefixUtil.getMapperUtil((Document)targetNode.getOwnerDocument())) != null) {
                String columnPrefix = parentColumn.getPrefix();
                String columnURI = mapper.getUriForPrefix(columnPrefix);
                String dataTablePrefix = parentColumn.getPrefix();
                String dataTableURI = mapper.getUriForPrefix(dataTablePrefix);
                if (("http://java.sun.com/jsf/html".equals(columnURI) || "http://www.ibm.com/jsf/html_extended".equals(columnURI)) && ("http://java.sun.com/jsf/html".equals(dataTableURI) || "http://www.ibm.com/jsf/html_extended".equals(dataTableURI))) {
                    specialCase = true;
                }
            }
        }
        return specialCase;
    }

    private boolean checkTreeAndGraph(String uri, String tagName, Node targetNode, IPageDataNode[] pdNodes, ICodeGenModel codeGenModel) {
        if ("http://www.ibm.com/jsf/BrowserFramework".equals(uri) && ("tree".equals(tagName) || "treeNodeAttr".equals(tagName) || "graphDraw".equals(tagName) || "graphDrawData".equals(tagName))) {
            IPageDataNode root = null;
            IPageDataNode parent = null;
            if (pdNodes != null) {
                root = pdNodes[0];
                if (root == null) {
                    return false;
                }
                while ((parent = root.getParent()) != null && (IBindingAttribute)parent.getAdapter(IBindingAttribute.ADAPTER_KEY) != null && (!(root instanceof IEClassPageDataNode) || parent instanceof IEClassPageDataNode)) {
                    root = parent;
                }
            } else if (codeGenModel != null) {
                root = codeGenModel.getRoot().getEnclosedNode();
            }
            if (root != null && !BindingHelper.isValidODCBinding(root, targetNode)) {
                return false;
            }
        }
        return true;
    }

    private String checkLibraryTagDropIntent(String uri, String tagName) {
        DropIntentType intent;
        DataBindingType tagBinding;
        TagType tagType = LibraryManager.getInstance().getTagModel(uri, tagName);
        if (tagType != null && (tagBinding = tagType.getDataBinding()) != null && (intent = tagBinding.getDropIntent()) != null) {
            if (DropIntentType.INSERT.equals((Object)intent)) {
                DataTemplate iterativeTemplate;
                ChildTagsTemplateType childType = tagType.getChildTags();
                if (childType != null && (iterativeTemplate = LibraryBindingUtil.createTemplateInstance(childType)) != null) {
                    return insertChildTags;
                }
                return insertCase;
            }
            if (DropIntentType.BOTH.equals((Object)intent)) {
                return bindAndInsert;
            }
            if (!tagBinding.isSetMainBindingAttribute()) {
                return invalidDrop;
            }
            return bindCase;
        }
        return null;
    }

    private boolean standardDataTableTargeted(String uri, String tagName) {
        return "http://java.sun.com/jsf/html".equals(uri) ? "column".equals(tagName) || "dataTable".equals(tagName) : "http://www.ibm.com/jsf/html_extended".equals(uri) && ("columnEx".equals(tagName) || "dataTableEx".equals(tagName));
    }
}

