/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.commands.builder;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.commands.SetValueCommand;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.databind.commands.builder.IBindingCommandProvider;
import com.ibm.etools.jsf.databind.commands.builder.IBindingCustomizer;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultBindingCommandProvider
implements IBindingCommandProvider {
    @Override
    public int getBindingIntent(Node targetNode, BindingContext context) {
        return 1;
    }

    @Override
    public HTMLCommand determineBindingCommand(Node targetNode, BindingContext context) {
        try {
            Object command = null;
            IBindingCustomizer customizer = null;
            Node parentNode = targetNode.getParentNode();
            while (parentNode != null) {
                if (JsfComponentUtil.isJsfTag((Node)parentNode) && (customizer = this.getCustomizer(parentNode)) != null && (command = customizer.getCommandForContainingNode(parentNode, targetNode, context)) != null) {
                    Debug.trace("[data] command: " + command, "databind");
                    return command;
                }
                parentNode = parentNode.getParentNode();
            }
            customizer = this.getCustomizer(targetNode);
            if (customizer != null) {
                command = customizer.getCommandForTargetNode(targetNode, context);
            }
            if (command == null) {
                SetValueCommand cmd = new SetValueCommand();
                cmd.setTargetNode(targetNode);
                cmd.setBindingContext(context);
                command = cmd;
            }
            Debug.trace("[data] command: " + command, "databind");
            return command;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return null;
        }
    }

    private IBindingCustomizer getCustomizer(Node targetNode) {
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(targetNode));
        String taglibUri = mapper.getUriForPrefix(targetNode.getPrefix());
        return ExtensionRegistry.getRegistry().getBindingCustomizer(taglibUri);
    }
}

