/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.commands.builder;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BindingContext {
    private ICodeGenModel model;
    private String targetAttribute;
    private String beanName;
    private boolean simpleBinding;
    private IPageDataNode[] propertyNodes;

    public BindingContext(ICodeGenModel model, String targetAttribute, boolean simpleBinding) {
        this.setModel(model);
        this.simpleBinding = simpleBinding;
        this.targetAttribute = targetAttribute;
    }

    public String getBeanName() {
        if (this.beanName == null) {
            IPageDataNode node = this.getBeanNode();
            IBindingAttribute attr = (IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY);
            return attr.getReferenceString(node);
        }
        return this.beanName;
    }

    public IPageDataNode getBeanNode() {
        return this.model.getRoot().getEnclosedNode();
    }

    public ICodeGenModel getModel() {
        return this.model;
    }

    public boolean isSimpleBinding() {
        return this.simpleBinding;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public void setModel(ICodeGenModel model) {
        this.model = model;
        if (model != null) {
            this.processPropertyNodes();
        }
    }

    public String getTargetAttribute() {
        return this.targetAttribute;
    }

    private void processPropertyNodes() {
        List cgNodes = this.model.getCodeGenNodes();
        if (cgNodes != null) {
            ArrayList<IPageDataNode> propNodes = new ArrayList<IPageDataNode>();
            int i = 0;
            while (i < cgNodes.size()) {
                propNodes.add(((ICodeGenNode)cgNodes.get(i)).getEnclosedNode());
                ++i;
            }
            this.propertyNodes = propNodes.toArray(new IPageDataNode[0]);
        } else {
            this.propertyNodes = new IPageDataNode[0];
        }
    }

    public String[] getPropertyNames() {
        if (this.propertyNodes == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        IPageDataNode root = this.model.getRoot().getEnclosedNode();
        int i = 0;
        while (i < this.propertyNodes.length) {
            IBindingAttribute attr = (IBindingAttribute)this.propertyNodes[i].getAdapter(IBindingAttribute.ADAPTER_KEY);
            String name = attr.getRelativeReferenceString(root, this.propertyNodes[i]);
            names.add(name);
            ++i;
        }
        if (names.isEmpty()) {
            return new String[0];
        }
        return names.toArray(new String[0]);
    }

    public String[] getFullPropertyNames() {
        if (this.propertyNodes == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.beanName == null) {
            int i = 0;
            while (i < this.propertyNodes.length) {
                IBindingAttribute attr = (IBindingAttribute)this.propertyNodes[i].getAdapter(IBindingAttribute.ADAPTER_KEY);
                String name = attr.getReferenceString(this.propertyNodes[i]);
                if (name == null) {
                    IPageDataNode beanNode = this.getBeanNode();
                    attr = (IBindingAttribute)beanNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
                    name = attr.getReferenceString(beanNode);
                }
                names.add(name);
                ++i;
            }
        } else {
            IPageDataNode root = this.model.getRoot().getEnclosedNode();
            int i = 0;
            while (i < this.propertyNodes.length) {
                IBindingAttribute attr = (IBindingAttribute)this.propertyNodes[i].getAdapter(IBindingAttribute.ADAPTER_KEY);
                String name = attr.getRelativeReferenceString(root, this.propertyNodes[i]);
                name = name == null || name.equals("") ? this.beanName : String.valueOf(this.beanName) + "." + name;
                names.add(name);
                ++i;
            }
        }
        if (names.isEmpty()) {
            return new String[0];
        }
        return names.toArray(new String[0]);
    }

    public String[] getPropertyTypes() {
        if (this.propertyNodes == null) {
            return new String[0];
        }
        ArrayList<String> types = new ArrayList<String>();
        int i = 0;
        while (i < this.propertyNodes.length) {
            types.add(BindingUtil.getType(this.propertyNodes[i]));
            ++i;
        }
        if (types.isEmpty()) {
            return new String[0];
        }
        return types.toArray(new String[0]);
    }

    public IPageDataNode[] getPropertyNodes() {
        return this.propertyNodes;
    }

    public String getBeanType() {
        return BindingUtil.getType(this.model.getRoot().getEnclosedNode());
    }

    public boolean isListNode(IPageDataNode node) {
        ICodeGenNode cgNode = this.findCodeGenNode(node);
        if (cgNode != null) {
            return cgNode.isListNode();
        }
        return false;
    }

    private ICodeGenNode findCodeGenNode(IPageDataNode pdNode) {
        if (this.model.getRoot().getEnclosedNode().equals(pdNode)) {
            return this.model.getRoot();
        }
        List children = this.model.getCodeGenNodes();
        Iterator iter = children.iterator();
        ICodeGenNode cgNode = null;
        while (iter.hasNext()) {
            cgNode = (ICodeGenNode)iter.next();
            if (!cgNode.getEnclosedNode().equals(pdNode)) continue;
            return cgNode;
        }
        return null;
    }

    public void setTargetAttribute(String targetAttr) {
        this.targetAttribute = targetAttr;
    }
}

