/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.commands;

import com.ibm.etools.jsf.databind.commands.DataTableCommand;
import com.ibm.etools.jsf.databind.commands.SetValueAndVarCommand;
import com.ibm.etools.jsf.databind.commands.SetValueCommand;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.commands.builder.IBindingCustomizer;
import com.ibm.etools.jsf.internal.databind.BindingCompoundCommand;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTableBindingHelper {
    public static HTMLCommand determineCommandForDataTableChildContainer(Node containingNode, Node targetNode, BindingContext context) {
        Node gridNode = containingNode;
        while (gridNode != null) {
            if ("dataTable".equals(gridNode.getLocalName()) || "dataTableEx".equals(gridNode.getLocalName())) break;
            gridNode = gridNode.getParentNode();
        }
        if (gridNode == null) {
            return null;
        }
        return DataTableBindingHelper.singleGridCase(gridNode, containingNode, targetNode, context);
    }

    public static HTMLCommand singleGridCase(Node gridNode, Node containingNode, Node targetNode, BindingContext context) {
        Element dataTableNode = (Element)gridNode;
        String dataTableValue = dataTableNode.getAttribute("value");
        String dataTableVar = dataTableNode.getAttribute("var");
        BindingUtil.resetModelForVarTag(containingNode, context);
        String beanName = BindingUtil.removeLastIndexReference(context.getBeanName());
        String tagName = containingNode.getLocalName();
        BindingCompoundCommand compoundCommand = null;
        if (context.isSimpleBinding() || !"value".equals(context.getTargetAttribute())) {
            String equivalentValue = BindingUtil.calculateEquivalentValue(dataTableNode);
            if (BindingUtil.removeAllIndexReferences(beanName).equals(BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(equivalentValue))) && dataTableVar != null) {
                context.setBeanName(dataTableVar);
            }
            return null;
        }
        boolean newValue = false;
        if (dataTableValue == null) {
            if (context.isListNode(context.getBeanNode())) {
                dataTableVar = BindingUtil.computeVarAttribute(gridNode, beanName);
                dataTableValue = beanName;
                compoundCommand = new BindingCompoundCommand(Messages.DataTableBindingHelper_DataTableBinding);
                compoundCommand.append((HTMLCommand)new SetValueAndVarCommand(dataTableNode, dataTableValue, dataTableVar));
                newValue = true;
            } else {
                return DataTableBindingHelper.createCommandForVarTagChild(targetNode, context);
            }
        }
        if (dataTableVar == null) {
            dataTableVar = BindingUtil.computeVarAttribute(gridNode, beanName);
            dataTableValue = beanName;
            compoundCommand = new BindingCompoundCommand(Messages.DataTableBindingHelper_DataTableBinding);
            compoundCommand.append((HTMLCommand)new SetValueAndVarCommand(dataTableNode, dataTableValue, dataTableVar));
        }
        if (context.getPropertyNames().length == 1) {
            String equivalentValue = null;
            equivalentValue = newValue ? dataTableValue : BindingUtil.calculateEquivalentValue(dataTableNode);
            if (BindingUtil.removeAllIndexReferences(beanName).equals(BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(equivalentValue)))) {
                context.setBeanName(dataTableVar);
            }
            if (compoundCommand != null) {
                HTMLCommand commandForTarget = DataTableBindingHelper.createCommandForVarTagChild(targetNode, context);
                compoundCommand.append(commandForTarget);
                return compoundCommand;
            }
        } else {
            if ("column".equals(tagName) || "columnEx".equals(tagName)) {
                DataTableCommand command = new DataTableCommand();
                command.setTargetNode(containingNode);
                command.setBindingContext(context);
                return command;
            }
            context.setBeanName(dataTableVar);
            if (compoundCommand != null) {
                HTMLCommand commandForTarget = DataTableBindingHelper.createCommandForVarTagChild(targetNode, context);
                compoundCommand.append(commandForTarget);
                return compoundCommand;
            }
        }
        return null;
    }

    public static HTMLCommand createCommandForDataTableChild(Node targetNode, BindingContext context) {
        return DataTableBindingHelper.createCommandForVarTagChild(targetNode, context);
    }

    public static HTMLCommand createCommandForVarTagChild(Node targetNode, BindingContext context) {
        IBindingCustomizer customizer = DataTableBindingHelper.getCustomizer(targetNode);
        Object cmd = null;
        if (customizer != null) {
            cmd = customizer.getCommandForTargetNode(targetNode, context);
        }
        if (cmd == null) {
            SetValueCommand setValueCmd = new SetValueCommand();
            setValueCmd.setBindingContext(context);
            setValueCmd.setTargetNode(targetNode);
            cmd = setValueCmd;
        }
        return cmd;
    }

    private static IBindingCustomizer getCustomizer(Node targetNode) {
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)targetNode.getOwnerDocument());
        String taglibUri = mapper.getUriForPrefix(targetNode.getPrefix());
        return ExtensionRegistry.getRegistry().getBindingCustomizer(taglibUri);
    }

    public static boolean sameBean(String droppedValue, String targetValue) {
        if ("".equals(targetValue) || targetValue == null) {
            return true;
        }
        droppedValue = DataTableBindingHelper.stripPrefix(droppedValue);
        targetValue = DataTableBindingHelper.stripPrefix(targetValue);
        return targetValue.equals(droppedValue);
    }

    public static String stripPrefix(String value) {
        String pageCodePrefix = new String("pc_");
        if (value.length() > pageCodePrefix.length() && pageCodePrefix.equals(value.substring(0, pageCodePrefix.length()))) {
            int prefixIndex = value.indexOf(".");
            return value.substring(prefixIndex + 1, value.length());
        }
        return value;
    }
}

