/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.validator;

import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.webedit.common.attrview.validator.ValueValidator;
import org.w3c.dom.NodeList;

public class MinMaxValidator
extends ValueValidator {
    private String minValue;
    private String maxValue;
    public static final String ERRORMSG = Messages.InputValue_Error_Msg_2;

    public MinMaxValidator() {
    }

    public MinMaxValidator(String minValue, String maxValue, NodeList nodeList) {
        super(null, null, null, nodeList, null);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public boolean isValueOK() {
        if (this.minValue == null || this.minValue.equals("")) {
            return true;
        }
        if (this.maxValue == null || this.maxValue.equals("")) {
            return true;
        }
        int min = MinMaxValidator.parseInteger(this.minValue, 0, true);
        int max = MinMaxValidator.parseInteger(this.maxValue, 0, true);
        return max >= min;
    }

    public String getErrorMessage() {
        if (!this.isValueOK()) {
            return ERRORMSG;
        }
        return null;
    }

    public static int parseInteger(String value, int fallback, boolean bNegativeAllowed) {
        if (value != null) {
            try {
                return Integer.parseInt(MinMaxValidator.parseIntegerString(value, bNegativeAllowed));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return fallback;
    }

    public static String parseIntegerString(String value, boolean bNegativeAllowed) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        char[] p = value.toCharArray();
        int index = 0;
        if (bNegativeAllowed && p[index] == '-') {
            ++index;
        }
        while (index < p.length) {
            if (!Character.isDigit(p[index])) break;
            ++index;
        }
        if (index == 0) {
            return null;
        }
        if (index < p.length) {
            return value.substring(0, index);
        }
        return value;
    }
}

