/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.pickers;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.jsf.support.FindNodeUtil;
import com.ibm.etools.webedit.common.attrview.HTMLNodeList;
import com.ibm.etools.webedit.common.attrview.picker.NodeListPicker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JsfNodeListPicker
extends NodeListPicker {
    private String[] tagNames;
    private String[] tagsParent;
    private String[] tagsChildren;
    private static final int UNSUPPORTED = 0;
    private static final int PARENT = 1;
    private static final int CHILD = 2;

    public JsfNodeListPicker(String[] tagNames) {
        this.setTagNames(tagNames);
    }

    public void setTagNames(String[] tagNames) {
        this.tagNames = tagNames;
        if (tagNames == null) {
            return;
        }
        this.tagsParent = new String[]{tagNames[0]};
        if (tagNames.length > 1 && tagNames[1] == null) {
            this.tagsChildren = null;
            return;
        }
        this.tagsChildren = new String[tagNames.length - 1];
        int i = 1;
        while (i < tagNames.length) {
            this.tagsChildren[i - 1] = tagNames[i];
            ++i;
        }
    }

    public Node findParentNode(Node node) {
        if (node != null) {
            int type = this.getType(node, node.getNodeName());
            if (type == 2) {
                node = node.getParentNode();
            }
            return FindNodeUtil.findAncestor(node, this.tagsParent, this.tagsChildren);
        }
        return null;
    }

    public NodeList findParameterNodeList(Node node) {
        NodeList children;
        Node parentNode;
        class ParameterTester
        implements FindNodeUtil.Tester {
            ParameterTester() {
            }

            @Override
            public boolean isTarget(Node node) {
                return JsfNodeListPicker.this.isParameterField(node);
            }

            @Override
            public boolean isEnd(Node node) {
                return node == null || StringUtil.belongsToIgnoreCase((String)node.getNodeName(), (String[])JsfNodeListPicker.this.tagNames);
            }
        }
        ParameterTester tester = new ParameterTester();
        if (node != null && (parentNode = this.findParentNode(node)) != null && (children = parentNode.getChildNodes()) != null) {
            HTMLNodeList v = new HTMLNodeList();
            int i = 0;
            while (i < children.getLength()) {
                v.add(FindNodeUtil.findDescendant(children.item(i), tester));
                ++i;
            }
            return v.getLength() > 0 ? v : null;
        }
        return null;
    }

    public NodeList pickup(Node node) {
        Node selectNode;
        int targetType = this.getType(node, this.tagNames);
        HTMLNodeList nodeList = new HTMLNodeList();
        if ((targetType & 1) == 1 && (selectNode = this.findParentNode(node)) != null) {
            nodeList.add(selectNode);
        }
        if ((targetType & 2) == 2) {
            nodeList.add(this.findParameterNodeList(node));
        }
        return nodeList;
    }

    private int getType(Node node, String[] names) {
        int type = 0;
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                type |= this.getType(node, names[i]);
                ++i;
            }
        }
        return type;
    }

    private int getType(Node node, String name) {
        if (name != null && this.tagNames != null) {
            if (FindNodeUtil.isSameTagName(node, name, this.tagNames[0])) {
                return 1;
            }
            int i = 1;
            while (i < this.tagNames.length) {
                if (FindNodeUtil.isSameTagName(node, name, this.tagNames[i])) {
                    return 2;
                }
                ++i;
            }
        } else {
            return 2;
        }
        return 0;
    }

    public boolean isParameterField(Node node) {
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        if (this.tagNames != null && this.tagNames.length > 1 && this.tagNames[1] == null) {
            return true;
        }
        String name = node.getNodeName();
        int i = 1;
        while (i < this.tagNames.length) {
            if (name.equals(this.tagNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

