/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.utils.WidgetUtil;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.facesconfig.util.FacesResourceChangeListener;
import com.ibm.etools.jsf.facesconfig.util.IFacesConfigChangeEvent;
import com.ibm.etools.jsf.facesconfig.util.IFacesConfigChangeListener;
import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.FindNodeUtil;
import com.ibm.etools.jsf.support.dialogs.NavigationEditDialog;
import com.ibm.etools.jsf.support.dialogs.SelectFacesActionDialog;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.faces.FacesAction;
import com.ibm.etools.references.web.faces.FacesLinkUtil;
import com.ibm.etools.webedit.common.attrview.HTMLNodeSelection;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.RedirectType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NavigationRuleTablePart
extends AVPart
implements IFacesConfigChangeListener {
    private static final String ADD = Messages.Navigation_Add_7;
    private static final String DELETE = Messages.Navigation_Delete_9;
    private static final String EDIT = Messages.Navigation_Edit_8;
    private static final String OUTCOME = Messages.UI_PROPPAGE_Navigation_Alias_2;
    private static final String ACTION = Messages.UI_PROPPAGE_Navigation_ActionRef_3;
    private static final String PAGE = Messages.UI_PROPPAGE_Navigation_ToPage_4;
    private static final String TYPE = "Type";
    private static final String CONFIGFILE = "ConfigFile";
    private static final String TYPE_GLOBAL = "Global";
    private static final String TYPE_PAGE = "Page";
    private static final String REDIRECT = "Redirect";
    private static final String REDIRECT_YES = "Yes";
    private static final String REDIRECT_NO = "No";
    private static final String[] COLUMNS = new String[]{OUTCOME, PAGE, ACTION};
    private static final int[] COLUMNSIZES = new int[]{120, 100, 100};
    private Tree tree;
    private TreeColumn[] treeColumns;
    private Composite buttonContainer;
    private Button addButton;
    private Button deleteButton;
    private Button editButton;
    private int nCurrentTableWidth = 0;
    private String currentPageName = null;
    private CCombo actionCombo;
    private Button actionButton;
    private String oldActionValue;
    protected Menu menu;
    private MenuItem selectItem;
    private MenuItem qevItem;

    public NavigationRuleTablePart(AVData data, Composite parent, String title) {
        super(data, parent, title);
        this.createContents(parent);
    }

    protected void createContents(Composite parent) {
        Composite actionContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), parent, 3, false, 0, 0);
        JsfWidgetUtil.createLabel((AVWidgetFactory)this.getWidgetFactory(), (Composite)actionContainer, (String)Messages.NavigationRuleTablePart_ActionOrOutcome);
        this.actionCombo = JsfWidgetUtil.createCombo((AVWidgetFactory)this.getWidgetFactory(), (Composite)actionContainer, (boolean)true, (boolean)false);
        this.actionCombo.addSelectionListener((SelectionListener)this);
        this.actionCombo.addModifyListener((ModifyListener)this);
        this.actionCombo.addFocusListener((FocusListener)this);
        this.actionCombo.addKeyListener((KeyListener)this);
        this.actionCombo.addMouseListener((MouseListener)this);
        this.actionButton = JsfWidgetUtil.createImageButton(this.getWidgetFactory(), actionContainer, "qev_edit", Messages.NavigationRuleTablePart_SelectOrCode, Messages.NavigationRuleTablePart_SelectOrCode);
        this.actionButton.addSelectionListener((SelectionListener)this);
        String caption = Messages.UI_PROPPAGE_Navigation_Label_5;
        JsfWidgetUtil.createLabel((AVWidgetFactory)this.getWidgetFactory(), (Composite)parent, (String)caption);
        Composite tableButtonContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), parent, 2, false, 0, 0);
        GridLayout layout = (GridLayout)tableButtonContainer.getLayout();
        layout.marginHeight = 7;
        tableButtonContainer.setLayout((Layout)layout);
        Composite tableContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), tableButtonContainer, 1, false, 0, 0);
        this.buttonContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), tableButtonContainer, 1, false, 0, 2);
        layout = (GridLayout)this.buttonContainer.getLayout();
        layout.verticalSpacing = 0;
        this.buttonContainer.setLayout((Layout)layout);
        GridData gridData = (GridData)this.buttonContainer.getLayoutData();
        gridData.horizontalAlignment = 128;
        gridData.grabExcessHorizontalSpace = false;
        this.buttonContainer.setLayoutData((Object)gridData);
        this.tree = new Tree(tableContainer, 65540);
        gridData = new GridData(770);
        gridData.heightHint = 70;
        this.tree.setLayoutData((Object)gridData);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.treeColumns = new TreeColumn[this.getColumnNames().length];
        int i = 0;
        while (i < this.getColumnNames().length) {
            this.treeColumns[i] = new TreeColumn(this.tree, 0x800000);
            this.treeColumns[i].setText(this.getColumnNames()[i]);
            this.treeColumns[i].setWidth(this.getColumnSizes()[i]);
            ++i;
        }
        this.tree.addSelectionListener((SelectionListener)this);
        this.tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                NavigationRuleTablePart.this.handleTableResized();
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int count;
                int count0 = count = NavigationRuleTablePart.this.tree.getSelectionCount();
                TreeItem[] selection = NavigationRuleTablePart.this.tree.getSelection();
                int i = 0;
                while (i < count0) {
                    String itemType = (String)selection[i].getData(NavigationRuleTablePart.TYPE);
                    if (itemType == null) {
                        --count;
                    }
                    ++i;
                }
                if (count == 1) {
                    NavigationRuleTablePart.this.handleEditButton(null);
                }
            }
        });
        this.createButtons();
        FacesResourceChangeListener.getFacesResourceChangeListener().addFacesConfigChangeListener((IFacesConfigChangeListener)this);
    }

    protected void createButtons() {
        GridData gridData = new GridData();
        gridData.heightHint = JsfWidgetUtil.getButtonHeight(19);
        this.addButton = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.buttonContainer, (String)ADD, (int)8, (GridData)gridData);
        gridData = new GridData();
        gridData.heightHint = JsfWidgetUtil.getButtonHeight(19);
        this.deleteButton = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.buttonContainer, (String)DELETE, (int)8, (GridData)gridData);
        gridData = new GridData();
        gridData.heightHint = JsfWidgetUtil.getButtonHeight(19);
        this.editButton = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.buttonContainer, (String)EDIT, (int)8, (GridData)gridData);
        WidgetUtil.alignWidth((Control[])new Control[]{this.addButton, this.deleteButton, this.editButton});
        this.addButton.addSelectionListener((SelectionListener)this);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        this.editButton.addSelectionListener((SelectionListener)this);
    }

    protected void addEntry(String[] values) {
    }

    protected void editEntry(int row, int column, String value) {
    }

    protected CellEditor[] getCellEditors() {
        return new CellEditor[3];
    }

    protected String[] getColumnNames() {
        return COLUMNS;
    }

    protected String[] getMenuColumnNames() {
        return COLUMNS;
    }

    protected int[] getColumnSizes() {
        return COLUMNSIZES;
    }

    protected String[] createInitialValues() {
        return null;
    }

    protected void update() {
        this.setValid(true);
        this.fillNavigationRules();
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            String value = data.getValue();
            this.actionCombo.setText(value);
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.editButton) {
            this.handleEditButton(e);
        } else if (e.widget == this.addButton) {
            this.handleAddButton(e);
        } else if (e.widget == this.deleteButton) {
            this.handleDeleteButton(e);
        } else if (e.widget == this.actionButton) {
            this.handleActionButton(e);
        } else if (e.widget == this.selectItem) {
            this.handleSelectActionMenuItem(e);
        } else if (e.widget == this.qevItem) {
            this.handleQEVMenuItem(e);
        } else if (e.widget == this.tree) {
            this.enableButtons();
        } else if (e.widget == this.actionCombo && !((CCombo)e.widget).getText().equals(this.oldActionValue)) {
            this.oldActionValue = ((CCombo)e.widget).getText();
            if (this.isAmbiguous()) {
                this.setAmbiguous(false);
            }
            this.setModified(true);
            this.fireValueChange();
        }
        super.widgetSelected(e);
    }

    protected void handleAddButton(SelectionEvent e) {
        String baseLoc;
        boolean bIsTemplate = false;
        Node currentNode = this.findCommandNode(((HTMLNodeSelection)this.getPage().getSelection()).getNodeList().item(0));
        if (currentNode == null) {
            return;
        }
        if (currentNode instanceof IDOMNode && (baseLoc = ((IDOMNode)currentNode).getModel().getBaseLocation()) != null && baseLoc.endsWith(".jtpl")) {
            bIsTemplate = true;
        }
        NavigationEditDialog dialog = new NavigationEditDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, null, false, false, bIsTemplate);
        dialog.setActionRefList(this.getActionRefList());
        dialog.open();
    }

    protected void handleEditButton(SelectionEvent e) {
        String baseLoc;
        boolean bIsTemplate = false;
        Node currentNode = this.findCommandNode(((HTMLNodeSelection)this.getPage().getSelection()).getNodeList().item(0));
        if (currentNode == null) {
            return;
        }
        if (currentNode instanceof IDOMNode && (baseLoc = ((IDOMNode)currentNode).getModel().getBaseLocation()) != null && baseLoc.endsWith(".jtpl")) {
            bIsTemplate = true;
        }
        TreeItem[] selection = this.tree.getSelection();
        String sOldOutcome = selection[0].getText(0);
        String sOldActionRef = selection[0].getText(2);
        String sOldToPage = selection[0].getText(1);
        boolean bOldIsGlobal = selection[0].getData(TYPE).toString().equals(TYPE_GLOBAL);
        boolean bOldIsRedirect = selection[0].getData(REDIRECT).toString().equals(REDIRECT_YES);
        String configFileName = selection[0].getData(CONFIGFILE).toString();
        NavigationEditDialog dialog = new NavigationEditDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), sOldOutcome, sOldActionRef, sOldToPage, bOldIsGlobal, bOldIsRedirect, bIsTemplate, configFileName);
        dialog.setActionRefList(this.getActionRefList());
        dialog.open();
    }

    protected void handleDeleteButton(SelectionEvent e) {
        block14: {
            if (!MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.Navigation_ConfirmRemove, (String)Messages.Navigation_Remove)) {
                return;
            }
            TreeItem[] selection = this.tree.getSelection();
            String sOldOutcome = selection[0].getText(0);
            String sOldActionRef = selection[0].getText(2);
            String sOldToPage = selection[0].getText(1);
            boolean bIsGlobal = selection[0].getData(TYPE).toString().equals(TYPE_GLOBAL);
            String configFileName = selection[0].getData(CONFIGFILE).toString();
            FacesConfigArtifactEdit edit = null;
            String currentPageName = this.getCurrentPageName();
            if (currentPageName == null) {
                return;
            }
            try {
                edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)JsfProjectUtil.getProject(), (String)configFileName);
                if (edit.getFacesConfig() == null) break block14;
                EList navRules = edit.getFacesConfig().getNavigationRule();
                boolean bFound = false;
                int i = 0;
                while (i < navRules.size()) {
                    String sFromTreeId;
                    NavigationRuleType navRule = (NavigationRuleType)navRules.get(i);
                    String string = sFromTreeId = navRule.getFromViewId() != null ? navRule.getFromViewId().getTextContent() : null;
                    if ((sFromTreeId != null && !sFromTreeId.equals("") || bIsGlobal) && (sFromTreeId == null || sFromTreeId.equals("") || !bIsGlobal) && (bIsGlobal || currentPageName.equalsIgnoreCase(sFromTreeId))) {
                        EList navCases = navRule.getNavigationCase();
                        int j = 0;
                        while (j < navCases.size()) {
                            String sToPage;
                            String sActionRef;
                            String sOutcome;
                            NavigationCaseType navCase = (NavigationCaseType)navCases.get(j);
                            String string2 = sOutcome = navCase.getFromOutcome() != null ? navCase.getFromOutcome().getTextContent() : null;
                            if (sOutcome == null || sOutcome.equals("")) {
                                sOutcome = NavigationEditDialog.ANYOUTCOME;
                            }
                            String string3 = sActionRef = navCase.getFromAction() != null ? navCase.getFromAction().getTextContent() : null;
                            if (sActionRef == null || sActionRef.equals("")) {
                                sActionRef = NavigationEditDialog.ANYACTION;
                            }
                            String string4 = sToPage = navCase.getToViewId() != null ? navCase.getToViewId().getTextContent() : null;
                            if (sOutcome.equals(sOldOutcome) && sActionRef.equals(sOldActionRef) && sToPage != null && sToPage.equals(sOldToPage)) {
                                navCases.remove((Object)navCase);
                                if (navCases.size() == 0) {
                                    navRules.remove((Object)navRule);
                                }
                                edit.save(null);
                                bFound = true;
                                break;
                            }
                            ++j;
                        }
                        if (bFound) {
                            break;
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
    }

    private void fillNavigationRules() {
        block25: {
            Node currentNode = this.findCommandNode(((HTMLNodeSelection)this.getPage().getSelection()).getNodeList().item(0));
            if (currentNode == null) {
                return;
            }
            this.tree.removeAll();
            this.actionCombo.removeAll();
            boolean bIsFirstPageItem = true;
            boolean bIsFirstGlobalItem = true;
            boolean bIsThisPage = true;
            TreeItem pageItem = null;
            TreeItem globalItem = null;
            if (!(currentNode instanceof IDOMNode)) break block25;
            FacesConfigArtifactEdit edit = null;
            String currentPageName = this.getCurrentPageName();
            if (currentPageName == null) {
                return;
            }
            IProject project = JsfProjectUtil.getProject();
            String[] configFileNames = JSFFacesConfigUtil.getFacesConfigPaths((IProject)project);
            int numOfArtifactEdits = 0;
            while (numOfArtifactEdits < 2) {
                int numOfConfigFiles = 0;
                while (numOfConfigFiles < configFileNames.length) {
                    block24: {
                        try {
                            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)project, (String)configFileNames[numOfConfigFiles]);
                            if (edit == null || edit.getFacesConfig() == null) break block24;
                            EList navRules = edit.getFacesConfig().getNavigationRule();
                            int num = 0;
                            while (num < 4) {
                                int i = 0;
                                while (i < navRules.size()) {
                                    block28: {
                                        NavigationRuleType navRule;
                                        block27: {
                                            String sFromTreeId;
                                            block26: {
                                                navRule = (NavigationRuleType)navRules.get(i);
                                                String string = sFromTreeId = navRule.getFromViewId() != null ? navRule.getFromViewId().getTextContent() : null;
                                                if (sFromTreeId != null && !sFromTreeId.equals("")) break block26;
                                                bIsThisPage = false;
                                                break block27;
                                            }
                                            if (!currentPageName.equalsIgnoreCase(sFromTreeId)) break block28;
                                            bIsThisPage = true;
                                        }
                                        EList navCases = navRule.getNavigationCase();
                                        int j = 0;
                                        while (j < navCases.size()) {
                                            block29: {
                                                TreeItem tableItem;
                                                String sToPage;
                                                String sActionRef;
                                                String sOutcome;
                                                NavigationCaseType navCase;
                                                block31: {
                                                    block30: {
                                                        navCase = (NavigationCaseType)navCases.get(j);
                                                        sOutcome = navCase.getFromOutcome() != null ? navCase.getFromOutcome().getTextContent() : null;
                                                        String string = sActionRef = navCase.getFromAction() != null ? navCase.getFromAction().getTextContent() : null;
                                                        if (num == 0 && (sOutcome == null || sOutcome.equals("") || sActionRef == null || sActionRef.equals("")) || num == 1 && (sOutcome == null || sOutcome.equals("") || sActionRef != null && !sActionRef.equals("")) || num == 2 && (sOutcome != null && !sOutcome.equals("") || sActionRef == null || sActionRef.equals("")) || num == 3 && (sOutcome != null && !sOutcome.equals("") || sActionRef != null && !sActionRef.equals(""))) break block29;
                                                        String string2 = sToPage = navCase.getToViewId() != null ? navCase.getToViewId().getTextContent() : null;
                                                        if (!bIsThisPage) break block30;
                                                        if (numOfArtifactEdits == 0) break block29;
                                                        if (bIsFirstPageItem) {
                                                            pageItem = new TreeItem(this.tree, 0);
                                                            pageItem.setText(Messages.Navigation_PageString_3);
                                                            bIsFirstPageItem = false;
                                                        }
                                                        tableItem = new TreeItem(pageItem, 0);
                                                        tableItem.setData(TYPE, (Object)TYPE_PAGE);
                                                        tableItem.setData(CONFIGFILE, (Object)configFileNames[numOfConfigFiles]);
                                                        break block31;
                                                    }
                                                    if (numOfArtifactEdits == 1) break block29;
                                                    if (bIsFirstGlobalItem) {
                                                        globalItem = new TreeItem(this.tree, 0);
                                                        globalItem.setText(Messages.Navigation_GlobalString_4);
                                                        bIsFirstGlobalItem = false;
                                                    }
                                                    tableItem = new TreeItem(globalItem, 0);
                                                    tableItem.setData(TYPE, (Object)TYPE_GLOBAL);
                                                    tableItem.setData(CONFIGFILE, (Object)configFileNames[numOfConfigFiles]);
                                                }
                                                RedirectType redirect = navCase.getRedirect();
                                                if (redirect != null) {
                                                    tableItem.setData(REDIRECT, (Object)REDIRECT_YES);
                                                } else {
                                                    tableItem.setData(REDIRECT, (Object)REDIRECT_NO);
                                                }
                                                if (sOutcome == null || sOutcome.equals("")) {
                                                    tableItem.setText(NavigationEditDialog.ANYOUTCOME);
                                                } else {
                                                    tableItem.setText(sOutcome);
                                                    this.actionCombo.add(sOutcome);
                                                }
                                                if (sActionRef == null || sActionRef.equals("")) {
                                                    tableItem.setText(2, NavigationEditDialog.ANYACTION);
                                                } else {
                                                    tableItem.setText(2, sActionRef);
                                                }
                                                if (sToPage != null) {
                                                    tableItem.setText(1, sToPage);
                                                }
                                            }
                                            ++j;
                                        }
                                    }
                                    ++i;
                                }
                                ++num;
                            }
                        }
                        finally {
                            if (edit != null) {
                                edit.dispose();
                            }
                        }
                    }
                    ++numOfConfigFiles;
                }
                ++numOfArtifactEdits;
            }
        }
        TreeItem[] tableItems = this.tree.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TreeItem item = tableItems[i];
            item.setExpanded(true);
            ++i;
        }
        this.enableButtons();
    }

    private String getCurrentPageName() {
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        if (actionTarget == null) {
            return this.currentPageName;
        }
        IProject project = JsfProjectUtil.getProject();
        String root = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getFullPath().toString();
        String fullPath = actionTarget.getActiveModel().getBaseLocation();
        String currentPageName = null;
        int index = fullPath.indexOf(root);
        currentPageName = index != -1 ? fullPath.substring(index + root.length()) : fullPath;
        this.currentPageName = currentPageName;
        return currentPageName;
    }

    public String[] getActionRefList() {
        String sRef = null;
        Node node = this.findCommandNode(((HTMLNodeSelection)this.getPage().getSelection()).getNodeList().item(0));
        if (node == null) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        int j = 0;
        while (j < attrs.getLength()) {
            Node attribute = attrs.item(j);
            if (attribute.getNodeName().equalsIgnoreCase("action")) {
                sRef = attribute.getNodeValue();
                break;
            }
            ++j;
        }
        if (sRef != null) {
            return new String[]{sRef};
        }
        return new String[0];
    }

    protected void enableButtons() {
        int count;
        int count0 = count = this.tree.getSelectionCount();
        TreeItem[] selection = this.tree.getSelection();
        int i = 0;
        while (i < count0) {
            String itemType = (String)selection[i].getData(TYPE);
            if (itemType == null) {
                --count;
            }
            ++i;
        }
        this.editButton.setEnabled(count == 1);
        this.deleteButton.setEnabled(count > 0);
    }

    protected void handleTableResized() {
        if (this.tree == null) {
            return;
        }
        int width = this.tree.getSize().x - 20;
        if (width == this.nCurrentTableWidth) {
            return;
        }
        this.nCurrentTableWidth = width;
        int totalWidth = 0;
        int i = 0;
        while (i < this.getColumnSizes().length) {
            totalWidth += this.getColumnSizes()[i];
            ++i;
        }
        if (totalWidth == 0) {
            return;
        }
        i = 0;
        while (i < this.getColumnSizes().length && i < this.tree.getColumnCount()) {
            int columnWidth = width * this.getColumnSizes()[i] / totalWidth;
            if (columnWidth < 50) {
                columnWidth = 50;
            }
            this.tree.getColumn(i).setWidth(columnWidth);
            ++i;
        }
    }

    protected Node findCommandNode(Node node) {
        return FindNodeUtil.findAncestor(node, new String[]{"commandLink", "commandButton", "commandExButton", "commandExRowAction", "commandExRowEdit", "requestLink", "requestRowAction"}, new String[]{"scriptCollector"});
    }

    public void resourceChanged(IFacesConfigChangeEvent event) {
        Display curDisplay = Display.getDefault();
        if (curDisplay != null) {
            curDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    NavigationRuleTablePart.this.update();
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        NavigationRuleTablePart.dispose((Widget)this.actionCombo);
        NavigationRuleTablePart.dispose((Widget)this.addButton);
        NavigationRuleTablePart.dispose((Widget)this.deleteButton);
        NavigationRuleTablePart.dispose((Widget)this.actionButton);
        NavigationRuleTablePart.dispose((Widget)this.qevItem);
        NavigationRuleTablePart.dispose((Widget)this.selectItem);
        NavigationRuleTablePart.dispose((Widget)this.menu);
        NavigationRuleTablePart.dispose((Widget)this.tree);
        FacesResourceChangeListener.getFacesResourceChangeListener().removeFacesConfigChangeListener((IFacesConfigChangeListener)this);
    }

    protected void handleActionButton(SelectionEvent e) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu((Control)this.actionButton);
            this.selectItem = new MenuItem(this.menu, 8);
            this.selectItem.setText(Messages.NavigationRuleTablePart_SelectAction);
            this.selectItem.addSelectionListener((SelectionListener)this);
            this.qevItem = new MenuItem(this.menu, 8);
            this.qevItem.setText(Messages.NavigationRuleTablePart_CodeAction);
            this.qevItem.addSelectionListener((SelectionListener)this);
        }
        Point p = this.actionButton.getLocation();
        Rectangle r = this.actionButton.getBounds();
        p.y += r.height;
        p = this.actionButton.getParent().toDisplay(p);
        this.menu.setLocation(p.x, p.y);
        this.menu.setVisible(true);
    }

    private void handleSelectActionMenuItem(SelectionEvent e) {
        Object[] result;
        SelectFacesActionDialog dlg;
        ILink pagecodeBean = null;
        IProject project = JsfProjectUtil.getProject();
        HTMLEditDomain editDomain = EditDomainUtil.getEditDomain();
        if (editDomain != null) {
            IDOMDocument doc = editDomain.getActiveModel().getDocument();
            String pagecodeBeanName = CodeBehindUtil.getManagedBeanName((IDOMDocument)doc);
            pagecodeBean = FacesLinkUtil.getManagedBeanLink((String)pagecodeBeanName, (IProject)project);
        }
        if ((dlg = new SelectFacesActionDialog(this.getParent().getShell(), project, pagecodeBean)).open() == 0 && (result = dlg.getResult()) != null && result.length > 0) {
            FacesAction selectedAction = (FacesAction)result[0];
            String actionStr = "#{" + selectedAction.getBeanActionName() + "}";
            this.actionCombo.setText(actionStr);
            this.setModified(true);
            this.fireValueChange();
            this.getPage().updateData(this.getDataComponent().getSelection().getEditorContextProvider());
        }
    }

    private void handleQEVMenuItem(SelectionEvent e) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("com.ibm.etools.qev.view.QEVView");
        }
        catch (PartInitException partInitException) {}
    }

    public String getValue() {
        String value = this.actionCombo.getText();
        if (value != null && value.length() > 0) {
            return value;
        }
        return null;
    }
}

