/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.utils.WidgetUtil;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.attrview.pages.JsfPage;
import com.ibm.etools.jsf.palette.commands.InsertAsChildCommand;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.palette.commands.JsfCompoundCommand;
import com.ibm.etools.jsf.palette.commands.RestoreRangeCommand;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import com.ibm.etools.webedit.common.attrview.pages.HTMLPage;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.RangeCommand;
import com.ibm.etools.webedit.common.commands.factories.CustomTagFactory;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.editor.attrview.parts.DirectNodeListEditorPart;
import java.util.Map;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public abstract class JsfTableEditorPart
extends DirectNodeListEditorPart {
    protected Composite buttonContainer;
    protected Label label;
    private boolean _bFirstUpdateAfterAdd = false;
    private int _newIndex = 0;
    protected Node dataNode = null;
    protected Node pageNode = null;
    private String name = "";
    private int nCurrentTableWidth = 0;

    public JsfTableEditorPart(AVData data, Composite parent, String title, boolean check, boolean multiple, boolean updown, String labelText) {
        super(data, parent, title, check, multiple, updown);
        if (this.label != null && labelText != null) {
            this.label.setText(labelText);
        }
    }

    protected void createLabel(Composite container) {
        this.label = WidgetUtil.createLabel((AVWidgetFactory)this.getWidgetFactory(), (Composite)container, (String)"");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.label.setLayoutData((Object)gridData);
    }

    protected void createContents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 1;
        gridLayout.makeColumnsEqualWidth = true;
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        this.initializeContainer(1, true);
        this.getContainer().setLayout((Layout)gridLayout);
        this.getContainer().setLayoutData((Object)gd);
        this.createLabel(this.getContainer());
        Composite tableContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), this.getContainer(), 2, false, 0, 0);
        GridData gridData0 = new GridData();
        gridData0.grabExcessHorizontalSpace = true;
        gridData0.horizontalAlignment = 4;
        tableContainer.setLayoutData((Object)gridData0);
        this.table = this.getWidgetFactory().createTable(tableContainer, 65540);
        GridData gridData = new GridData(770);
        gridData.heightHint = 100;
        gridData.widthHint = 100;
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        int i = 0;
        while (i < this.getColumnNames().length) {
            TableColumn col = WidgetUtil.createTableColumn((AVWidgetFactory)this.getWidgetFactory(), (Table)this.table, (int)0);
            col.setText(this.getColumnNames()[i]);
            col.setWidth(this.getColumnSizes()[i]);
            ++i;
        }
        this.table.addSelectionListener((SelectionListener)this);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(this.name));
        this.buttonContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), tableContainer, 1, false, 0, 2);
        GridLayout layout = (GridLayout)this.buttonContainer.getLayout();
        layout.verticalSpacing = 0;
        this.buttonContainer.setLayout((Layout)layout);
        gridData = (GridData)this.buttonContainer.getLayoutData();
        gridData.horizontalAlignment = 128;
        gridData.grabExcessHorizontalSpace = false;
        this.buttonContainer.setLayoutData((Object)gridData);
        this.createButtons();
        this.prepareDirectEditing();
        this.createCellEditors();
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                JsfTableEditorPart.this.handleTableResized();
            }
        });
    }

    protected void addEntry(String tagName, String cmdName, Map<String, String> attrs, boolean appendChild) {
        HTMLEditDomain actionTarget = ActionUtil.getActiveHTMLEditDomain();
        if (actionTarget == null) {
            return;
        }
        IDOMDocument page = actionTarget.getActiveModel().getDocument();
        Node parentNode = this.dataNode;
        if (this.dataNode == null) {
            AVSelection selection = this.getPage().getSelection();
            NodeList nodeList = this.getJsfPage().getNodeListPicker(this.getDataComponent()).pickup((NodeSelection)selection);
            parentNode = nodeList.item(0);
        }
        JsfCommandUtil.setSelectedNode(parentNode);
        JsfCompoundCommand command = new JsfCompoundCommand(cmdName);
        CustomTagFactory factory = this.getJsfPage().createCustomTagFactory(tagName, attrs);
        command.append((HTMLCommand)new InsertAsChildCommand((NodeFactory)factory, parentNode, appendChild));
        this.deactivateCellEditor();
        Node nodeToSelect = this.pageNode;
        if (this.pageNode == null) {
            nodeToSelect = parentNode;
        }
        Range newRange = ((DocumentRange)page).createRange();
        newRange.setStart(nodeToSelect, 0);
        newRange.setEnd(nodeToSelect, 0);
        command.append((HTMLCommand)new RestoreRangeCommand(newRange));
        ((HTMLPage)this.getPage()).launchCommand((RangeCommand)command);
    }

    protected void addEntry(String tagName, String cmdName, Map<String, String> attrs) {
        this.addEntry(tagName, cmdName, attrs, true);
    }

    protected void createCellEditors() {
    }

    protected abstract String[] getMenuColumnNames();

    protected JsfPage getJsfPage() {
        return (JsfPage)this.getDataComponent().getPage();
    }

    protected void handleTableResized() {
        if (this.table == null) {
            return;
        }
        int width = this.table.getSize().x - 20;
        if (width == this.nCurrentTableWidth) {
            return;
        }
        this.nCurrentTableWidth = width;
        int totalWidth = 0;
        int i = 0;
        while (i < this.getColumnSizes().length) {
            totalWidth += this.getColumnSizes()[i];
            ++i;
        }
        if (totalWidth == 0) {
            return;
        }
        this.table.setRedraw(false);
        i = 0;
        while (i < this.getColumnSizes().length) {
            int columnWidth = width * this.getColumnSizes()[i] / totalWidth;
            if (columnWidth < 50) {
                columnWidth = 50;
            }
            this.table.getColumn(i).setWidth(columnWidth);
            ++i;
        }
        this.table.setRedraw(true);
    }

    public void setEnabled(boolean enabled) {
        this.table.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.enableButtons();
    }

    public void doAdd() {
        this.addEntry(this.createInitialValues());
        int newIndex = this.table.getItemCount();
        if (this.table.getSelectionCount() > 0) {
            this.table.deselectAll();
        }
        this.table.select(newIndex);
        this.setRowSelectionIndex(new int[]{newIndex});
        this.setColumnSelectionIndex(new int[]{this.getColumnAddIndex()});
    }

    protected boolean needAddContextMenu() {
        return false;
    }

    protected boolean needDeleteContextMenu() {
        return false;
    }

    protected boolean needUpDownContextMenu() {
        return false;
    }

    protected void addEntry(String[] values) {
        if (values != null) {
            this._bFirstUpdateAfterAdd = true;
            this._newIndex = this.table.getItemCount();
        }
    }

    protected void update() {
        super.update();
        if (this._bFirstUpdateAfterAdd) {
            int newColumnIndex;
            this._bFirstUpdateAfterAdd = false;
            if (this.table.getItemCount() > this._newIndex && (newColumnIndex = this.getColumnAddIndex()) != -1) {
                this.activateCellEditor(this.table.getItem(this._newIndex), this._newIndex, newColumnIndex);
            }
        }
    }

    public void setDataNode(Node node) {
        this.dataNode = node;
    }

    public void setPageNode(Node node) {
        this.pageNode = node;
    }

    public void dispose() {
        this.dataNode = null;
        this.pageNode = null;
        super.dispose();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void applyEditorValue() {
        if (this.currentCellEditor != null) {
            String newValue;
            int column = this.tableEditor.getColumn();
            if (column < 0) {
                return;
            }
            if (this.currentCellEditor.isValueValid() && this.checkCellValue(newValue = (String)this.currentCellEditor.getValue(), column)) {
                if (this.add) {
                    String[] values = this.createInitialValues();
                    values[column] = newValue;
                    this.addEntry(values);
                } else {
                    this.editEntry(this.currentSelection, column, newValue);
                    this.table.getItem(this.currentSelection).setText(column, newValue);
                }
            }
        }
        this.deactivateCellEditor();
    }
}

