/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVEditableComboPart;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class ConverterPatternButtonPart
extends AVPart {
    private Button button;
    private int patternType;
    private AVEditableComboPart comboPart;

    public ConverterPatternButtonPart(AVData data, Composite parent, int patternType, AVEditableComboPart comboPart) {
        super(data, parent);
        this.createContents();
        this.patternType = patternType;
        this.comboPart = comboPart;
    }

    protected void createContents() {
        this.button = JsfWidgetUtil.createImageButton(this.getWidgetFactory(), this.getParent(), "browse_pattern", Messages.BuildPattern, Messages.BuildPattern);
        this.button.addFocusListener((FocusListener)this);
        this.button.addSelectionListener((SelectionListener)this);
    }

    protected void removeListeners() {
        super.removeListeners();
        if (this.button != null) {
            this.button.removeFocusListener((FocusListener)this);
            this.button.removeSelectionListener((SelectionListener)this);
        }
    }

    protected void addListeners() {
        super.addListeners();
        if (this.button != null) {
            this.button.addFocusListener((FocusListener)this);
            this.button.addSelectionListener((SelectionListener)this);
        }
    }

    protected void update() {
    }

    public void widgetSelected(SelectionEvent e) {
        PatternBuilderDialog dlg = new PatternBuilderDialog(this.getParent().getShell(), this.patternType);
        dlg.setAttrVal(this.getValue(), null);
        if (dlg.open() == 0) {
            this.comboPart.setString(dlg.getAttrVal());
            this.setModified(true);
            this.comboPart.getComboControl().setFocus();
            this.fireValueChange();
            this.getPage().updateData(this.getDataComponent().getSelection().getEditorContextProvider());
        }
    }

    public void dispose() {
        super.dispose();
        ConverterPatternButtonPart.dispose((Widget)this.button);
        this.button = null;
    }

    public Button getButtonControl() {
        return this.button;
    }

    public void setAmbiguous(boolean ambiguous) {
        super.setAmbiguous(ambiguous);
        if (ambiguous) {
            this.button.setSelection(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(this.isEnabled());
    }

    public String getValue() {
        return this.comboPart.getValue();
    }
}

