/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.utils.WidgetUtil;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.attrview.pages.JsfPage;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.JsfConverter;
import com.ibm.etools.jsf.support.MaskConverterProperties;
import com.ibm.etools.jsf.support.PatternBeanManager;
import com.ibm.etools.jsf.support.dialogs.ConfigureConverterDialog;
import com.ibm.etools.jsf.support.dialogs.ConfigureCustomConverterDialog;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import java.util.Map;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigConverterButtonPart
extends AVPart {
    protected Button button;
    protected JsfConverter converter;
    protected Node currentConverter = null;
    private String value = null;

    public ConfigConverterButtonPart(AVData data, Composite parent, JsfConverter converter) {
        super(data, parent);
        this.converter = converter;
        this.createContents();
    }

    protected void createContents() {
        this.button = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.getParent(), null, (int)0x800000, null);
        this.button.setText(Messages.ConfigConverterButtonPart__Options_1);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.heightHint = JsfWidgetUtil.getButtonHeight(18);
        this.button.setLayoutData((Object)gd);
        this.button.addFocusListener((FocusListener)this);
        this.button.addSelectionListener((SelectionListener)this);
    }

    protected void removeListeners() {
        super.removeListeners();
        if (this.button != null) {
            this.button.removeFocusListener((FocusListener)this);
            this.button.removeSelectionListener((SelectionListener)this);
        }
    }

    protected void addListeners() {
        super.addListeners();
        if (this.button != null) {
            this.button.addFocusListener((FocusListener)this);
            this.button.addSelectionListener((SelectionListener)this);
        }
    }

    protected void update() {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.button.getText().equals(Messages.ConfigConverterButtonPart__Options_1)) {
            ConfigureConverterDialog dlg = new ConfigureConverterDialog(this.getParent().getShell());
            dlg.setTitleText(Messages.ConfigConverterButtonPart_Configure_Converter_2);
            dlg.setConverter(this.converter);
            if (dlg.open() == 0) {
                Map attrs = dlg.getConverter().getAttributesMap();
                if (this.currentConverter != null) {
                    Element ele = (Element)this.currentConverter;
                    String[] attrNames = this.converter.getConverterAttributes();
                    int i = 0;
                    while (i < attrNames.length) {
                        ele.removeAttribute(attrNames[i]);
                        ++i;
                    }
                    if (!attrs.isEmpty()) {
                        ((JsfPage)this.getPage()).editTag(this.currentConverter, attrs);
                    }
                }
            }
        } else if (this.button.getText().equals(Messages.ConfigConverterButtonPart__Edit_3)) {
            PatternBeanManager beanManager = new PatternBeanManager(JsfProjectUtil.getCurrentPageResource());
            ConfigureCustomConverterDialog dlg = new ConfigureCustomConverterDialog(this.getParent().getShell(), false);
            dlg.setTitleText(Messages.ConfigConverterButtonPart_Configure_Converter_2);
            if (this.getValue() != null && beanManager.getEditableCustomConverters().get(this.value) != null) {
                MaskConverterProperties maskConverterProperties = (MaskConverterProperties)beanManager.getEditableCustomConverters().get(this.value);
                dlg.setConverter(maskConverterProperties);
            }
            dlg.open();
        }
        super.widgetSelected(e);
    }

    public void dispose() {
        super.dispose();
        ConfigConverterButtonPart.dispose((Widget)this.button);
        this.button = null;
    }

    public Button getButtonControl() {
        return this.button;
    }

    public void setAmbiguous(boolean ambiguous) {
        super.setAmbiguous(ambiguous);
        if (ambiguous) {
            this.button.setSelection(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(this.isEnabled());
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public JsfConverter getConverter() {
        return this.converter;
    }

    public void setConverter(JsfConverter converter) {
        this.converter = converter;
    }

    public Node getCurrentConverter() {
        return this.currentConverter;
    }

    public void setCurrentConverter(Node currentConverter) {
        this.currentConverter = currentConverter;
    }
}

