/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVFileBrowsePart;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.pagedataview.ui.JsfSelectPageDataDialog;
import com.ibm.etools.jsf.palette.commands.EditNodeAttributesCommand;
import com.ibm.etools.webedit.common.attrview.HTMLNodeSelection;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class BindToPart
extends AVFileBrowsePart {
    private String attributeName = "value";
    private Node targetNode = null;
    private String[] categories = new String[]{"Server Side", "Scripting"};
    protected String tagName;
    protected String attrName;
    protected IPageDataModel model;
    private AVData data = null;
    private String emptyListMessage;
    private boolean output = false;

    public BindToPart(AVData data, Composite parent, String title) {
        super(data, parent, title);
        this.data = data;
    }

    public BindToPart(AVData data, Composite parent, String title, boolean output) {
        this(data, parent, title);
        this.output = output;
    }

    protected void browse(TypedEvent e) {
        Range range;
        HTMLSelectionMediator mediator;
        if (this.model == null) {
            return;
        }
        if (this.categories == null) {
            this.categories = new String[]{"Server Side", "Scripting"};
        }
        this.attributeName = ((AttributeData)this.data).getAttributeName() != null ? ((AttributeData)this.data).getAttributeName() : "value";
        HTMLEditDomain domain = ActionUtil.getActiveHTMLEditDomain();
        if (this.targetNode == null && domain != null && (mediator = domain.getSelectionMediator()) != null && (range = mediator.getRange()) != null) {
            this.targetNode = range.getEndContainer();
        }
        if (this.targetNode == null) {
            return;
        }
        Element target = (Element)this.targetNode;
        String currentValue = target.getAttribute(this.attributeName);
        JsfSelectPageDataDialog dialog = new JsfSelectPageDataDialog(this.getParent().getShell(), this.model, this.categories, this.output, currentValue, this.targetNode, this.attributeName);
        if (this.emptyListMessage != null) {
            dialog.setEmptyListMessage(this.emptyListMessage);
        }
        if (dialog.open() == 0) {
            String value;
            Object cmd = null;
            if (dialog.getSelectedTab() == 0) {
                IPageDataNode pdNode = dialog.getSelectedNode();
                cmd = BindingUtil.generateBindingCommand(this.targetNode, this.attributeName, pdNode, true);
            } else if (dialog.getSelectedTab() == 1) {
                String value2 = dialog.getElEditorResult();
                if (value2 != null) {
                    cmd = new EditNodeAttributesCommand(this.targetNode, this.attributeName, value2);
                }
            } else if (dialog.getSelectedTab() == 2 && (value = dialog.getStringResourceId()) != null) {
                cmd = new EditNodeAttributesCommand(this.targetNode, this.attributeName, value);
            }
            if (cmd != null && domain != null) {
                domain.execCommand((Command)cmd);
                this.getPage().updateData(this.getDataComponent().getSelection().getEditorContextProvider());
                this.update();
            }
        }
    }

    public void update() {
        AVData data = this.getDataComponent();
        this.model = null;
        this.tagName = null;
        this.attrName = null;
        if (data instanceof AttributeData) {
            NodeList nodeList = ((HTMLNodeSelection)data.getSelection()).getNodeList();
            Node node = null;
            if (nodeList != null) {
                int i = 0;
                while (i < nodeList.getLength()) {
                    if (nodeList.item(i) instanceof IDOMNode) {
                        node = (IDOMNode)nodeList.item(i);
                        break;
                    }
                    ++i;
                }
            }
            if (node != null) {
                PageDataModelAdapter adapter = (PageDataModelAdapter)((IDOMNode)node).getModel().getDocument().getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
                if (adapter != null) {
                    this.model = adapter.getPageDataModel();
                }
                this.tagName = node.getNodeName();
                if (data instanceof AttributeData) {
                    this.attrName = ((AttributeData)data).getAttributeName();
                }
            }
        }
        this.setString(data.getValue());
        super.update();
    }

    protected Button createBrowseButton() {
        return JsfWidgetUtil.createImageButton(this.getWidgetFactory(), this.getContainer(), "compute");
    }

    public void setTargetNode(Node node) {
        this.targetNode = node;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setCategories(String[] strings) {
        this.categories = strings;
    }

    public void setEmptyListMessage(String message) {
        this.emptyListMessage = message;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public void dispose() {
        this.targetNode = null;
        this.model = null;
        super.dispose();
    }
}

