/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVFileMultiBrowsePart;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.pagedataview.ui.JsfSelectPageDataDialog;
import com.ibm.etools.jsf.palette.commands.EditNodeAttributesCommand;
import com.ibm.etools.webedit.common.attrview.HTMLNodeSelection;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webedit.selection.HTMLSelectionMediator;
import com.ibm.etools.webedit.utils.DocumentUtil;
import com.ibm.etools.webedit.utils.DocumentUtilFactory;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModelAdapter;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class BindBrowseImportPart
extends AVFileMultiBrowsePart {
    private static final String BROWSE = Messages.UI_PROPPAGE_PARTS_Browse____1;
    private static final String IMPORT = Messages.UI_PROPPAGE_PARTS_Import____2;
    private static final String BIND = Messages.UI_PROPPAGE_PARTS_Bind____4;
    private static final String[] MENU_ITEMS = new String[]{BROWSE, IMPORT, BIND};
    protected static final int INDEX_BROWSE = 0;
    protected static final int INDEX_IMPORT = 1;
    protected static final int INDEX_BIND = 2;
    protected int fileType;
    protected IPageDataModel model;
    protected String attributeName;
    protected DocumentUtil docUtil;
    private Node targetNode = null;
    private String[] categories = new String[]{"Server Side", "Scripting"};

    public BindBrowseImportPart(AVData data, Composite parent, String title, int fileType, String attrib) {
        super(data, parent, title, MENU_ITEMS);
        this.fileType = fileType;
        this.attributeName = attrib;
        if (this.getBrowseButton().getLayoutData() == null) {
            this.getBrowseButton().setLayoutData((Object)new GridData());
        }
        ((GridData)this.getBrowseButton().getLayoutData()).heightHint = 17;
        ((GridData)this.getBrowseButton().getLayoutData()).widthHint = 21;
    }

    protected void browse(int index) {
        if (this.docUtil == null) {
            return;
        }
        String fileName = null;
        String defaultTag = "a";
        String defaultAttr = "href";
        if (index == 0) {
            fileName = this.docUtil.getFileUtil().selectFile(this.getParent().getShell(), defaultTag, defaultAttr, this.fileType);
        } else if (index == 1) {
            fileName = this.docUtil.getFileUtil().importFile(this.getParent().getShell(), defaultTag, defaultAttr, this.fileType);
        } else if (index == 2) {
            Range range;
            HTMLSelectionMediator mediator;
            if (this.model == null) {
                return;
            }
            if (this.categories == null) {
                this.categories = new String[]{"Server Side", "Scripting"};
            }
            HTMLEditDomain domain = ActionUtil.getActiveHTMLEditDomain();
            if (this.targetNode == null && domain != null && (mediator = domain.getSelectionMediator()) != null && (range = mediator.getRange()) != null) {
                this.targetNode = range.getEndContainer();
            }
            if (this.targetNode == null) {
                return;
            }
            String currentValue = null;
            String attr = this.attributeName;
            if (attr == null) {
                attr = defaultAttr;
            }
            Element target = (Element)this.targetNode;
            currentValue = target.getAttribute(attr);
            JsfSelectPageDataDialog dialog = new JsfSelectPageDataDialog(this.getParent().getShell(), this.model, this.categories, true, currentValue, this.targetNode, attr);
            if (dialog.open() == 0) {
                String value;
                Object cmd = null;
                if (dialog.getSelectedTab() == 0) {
                    IPageDataNode pdNode = dialog.getSelectedNode();
                    cmd = BindingUtil.generateBindingCommand(this.targetNode, this.attributeName, pdNode, true);
                } else if (dialog.getSelectedTab() == 1) {
                    String value2 = dialog.getElEditorResult();
                    if (value2 != null) {
                        cmd = new EditNodeAttributesCommand(this.targetNode, this.attributeName, value2);
                    }
                } else if (dialog.getSelectedTab() == 2 && (value = dialog.getStringResourceId()) != null) {
                    cmd = new EditNodeAttributesCommand(this.targetNode, this.attributeName, value);
                }
                if (cmd != null && domain != null) {
                    domain.execCommand((Command)cmd);
                }
            }
        }
        if (fileName != null && fileName.length() > 0) {
            this.setString(fileName);
            this.setModified(true);
            this.fireValueChange();
        }
    }

    protected Button createBrowseButton() {
        return JsfWidgetUtil.createMultiBrowseButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.getContainer(), (String)Messages.BindBrowseImportPart_Browse__import_or_bind_to_a_file_location_2, (String)Messages.BindBrowseImportPart_Browse__import_or_bind_to_a_file_location_2);
    }

    protected void update() {
        AVData data = this.getDataComponent();
        this.docUtil = null;
        this.model = null;
        if (data instanceof AttributeData) {
            HTMLEditDomain actionTarget;
            NodeList nodeList = ((HTMLNodeSelection)data.getSelection()).getNodeList();
            IDOMNode node = null;
            if (nodeList != null) {
                int i = 0;
                while (i < nodeList.getLength()) {
                    if (nodeList.item(i) instanceof IDOMNode) {
                        node = (IDOMNode)nodeList.item(i);
                        break;
                    }
                    ++i;
                }
            }
            if (node != null && (actionTarget = ActionUtil.getActiveHTMLEditDomain()) != null) {
                this.docUtil = DocumentUtilFactory.create((IDOMModel)((IDOMNode)node).getModel(), (HTMLSubModelContext)actionTarget.getActiveSubModelContext());
                PageDataModelAdapter adapter = (PageDataModelAdapter)((IDOMNode)node).getModel().getDocument().getAdapterFor((Object)PageDataModelAdapter.ADAPTER_KEY);
                if (adapter != null) {
                    this.model = adapter.getPageDataModel();
                }
            }
        }
        this.setString(data.getValue());
        super.update();
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    public void setTargetNode(Node targetNode) {
        this.targetNode = targetNode;
    }

    public void dispose() {
        this.targetNode = null;
        this.model = null;
        this.docUtil = null;
        super.dispose();
    }
}

