/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVDirectTableEditorPart;
import com.ibm.etools.attrview.sdk.AVTableComponent;
import com.ibm.etools.attrview.sdk.AVTableEditorPart;
import com.ibm.etools.attrview.sdk.ValueItem;
import com.ibm.etools.attrview.utils.WidgetUtil;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.attrview.data.AjaxParameterData;
import com.ibm.etools.jsf.attrview.pages.JsfPage;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.EditNodeAttributesCommand;
import com.ibm.etools.webedit.common.attrview.pages.HTMLPage;
import com.ibm.etools.webedit.common.commands.RangeCommand;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.w3c.dom.Node;

public class AjaxParameterPart
extends AVDirectTableEditorPart {
    private static final String[] COLUMNS = new String[]{Messages.ParameterPage_Name_6};
    private String initialValue = null;
    protected int[] savedSelections;
    protected CellEditor[] cellEditors;
    protected Composite buttonContainer;
    private int nCurrentTableWidth = 0;

    public AjaxParameterPart(AVData data, Composite parent, String title) {
        super(data, parent, title, false, false, false);
    }

    protected void activateCellEditor(TableItem item, int row, int column) {
        this.initialValue = null;
        super.activateCellEditor(item, row, column);
        if (this.currentCellEditor != null && this.currentCellEditor.getValue() != null) {
            this.initialValue = this.currentCellEditor.getValue().toString();
        }
    }

    protected String[] getColumnNames() {
        return COLUMNS;
    }

    protected String[] getMenuColumnNames() {
        return COLUMNS;
    }

    protected int[] getColumnSizes() {
        int[] sizes = new int[]{200};
        return sizes;
    }

    protected int getRowsSize() {
        return 50;
    }

    protected void addEntry(String[] values) {
        if (values == null || values.length == 0 || values[0] == null) {
            return;
        }
        Object[] items = this.getItems();
        String result = "";
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                ValueItem item = (ValueItem)items[i];
                result = String.valueOf(result) + item.getValue() + ";";
                ++i;
            }
        }
        result = String.valueOf(result) + values[0];
        Node node = ((AjaxParameterData)this.getDataComponent()).getSelectedNode();
        ((HTMLPage)this.getPage()).launchCommand((RangeCommand)new EditNodeAttributesCommand(node, ((AjaxParameterData)this.getDataComponent()).getAttributeName(), result));
    }

    public void doDelete() {
        int index = this.table.getSelectionIndex();
        Object[] items = this.getItems();
        String result = "";
        int i = 0;
        while (i < items.length) {
            if (i != index) {
                ValueItem item = (ValueItem)items[i];
                result = String.valueOf(result) + item.getValue() + ";";
            }
            ++i;
        }
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        Node node = ((AjaxParameterData)this.getDataComponent()).getSelectedNode();
        ((HTMLPage)this.getPage()).launchCommand((RangeCommand)new EditNodeAttributesCommand(node, ((AjaxParameterData)this.getDataComponent()).getAttributeName(), result));
    }

    public void doDown() {
    }

    public void doUp() {
    }

    protected void editEntry(int row, int column, String value) {
        Object[] items = this.getItems();
        if (value == null || items == null) {
            return;
        }
        AVData data = this.getDataComponent();
        items[row] = new ValueItem(value, value);
        ((AjaxParameterData)data).setData(items);
        String result = "";
        int i = 0;
        while (i < items.length) {
            if (i == row) {
                result = String.valueOf(result) + value + ";";
            } else {
                ValueItem item = (ValueItem)items[i];
                result = String.valueOf(result) + item.getValue() + ";";
            }
            ++i;
        }
        if (result.endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        Node node = ((AjaxParameterData)this.getDataComponent()).getSelectedNode();
        ((HTMLPage)this.getPage()).launchCommand((RangeCommand)new EditNodeAttributesCommand(node, ((AjaxParameterData)this.getDataComponent()).getAttributeName(), result));
    }

    protected CellEditor[] getCellEditors() {
        if (this.cellEditors == null) {
            this.cellEditors = new CellEditor[1];
            String[] ids = JsfPage.getJsfConponentIds(new String[]{"javax.faces.component.UIInput"}, false);
            this.cellEditors[0] = new ComboBoxCellEditor((Composite)this.table, ids, 0){

                protected Object doGetValue() {
                    CCombo comboBox = (CCombo)this.getControl();
                    int index = comboBox.getSelectionIndex();
                    if (index == -1) {
                        ((AVTableEditorPart)AjaxParameterPart.this).table.getSelection()[0].setText(0, "");
                        return comboBox.getText();
                    }
                    ((AVTableEditorPart)AjaxParameterPart.this).table.getSelection()[0].setText(0, comboBox.getItem(index));
                    return comboBox.getItem(index);
                }

                protected void doSetValue(Object value) {
                    if (value instanceof String) {
                        CCombo comboBox = (CCombo)this.getControl();
                        int index = comboBox.indexOf(value.toString());
                        String v = value.toString();
                        if (index < 0 && v.length() > 0) {
                            comboBox.setText(v);
                        } else {
                            super.doSetValue((Object)new Integer(index));
                        }
                    } else {
                        super.doSetValue(value);
                    }
                }

                protected Control createControl(Composite parent) {
                    CCombo comboBox = (CCombo)super.createControl(parent);
                    return comboBox;
                }
            };
        } else {
            String[] ids = JsfPage.getJsfConponentIds(new String[]{"javax.faces.component.UIInput"}, false);
            if (ids != null) {
                ((ComboBoxCellEditor)this.cellEditors[0]).setItems(ids);
            }
        }
        return this.cellEditors;
    }

    protected void handleAddButton(SelectionEvent e) {
        this.disableCellEditor();
        this.savedSelections = new int[]{this.table.getItemCount()};
        super.handleAddButton(e);
    }

    protected void handleDeleteButton(SelectionEvent e) {
        this.disableCellEditor();
        this.savedSelections = null;
        this.doDelete();
    }

    protected void handleTableSelected(SelectionEvent e) {
        super.handleTableSelected(e);
        this.savedSelections = this.table.getSelectionIndices();
        this.enableButtons();
    }

    protected void handleDownButton(SelectionEvent e) {
    }

    protected void handleUpButton(SelectionEvent e) {
    }

    protected boolean isDownAvailable() {
        return false;
    }

    protected boolean isUpAvailable() {
        return false;
    }

    protected void enableButtons() {
        int count = this.table.getSelectionCount();
        this.deleteButton.setEnabled(count > 0);
        if (this.updown) {
            this.upButton.setEnabled(this.isUpAvailable());
            this.downButton.setEnabled(this.isDownAvailable());
        }
    }

    protected void update() {
        boolean doDeactivate = true;
        Object[] items = this.getItems();
        if (items != null) {
            int count = this.table.getItemCount();
            int i = 0;
            while (i < items.length) {
                ValueItem valueItem;
                ValueItem item = (ValueItem)items[i];
                TableItem tableItem = i < count ? this.table.getItem(i) : WidgetUtil.createTableItem((AVWidgetFactory)this.getWidgetFactory(), (Table)this.table, (int)0);
                tableItem.setText(item.getDisplayString());
                if (this.currentCellEditor != null && this.currentSelection == i && (valueItem = (ValueItem)items[i]) != null && valueItem.matches(this.initialValue)) {
                    doDeactivate = false;
                }
                ++i;
            }
            int end = items.length;
            if (end < this.table.getItemCount()) {
                this.table.remove(end, this.table.getItemCount() - 1);
            }
            if (this.table.getSelectionCount() < 1 && this.savedSelections != null) {
                boolean resume = true;
                int i2 = 0;
                while (i2 < this.savedSelections.length) {
                    if (this.savedSelections[i2] < 0 || this.table.getItemCount() <= this.savedSelections[i2]) {
                        resume = false;
                        break;
                    }
                    ++i2;
                }
                if (resume) {
                    this.table.select(this.savedSelections);
                } else {
                    this.savedSelections = null;
                }
                this.setRowSelectionIndex(this.savedSelections);
                this.setColumnSelectionIndex(null);
            }
        } else {
            this.removeAll();
        }
        if (doDeactivate) {
            this.deactivateCellEditor();
        }
        this.enableButtons();
    }

    public void dispose() {
        super.dispose();
        if (this.cellEditors != null) {
            int i = 0;
            while (i < this.cellEditors.length) {
                if (this.cellEditors[i] != null) {
                    this.cellEditors[i].dispose();
                    this.cellEditors[i] = null;
                }
                ++i;
            }
            this.cellEditors = null;
        }
    }

    protected void createContents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 1;
        gridLayout.makeColumnsEqualWidth = true;
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        this.initializeContainer(2, true);
        this.getContainer().setLayout((Layout)gridLayout);
        this.getContainer().setLayoutData((Object)gd);
        Label label = WidgetUtil.createLabel((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.getContainer(), (String)this.getTitle());
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite tableContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), this.getContainer(), 1, false, 0, 0);
        this.buttonContainer = JsfWidgetUtil.createAreaComposite(this.getWidgetFactory(), this.getContainer(), 1, false, 0, 2);
        GridLayout layout = (GridLayout)this.buttonContainer.getLayout();
        layout.verticalSpacing = 0;
        this.buttonContainer.setLayout((Layout)layout);
        gridData = (GridData)this.buttonContainer.getLayoutData();
        gridData.horizontalAlignment = 128;
        gridData.grabExcessHorizontalSpace = false;
        this.buttonContainer.setLayoutData((Object)gridData);
        this.table = this.getWidgetFactory().createTable(tableContainer, 65540);
        gridData = new GridData(770);
        gridData.heightHint = 100;
        gridData.widthHint = 0;
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        int i = 0;
        while (i < this.getColumnNames().length) {
            TableColumn col = WidgetUtil.createTableColumn((AVWidgetFactory)this.getWidgetFactory(), (Table)this.table, (int)0);
            col.setText(this.getColumnNames()[i]);
            col.setWidth(this.getColumnSizes()[i]);
            ++i;
        }
        this.table.addSelectionListener((SelectionListener)this);
        this.createButtons();
        this.prepareDirectEditing();
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AjaxParameterPart.this.handleTableResized();
            }
        });
    }

    protected void createButtons() {
        GridData gridData = new GridData();
        gridData.heightHint = JsfWidgetUtil.getButtonHeight(19);
        this.addButton = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.buttonContainer, (String)Messages.ParameterPage_Add_Parameter_2, (int)8, (GridData)gridData);
        this.addButton.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.heightHint = JsfWidgetUtil.getButtonHeight(19);
        this.deleteButton = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.buttonContainer, (String)Messages.ParameterPage_Remove_Parameter_3, (int)8, (GridData)gridData);
        this.deleteButton.addSelectionListener((SelectionListener)this);
        if (this.updown) {
            gridData = new GridData();
            gridData.heightHint = JsfWidgetUtil.getButtonHeight(19);
            this.upButton = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.buttonContainer, (String)Messages.ParameterPage_Move_Up_4, (int)8, (GridData)gridData);
            this.upButton.addSelectionListener((SelectionListener)this);
            gridData = new GridData();
            gridData.heightHint = JsfWidgetUtil.getButtonHeight(19);
            this.downButton = WidgetUtil.createButton((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.buttonContainer, (String)Messages.ParameterPage_Move_Down_5, (int)8, (GridData)gridData);
            this.downButton.addSelectionListener((SelectionListener)this);
        }
        if (this.updown) {
            WidgetUtil.alignWidth((Control[])new Control[]{this.addButton, this.deleteButton, this.upButton, this.downButton});
        } else {
            WidgetUtil.alignWidth((Control[])new Control[]{this.addButton, this.deleteButton});
        }
        this.enableButtons();
    }

    protected void handleTableResized() {
        if (this.table == null) {
            return;
        }
        int width = this.table.getSize().x - 20;
        if (width == this.nCurrentTableWidth) {
            return;
        }
        this.nCurrentTableWidth = width;
        int totalWidth = 0;
        int i = 0;
        while (i < this.getColumnSizes().length) {
            totalWidth += this.getColumnSizes()[i];
            ++i;
        }
        if (totalWidth == 0) {
            return;
        }
        this.table.setRedraw(false);
        i = 0;
        while (i < this.getColumnSizes().length) {
            int columnWidth = width * this.getColumnSizes()[i] / totalWidth;
            if (columnWidth < 50) {
                columnWidth = 50;
            }
            this.table.getColumn(i).setWidth(columnWidth);
            ++i;
        }
        this.table.setRedraw(true);
    }

    public void doAdd() {
        String[] ids = JsfPage.getJsfConponentIds(new String[]{"javax.faces.component.UIInput"}, false);
        this.addEntry(ids);
        int newIndex = this.table.getItemCount();
        if (this.table.getSelectionCount() > 0) {
            this.table.deselectAll();
        }
        this.table.select(newIndex);
        this.setRowSelectionIndex(new int[]{newIndex});
        this.setColumnSelectionIndex(new int[]{this.getColumnAddIndex()});
    }

    public Object[] getItems() {
        AVData data = this.getDataComponent();
        if (data != null && data instanceof AVTableComponent) {
            return ((AVTableComponent)data).getItems();
        }
        return null;
    }
}

