/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.framework;

import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webedit.common.attrview.AbstractTagLabel;
import com.ibm.etools.webedit.common.attrview.AbstractTagLabelProvider;
import com.ibm.etools.webedit.common.attrview.TagLabel;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;

public class GenericTagLabelProvider
extends AbstractTagLabelProvider {
    private static final URL DEFAULT_TAG_SMALL_ICON = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.library"), (IPath)new Path("icons/jsf_cmp_pal_16.gif"), null);
    private static final String DEFAULT_ICON = "DEFAULT_ICON";

    private static Image createDefaultImage() {
        URL url = DEFAULT_TAG_SMALL_ICON;
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        Image ret = desc.createImage();
        desc = null;
        return ret;
    }

    private static Image createImage(String filename) {
        if (filename == null) {
            return null;
        }
        ImageDescriptor desc = null;
        URL url = GenericTagLabelProvider.getIconUrl(filename);
        desc = ImageDescriptor.createFromURL((URL)url);
        Image ret = desc.createImage();
        desc = null;
        return ret;
    }

    private static URL getIconUrl(String icon) {
        int index;
        if (icon.startsWith("${") && (index = icon.indexOf("}/")) > 0) {
            String bundleStr = icon.substring(2, index);
            String pathName = icon.substring(index + 2);
            Bundle bundle = Platform.getBundle((String)bundleStr);
            if (bundle != null) {
                return FileLocator.find((Bundle)bundle, (IPath)new Path(pathName), null);
            }
        }
        return null;
    }

    public TagLabel getTagLabel(String uri, Node node) {
        if (node != null && JsfComponentUtil.isJsfTag((Node)node)) {
            if ("http://java.sun.com/jsf/core".equals(uri) || "http://java.sun.com/jsf/html".equals(uri) || "http://www.ibm.com/jsf/html_extended".equals(uri) || "http://www.ibm.com/jsf/BrowserFramework".equals(uri) || "http://www.ibm.com/jsf/rte".equals(uri)) {
                return null;
            }
            String tagName = node.getLocalName();
            TagType tagType = LibraryManager.getInstance().getTagModel(uri, tagName);
            if (tagType != null && tagType.getSmallIcon() != null) {
                String imageFile = tagType.getSmallIcon();
                return imageFile == null ? null : new GenericTagLabel(null, imageFile);
            }
            return new GenericTagLabel(null, DEFAULT_ICON);
        }
        return null;
    }

    protected class GenericTagLabel
    extends AbstractTagLabel {
        private String text;
        private String imageFile;
        private Image image;

        public GenericTagLabel(String text, String imageFile) {
            this.text = text;
            this.imageFile = imageFile;
        }

        public void dispose() {
            if (this.image != null && !this.image.isDisposed()) {
                this.image.dispose();
                this.image = null;
            }
        }

        public String getText() {
            return this.text;
        }

        public Image getImage() {
            if (this.image == null && this.imageFile.equals(GenericTagLabelProvider.DEFAULT_ICON)) {
                this.image = GenericTagLabelProvider.createDefaultImage();
            } else if (this.image == null && this.imageFile != null) {
                this.image = GenericTagLabelProvider.createImage(this.imageFile);
            }
            return this.image;
        }
    }
}

