/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.utils.WidgetUtil;
import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class JsfWidgetUtil
extends WidgetUtil {
    public static Composite createAreaComposite(AVWidgetFactory factory, Composite parent, int numColumns, boolean equalWidth) {
        return JsfWidgetUtil.createAreaComposite(factory, parent, numColumns, equalWidth, 6, 0);
    }

    public static Composite createAreaComposite(AVWidgetFactory factory, Composite parent, int numColumns, boolean equalWidth, int hBorder, int vBorder) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginWidth = vBorder;
        gridLayout.marginHeight = hBorder;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 1;
        gridLayout.makeColumnsEqualWidth = equalWidth;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        return WidgetUtil.createComposite((AVWidgetFactory)factory, (Composite)parent, (int)0, (Layout)gridLayout, (Object)gridData);
    }

    public static Button createBrowseButton(Composite parent, String iconName, Control c) {
        int h = c.computeSize((int)-1, (int)-1).y + 2;
        return JsfWidgetUtil.createBrowseButton(parent, iconName, h);
    }

    public static Button createBrowseButton(Composite parent, String iconName, int iconHeight) {
        Button button = new Button(parent, 0x800000);
        button.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(Messages.JsfWidgetUtil_Browse____1));
        Display display = button.getDisplay();
        Font font = button.getFont();
        GC gc = new GC((Drawable)display);
        gc.setFont(font);
        Point size = gc.textExtent("....");
        size.x += 6;
        size.y = size.y < 12 ? 9 : size.y - 3;
        gc.dispose();
        Color fg = display.getSystemColor(21);
        Color bg = display.getSystemColor(22);
        RGB[] colormap = new RGB[]{bg.getRGB(), fg.getRGB()};
        ImageData imageData = new ImageData(size.x, size.y, 8, new PaletteData(colormap));
        Image image = new Image((Device)display, imageData);
        image.setBackground(bg);
        gc = new GC((Drawable)image);
        gc.setFont(font);
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.drawText("...", (size.x - gc.textExtent((String)"...").x) / 2, 0);
        Image img = JsfPlugin.getDefault().getImage1(iconName);
        gc.drawImage(img, 0, 0);
        gc.dispose();
        button.setImage(img);
        GridData gd = new GridData();
        gd.heightHint = iconHeight;
        gd.widthHint = 21;
        button.setLayoutData((Object)gd);
        return button;
    }

    public static Composite createQEVButton(AVWidgetFactory factory, Composite parent, String caption) {
        return JsfWidgetUtil.createQEVButton(factory, parent, caption, 55);
    }

    public static Composite createQEVButton(AVWidgetFactory factory, Composite parent, String caption, int maxWidth) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 7;
        gridLayout.makeColumnsEqualWidth = false;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        Composite composite = WidgetUtil.createComposite((AVWidgetFactory)factory, (Composite)parent, (int)0, (Layout)gridLayout, (Object)gridData);
        Button button = JsfWidgetUtil.createImageButton(factory, composite, "qev_edit");
        button.setToolTipText(Messages.JsfWidgetUtil_Switch_to_QuickEdit_View_3);
        button.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(caption));
        Label lbl = factory.createLabel(composite, 64);
        lbl.setText(caption);
        if (caption.length() > maxWidth) {
            ((GridData)button.getLayoutData()).verticalAlignment = 1;
            if (lbl.getLayoutData() == null) {
                lbl.setLayoutData((Object)new GridData(258));
            }
            GC gc = new GC((Drawable)parent);
            Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
            gc.setFont(font);
            int len = gc.textExtent((String)caption.substring((int)0, (int)maxWidth)).x;
            gc.dispose();
            ((GridData)lbl.getLayoutData()).widthHint = len;
            ((GridData)lbl.getLayoutData()).verticalAlignment = 2;
        }
        SelectionAdapter buttonHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.showView("com.ibm.etools.qev.view.QEVView");
                }
                catch (PartInitException partInitException) {}
            }
        };
        button.addSelectionListener((SelectionListener)buttonHandler);
        return composite;
    }

    public static Label createBufferedLabel(AVWidgetFactory factory, Composite parent, String labelText) {
        Label label = WidgetUtil.createLabel((AVWidgetFactory)factory, (Composite)parent, (String)labelText);
        if (label.getLayoutData() == null) {
            label.setLayoutData((Object)new GridData(32));
        }
        GC gc = new GC((Drawable)label);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(font);
        int len = gc.textExtent((String)labelText).x;
        gc.dispose();
        ((GridData)label.getLayoutData()).widthHint = len + 6;
        return label;
    }

    public static int getLenInPixels(Composite parent, String string) {
        GC gc = new GC((Drawable)parent);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(font);
        int len = gc.textExtent((String)string).x;
        gc.dispose();
        return len;
    }

    public static int getLenInPixels(Composite parent, int stringLen) {
        GC gc = new GC((Drawable)parent);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(font);
        int len = gc.textExtent((String)"X").x * stringLen;
        gc.dispose();
        return len;
    }

    public static Button createImageButton(AVWidgetFactory factory, Composite parent, String image, String accText, String tooltipText) {
        Button button = factory.createButton(parent, 8);
        if (accText != null) {
            button.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(accText));
        }
        if (tooltipText != null) {
            button.setToolTipText(tooltipText);
        }
        if (image != null) {
            Image img = JsfPlugin.getDefault().getImage1(image);
            button.setImage(img);
            Rectangle r = img.getBounds();
            GridData gd = new GridData();
            gd.heightHint = r.height + WidgetUtil.IMAGE_HEIGHT_MARGIN;
            gd.widthHint = r.width + WidgetUtil.IMAGE_WIDTH_MARGIN;
            button.setLayoutData((Object)gd);
        }
        return button;
    }

    public static Button createImageButton(AVWidgetFactory factory, Composite parent, String image) {
        return JsfWidgetUtil.createImageButton(factory, parent, image, Messages.JsfWidgetUtil_Browse____1, Messages.JsfWidgetUtil_Browse____1);
    }

    public static int getButtonHeight(int wishedHeight) {
        if (SWT.getPlatform().equals("win32")) {
            return wishedHeight;
        }
        return -1;
    }

    public static void makeButtonAccessible(Button btn, String accText) {
        btn.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(accText.replaceAll("&", "")));
    }
}

