/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview;

import com.ibm.etools.attrview.AVContents;
import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.AVSelection;
import com.ibm.etools.attrview.AttributesView;
import com.ibm.etools.attrview.sdk.AVFolder;
import com.ibm.etools.jsf.attrview.JsfAttributesViewFactory;
import com.ibm.etools.jsf.attrview.JsfAttributesViewSpecification;
import com.ibm.etools.jsf.attrview.folders.JsfFolder;
import com.ibm.etools.webedit.common.attrview.HTMLFolderDescriptor;
import com.ibm.etools.webedit.common.attrview.NodeSelection;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JsfAttributesViewManager {
    protected AttributesView view;
    private static final int CACHE_SIZE = 8;
    protected AVFolder nowFolder;
    protected List<AVContents> folders = new ArrayList<AVContents>();

    public JsfAttributesViewManager(AttributesView view) {
        this.view = view;
    }

    public void dispose() {
        if (this.folders != null) {
            this.disposeFolders();
            this.folders.clear();
            this.folders = null;
        }
        this.view = null;
    }

    public AVContents getContentsFor(AVEditorContextProvider provider) {
        AVSelection selection = provider.getSelection();
        if (selection == null || !(selection instanceof NodeSelection)) {
            return null;
        }
        NodeSelection domselection = (NodeSelection)selection;
        NodeList nodeList = domselection.getNodeList();
        if (nodeList == null) {
            return null;
        }
        if (nodeList.getLength() > 1) {
            return null;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            AVContents folder;
            Node node = nodeList.item(i);
            while (node != null) {
                if (node.getNodeType() == 1 || node.getNodeType() == 8) break;
                node = node.getParentNode();
            }
            if (node == null) {
                return null;
            }
            if ((node.getNodeType() == 1 || node.getNodeType() == 8) && (folder = this.findFolder(provider, node)) != null) {
                return folder;
            }
            ++i;
        }
        return null;
    }

    private void disposeFolders() {
        if (this.folders == null) {
            return;
        }
        int size = this.folders.size();
        int i = 0;
        while (i < size) {
            AVContents folder = this.folders.get(i);
            if (folder != null && folder instanceof AVFolder) {
                ((AVFolder)folder).dispose();
            }
            ++i;
        }
    }

    protected AVContents findFolder(AVEditorContextProvider provider, Node node) {
        if (this.folders == null || node == null) {
            return null;
        }
        HTMLFolderDescriptor folderDesc = JsfAttributesViewSpecification.findFolder(node);
        if (folderDesc != null) {
            JsfFolder folder = null;
            int size = this.folders.size();
            int i = 0;
            while (i < size) {
                HTMLFolderDescriptor desc;
                AVContents content = this.folders.get(i);
                if (content != null && content instanceof JsfFolder && (desc = (folder = (JsfFolder)content).getFolderDescriptor()) == folderDesc) {
                    if (folder != this.nowFolder) {
                        this.nowFolder = folder;
                    }
                    return folder;
                }
                ++i;
            }
            folder = JsfAttributesViewFactory.createFolder(folderDesc);
            if (folder != null) {
                folder.setFolderDescriptor(folderDesc);
                folder.setEditorContext(provider);
                folder.setView(this.view);
                folder.createContents();
                this.putFolder((AVContents)folder);
                this.nowFolder = folder;
                return folder;
            }
        }
        return null;
    }

    protected void putFolder(AVContents folder) {
        if (this.folders == null || folder == null) {
            return;
        }
        int size = this.folders.size();
        if (8 <= size) {
            int i = size - 1;
            while (8 <= i) {
                AVContents content = this.folders.get(i);
                if (content != null && content instanceof AVFolder) {
                    ((AVFolder)content).dispose();
                }
                this.folders.remove(i);
                --i;
            }
        }
        this.folders.add(0, folder);
    }
}

