/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.pagedataview.ui.JsfSelectPageDataDialog;
import com.ibm.etools.jsf.palette.commands.EditNodeAttributesCommand;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.utils.ActionUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeanValueCellEditor
extends DialogCellEditor {
    private Node node;
    private Text text;
    private Button result;
    private IPageDataModel model = null;
    private Composite parent = null;
    private String attrName = "value";
    public String[] categories = null;
    private String name;
    boolean bKeepEditorActiveAfterLosingFocus = false;

    public BeanValueCellEditor(Composite parent, IPageDataModel model) {
        super(parent);
        this.parent = parent;
        this.model = model;
    }

    protected Button createButton(Composite parent) {
        this.result = new Button(parent, 0x800400);
        this.result.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(Messages.UI_PROPPAGE_PARTS_Browse____3));
        Image img = JsfPlugin.getDefault().getImage1("compute");
        this.result.setImage(img);
        this.result.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BeanValueCellEditor.this.handleCancelEditor();
                    e.doit = false;
                }
                if (e.detail == 16) {
                    Event event = new Event();
                    event.detail = e.detail;
                    BeanValueCellEditor.this.getControl().notifyListeners(31, event);
                    e.doit = false;
                }
                if (e.detail == 8) {
                    BeanValueCellEditor.this.text.setFocus();
                    e.doit = false;
                }
            }
        });
        return this.result;
    }

    protected Control createContents(Composite cell) {
        this.text = new Text(cell, 4);
        this.text.setFont(cell.getFont());
        this.text.setBackground(cell.getBackground());
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BeanValueCellEditor.this.handleCancelEditor();
                    e.doit = false;
                }
                if (e.detail == 4) {
                    BeanValueCellEditor.this.handleApplyEditorValue();
                    e.doit = false;
                }
                if (e.detail == 16) {
                    BeanValueCellEditor.this.bKeepEditorActiveAfterLosingFocus = true;
                    BeanValueCellEditor.this.result.setFocus();
                    e.doit = false;
                }
                if (e.detail == 8) {
                    Event event = new Event();
                    event.detail = e.detail;
                    BeanValueCellEditor.this.getControl().notifyListeners(31, event);
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (SWT.getPlatform().equalsIgnoreCase("win32")) {
                    BeanValueCellEditor.this.handleFocusLost(e);
                }
            }

            public void focusGained(FocusEvent e) {
                if (!SWT.getPlatform().equalsIgnoreCase("win32")) {
                    BeanValueCellEditor.this.handleFocusGained(e);
                }
            }
        });
        this.text.getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(this.name));
        return this.text;
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
        }
    }

    public Text getTextControl() {
        return this.text;
    }

    private void handleApplyEditorValue() {
        this.fireApplyEditorValue();
    }

    private void handleCancelEditor() {
        this.fireCancelEditor();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Object ret = this.getValue();
        if (this.openBeanPropertyDialog()) {
            this.fireApplyEditorValue();
            ret = this.getValue();
        }
        return ret;
    }

    protected void updateContents(Object value) {
        if (this.text != null) {
            if (value != null) {
                this.text.setText(value.toString());
            } else {
                this.text.setText("");
            }
        }
    }

    boolean openBeanPropertyDialog() {
        String valueRef;
        if (this.categories == null) {
            this.categories = new String[]{"Server Side", "Scripting"};
        }
        if (this.node == null) {
            return false;
        }
        Element target = (Element)this.node;
        String currentValue = target.getAttribute(this.attrName);
        JsfSelectPageDataDialog dialog = new JsfSelectPageDataDialog(this.parent.getShell(), this.model, this.categories, true, currentValue, this.node, this.attrName);
        if (dialog.open() == 0) {
            String value;
            Object cmd = null;
            HTMLEditDomain domain = ActionUtil.getActiveHTMLEditDomain();
            if (dialog.getSelectedTab() == 0) {
                IPageDataNode pdNode = dialog.getSelectedNode();
                cmd = BindingUtil.generateBindingCommand(this.node, this.attrName, pdNode, true);
            } else if (dialog.getSelectedTab() == 1) {
                String value2 = dialog.getElEditorResult();
                if (value2 != null) {
                    cmd = new EditNodeAttributesCommand(this.node, this.attrName, value2);
                }
            } else if (dialog.getSelectedTab() == 2 && (value = dialog.getStringResourceId()) != null) {
                cmd = new EditNodeAttributesCommand(this.node, this.attrName, value);
            }
            if (cmd != null && domain != null) {
                domain.execCommand((Command)cmd);
            }
        }
        if ((valueRef = ((Element)this.node).getAttribute(this.attrName)) == null) {
            valueRef = "";
        }
        this.text.setText(valueRef);
        return true;
    }

    public void setModel(IPageDataModel model) {
        this.model = model;
    }

    public void setNode(Node n) {
        this.node = n;
    }

    public void setAttrName(String string) {
        this.attrName = string;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public void setCategories(String[] strings) {
        this.categories = strings;
    }

    private void handleFocusLost(FocusEvent e) {
        if (e.widget == this.text && this.bKeepEditorActiveAfterLosingFocus) {
            this.bKeepEditorActiveAfterLosingFocus = false;
            return;
        }
        this.focusLost();
    }

    private void handleFocusGained(FocusEvent e) {
        Widget cfr_ignored_0 = e.widget;
    }
}

