/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf;

import com.ibm.etools.jsf.designtime.DesignTimeUtil;
import com.ibm.etools.jsf.facesconfig.util.FacesResourceChangeListener;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.internal.wizard.JsfResourceUpdateJob;
import com.ibm.etools.jsf.internal.wizard.ResourceUpdateListener;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JsfPlugin
extends AbstractUIPlugin {
    public static final String[] ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/ctool16", "icons/full/wizban", "icons", ""};
    public static final String PLUGIN_ID = "com.ibm.etools.jsf";
    private static JsfPlugin plugin;
    private static IPath location;
    private static final int INTERNAL_ERROR = 10001;

    public JsfPlugin() {
        plugin = this;
    }

    public static JsfPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public Image getImage1(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image != null && image.isDisposed()) {
            imageRegistry.remove(key);
            image = null;
        }
        if (image == null) {
            imageRegistry.put(key, this.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("icons/" + key + ".gif"));
        return imageDescriptor;
    }

    public static IPath getInstallLocation() {
        if (location == null) {
            URL pluginURL;
            block6: {
                Bundle pluginBundle;
                block5: {
                    try {
                        pluginBundle = Platform.getBundle((String)PLUGIN_ID);
                        if (pluginBundle != null) break block5;
                        return null;
                    }
                    catch (IOException iOException) {}
                }
                pluginURL = pluginBundle.getEntry("/");
                if (pluginURL != null) break block6;
                return null;
            }
            URL localName = FileLocator.resolve((URL)pluginURL);
            String installLocation = localName.getFile();
            location = new Path(installLocation);
        }
        return location;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        FacesResourceChangeListener.startup();
        FacesResourceChangeListener.setPreferenceStore((IPreferenceStore)this.getPreferenceStore());
        ResourceUpdateListener.install();
        Job configProjectsJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                IProject[] projects = JsfPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (JsfProjectUtil.isJsfProject((IProject)projects[i])) {
                        DesignTimeUtil.setupDTResolversForProject(projects[i]);
                    }
                    JsfResourceUpdateJob.getSingletonJob().addProject(projects[i]);
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        configProjectsJob.setSystem(true);
        configProjectsJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        FacesResourceChangeListener.shutdown();
        super.stop(context);
    }

    protected void initializeDefaultPluginPreferences() {
        this.getPreferenceStore().setDefault("jsf.project.restart", false);
        this.getPreferenceStore().setDefault("jsf.standard.stylesheets", "theme/stylesheet.css");
        this.getPreferenceStore().setDefault("templates.use_javajet", false);
    }

    public static void log(IStatus status) {
        JsfPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        JsfPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            JsfPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(PLUGIN_ID, 10001, message, null);
        multi.add(status);
        JsfPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        JsfPlugin.log(e, Messages.bind((String)Messages.JsfPlugin_Error, (Object)PLUGIN_ID));
    }

    public static void log(Throwable e, String message) {
        JsfPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, e));
    }
}

