/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.validation.validate;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.validation.internal.nls.Messages;
import com.ibm.etools.jsf.validation.validate.JsfFileValidator;
import com.ibm.etools.jsf.validation.validate.JsfValidationHelper;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class JsfValidator
extends AbstractValidator
implements IValidator {
    public static final String RELATIONAL_DATA_OBJECT_CLASS = "com.ibm.etools.webtools.wdo.rdb.internal.DataObjectAccessBeanImpl";
    public static final String RELATIONAL_DATA_LIST_CLASS = "com.ibm.etools.webtools.wdo.rdb.internal.DataListAccessBeanImpl";
    protected IReporter reporter = null;
    protected IFile currentFile = null;
    protected IValidationContext helper;

    public void cleanup(IReporter reporter) {
        reporter = null;
        this.currentFile = null;
        this.helper = null;
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        this.reporter = null;
        this.currentFile = null;
        this.helper = null;
        super.validationFinishing(project, state, monitor);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult vr = new ValidationResult();
        if (resource == null || !(resource instanceof IFile)) {
            return vr;
        }
        this.reporter = vr.getReporter(monitor);
        IFile file = (IFile)resource;
        IProject project = file.getProject();
        if (JsfProjectUtil.isJsfProject((IProject)project)) {
            this.validateFile(file);
        }
        return vr;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.helper = helper;
        this.reporter = reporter;
        if (helper == null) {
            return Status.CANCEL_STATUS;
        }
        if (reporter != null && reporter.isCancelled()) {
            return Status.CANCEL_STATUS;
        }
        String[] fileUris = helper.getURIs();
        if (fileUris == null || fileUris.length == 0) {
            this.validateFull();
        } else {
            int i = 0;
            while (i < fileUris.length && !reporter.isCancelled()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileUris[i]));
                IProject project = file.getProject();
                if (JsfProjectUtil.isJsfProject((IProject)project)) {
                    this.validateFile(file);
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        this.helper = helper;
        return null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateFile(IFile file) {
        this.currentFile = file;
        this.reporter.removeAllMessages((IValidator)this, (Object)file);
        JsfFileValidator fileValidator = null;
        IStructuredModel model = null;
        try {
            try {
                IModelManager manager;
                if (!JsfComponentUtil.isJSP((IFile)file) || (model = (manager = StructuredModelManager.getModelManager()).getModelForRead(file)) == null || !(model instanceof IDOMModel) || !JsfComponentUtil.isJsfPage((Document)((IDOMModel)model).getDocument())) return;
                LocalizedMessage message = new LocalizedMessage(4, NLS.bind((String)Messages.MESSAGE_JSF_VALIDATING_MESSAGE, (Object[])new String[]{file.getFullPath().toString()}));
                this.reporter.displaySubtask((IValidator)this, (IMessage)message);
                fileValidator = new JsfFileValidator((IDOMModel)model, this);
                fileValidator.validate();
                return;
            }
            catch (IOException iOException) {
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException coreException) {
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void validateFull() {
        IProject project;
        if (this.helper instanceof IWorkbenchContext && (project = ((IWorkbenchContext)this.helper).getProject()) != null && JsfProjectUtil.isJsfProject((IProject)project)) {
            this.validateContainer((IContainer)project);
        }
    }

    private void validateContainer(IContainer container) {
        try {
            IResource[] resourceArray = container.members(false);
            int i = 0;
            while (i < resourceArray.length) {
                IResource resource = resourceArray[i];
                if (resource != null) {
                    if (resource instanceof IFile) {
                        this.validateFile((IFile)resource);
                    } else if (resource instanceof IContainer) {
                        this.validateContainer((IContainer)resource);
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public void addWarning(String msgText) {
        this.reporter.addMessage((IValidator)this, (IMessage)new LocalizedMessage(2, msgText, (IResource)this.currentFile));
    }

    public void addWarning(String msgText, int lineNo, int offset, int length) {
        LocalizedMessage message = new LocalizedMessage(2, msgText, (IResource)this.currentFile);
        message.setLineNo(lineNo);
        message.setOffset(offset);
        message.setLength(length);
        this.reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void addError(String msgText, int lineNumber) {
        LocalizedMessage message = new LocalizedMessage(1, msgText, (IResource)this.currentFile);
        message.setLineNo(lineNumber);
        this.reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void addError(String msgText, int lineNo, int offset, int length) {
        LocalizedMessage message = new LocalizedMessage(1, msgText, (IResource)this.currentFile);
        message.setLineNo(lineNo);
        message.setOffset(offset);
        message.setLength(length);
        this.reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public void addError(String msgText, Object target) {
        LocalizedMessage message = new LocalizedMessage(1, msgText, (IResource)this.currentFile);
        message.setLineNo(((JsfValidationHelper)this.helper).getLineNo(target));
        this.reporter.addMessage((IValidator)this, (IMessage)message);
    }

    public String getStrippedTagName(String tagPath) {
        int index = tagPath.lastIndexOf("/");
        return tagPath.substring(index + 1, tagPath.length());
    }

    public IResource getResource(IFileDelta delta) {
        Object res = null;
        res = delta instanceof IResource ? (IResource)delta : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta.getFileName()));
        return res;
    }

    public boolean hasCustomVariableResolver(IProject project) {
        return false;
    }

    public boolean hasCustomPropertyResolver(IProject project) {
        return false;
    }

    public boolean isCancelled() {
        return this.reporter.isCancelled();
    }
}

