/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.validation.validate;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.palette.commands.builder.IDropRulesCustomizer;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.jsf.validation.internal.nls.Messages;
import com.ibm.etools.jsf.validation.validate.IFileValidator;
import com.ibm.etools.jsf.validation.validate.JsfValidator;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class JsfFileValidator
implements IFileValidator {
    private static final String EXPRESSION_START = "${";
    private static final String EXPRESSION_END = "}";
    private IDOMModel _model;
    private JsfValidator _validator;
    private String corePrefix = null;
    private String htmlPrefix = null;
    private String extendedPrefix = null;
    private String rtePrefix = null;

    public JsfFileValidator(IDOMModel model, JsfValidator validator) {
        this._model = model;
        this._validator = validator;
    }

    @Override
    public void validate() {
        if (this._model != null) {
            this.setPrefixes();
            if (!this._validator.isCancelled()) {
                this.validateIds();
            }
            if (!this._validator.isCancelled()) {
                this.validateNesting();
            }
        }
    }

    public void validateIds() {
        Hashtable<String, String> remember = new Hashtable<String, String>();
        IDOMDocument doc = this._model.getDocument();
        NodeIterator iter = ((DocumentTraversal)doc).createNodeIterator((Node)doc, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            Attr id = this.getAttribute(node, "id");
            String idValue = this.getTagId(node);
            if (idValue != null && !this.isValidExpression(idValue)) {
                int lastIndex = idValue.lastIndexOf(58);
                if (lastIndex != -1) {
                    if (remember.get(idValue) != null) {
                        this.addAttrValueWarning(id, NLS.bind((String)Messages.MESSAGE_JSF_ID_DUPLICATE, (Object)idValue));
                    } else {
                        remember.put(idValue, "Y");
                        remember.put(idValue.substring(lastIndex + 1), "N");
                    }
                } else {
                    String str = (String)remember.get(idValue);
                    if (str != null && str.equals("Y")) {
                        this.addAttrValueWarning(id, NLS.bind((String)Messages.MESSAGE_JSF_ID_DUPLICATE, (Object)idValue));
                    } else {
                        if (str != null) {
                            remember.remove(idValue);
                        }
                        remember.put(idValue, "Y");
                    }
                }
            }
            node = iter.nextNode();
        }
        iter = ((DocumentTraversal)doc).createNodeIterator((Node)doc, 1, null, false);
        node = iter.nextNode();
        while (node != null) {
            Attr forAttr = this.getAttribute(node, "for");
            String forValue = this.getAttributeValue(forAttr);
            if (forValue != null && !BindingUtil.isVblExpression((String)(forValue = forValue.trim())) && remember.get(forValue) == null) {
                this.addAttrValueWarning(forAttr, NLS.bind((String)Messages.MESSAGE_JSF_ATTRIBUTE_FOR_INVALID, (Object)forValue));
            }
            node = iter.nextNode();
        }
        this.validateIdsValidJava();
    }

    private String getTagId(Node node) {
        Node parentTag;
        Attr id = this.getAttribute(node, "id");
        String idValue = this.getAttributeValue(id);
        if (idValue == null || idValue.equals("")) {
            return null;
        }
        while ((parentTag = this.findParentTag(node)) != null) {
            if (this.isNamingContainer(parentTag)) {
                Attr parentId = this.getAttribute(parentTag, "id");
                String parentIdValue = this.getAttributeValue(parentId);
                idValue = parentIdValue == null || parentIdValue.equals("") ? (parentTag instanceof ElementImpl ? String.valueOf(((ElementImpl)parentTag).getStartOffset()) + ":" + idValue : String.valueOf(parentTag.toString()) + ":" + idValue) : String.valueOf(parentIdValue) + ":" + idValue;
            }
            node = parentTag;
        }
        return idValue;
    }

    private boolean isNamingContainer(Node node) {
        return JsfComponentUtil.checkComponentSuperclass((Node)node, (String)"javax.faces.component.NamingContainer");
    }

    private void validateNesting() {
        String viewTag = this.corePrefix.concat("view");
        String subViewTag = this.corePrefix.concat("subview");
        String formTag = this.htmlPrefix.concat("form");
        IDOMDocument doc = this._model.getDocument();
        NodeIterator iter = ((DocumentTraversal)doc).createNodeIterator((Node)doc, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            String tagName = node.getNodeName();
            if (!tagName.equals(viewTag) && !tagName.equals(subViewTag)) {
                if (tagName.equals(formTag)) {
                    Node parent = node.getParentNode();
                    while (parent != null) {
                        if (formTag.equals(parent.getNodeName())) {
                            this.addTagWarning(node, NLS.bind((String)Messages.MESSAGE_JSF_INVALID_NESTING, (Object)formTag));
                            break;
                        }
                        parent = parent.getParentNode();
                    }
                } else if (node.getNodeName().indexOf(58) != -1) {
                    String parentName;
                    TaglibPrefixUtil uriMapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument((Node)node));
                    String taglibURI2 = uriMapper.getUriForPrefix(node.getPrefix());
                    Node parentTag = this.findParentTag(node);
                    if (parentTag != null && !(parentName = parentTag.getNodeName()).equals(formTag) && !this.handleSpecialCases(parentName, tagName)) {
                        String taglibURI = uriMapper.getUriForPrefix(parentTag.getPrefix());
                        IDropRulesCustomizer customizer = ExtensionRegistry.getRegistry().getDropCustomizer(taglibURI);
                        if (customizer != null) {
                            int index = tagName.indexOf(":");
                            tagName = tagName.substring(index + 1, tagName.length());
                            index = parentName.indexOf(":");
                            String parentName2 = parentName.substring(index + 1, parentName.length());
                            boolean isAllowed = customizer.isAllowedAsChild(parentName2, taglibURI2, tagName);
                            if (!isAllowed && !this.isAdditionalAllowedAsChild(taglibURI, parentName2, taglibURI2, tagName)) {
                                this.addTagWarning(node, NLS.bind((String)Messages.MESSAGE_JSF_INVALID_NESTING, (Object)parentName));
                            }
                        }
                    }
                }
            }
            node = iter.nextNode();
        }
    }

    public boolean isAdditionalAllowedAsChild(String targetTaglibUri, String targetTagName, String droppedTaglibUri, String droppedTagName) {
        if (droppedTaglibUri == null || targetTaglibUri == null) {
            return true;
        }
        if (!(targetTaglibUri.equals("http://java.sun.com/jsf/core") || targetTaglibUri.equals("http://www.ibm.com/jsf/html_extended") || targetTaglibUri.equals("http://www.ibm.com/jsf/rte") || targetTaglibUri.equals("http://java.sun.com/jsf/html") || targetTaglibUri.equals("http://www.ibm.com/jsf/BrowserFramework"))) {
            return true;
        }
        if (targetTagName.equals("inputSecret") || targetTagName.equals("inputTextarea") || targetTagName.equals("inputHidden")) {
            if (droppedTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && (droppedTagName.equals("validateConstraint") || droppedTagName.equals("inputHelperAssist")) || droppedTaglibUri.equals("http://java.sun.com/jsf/core") && (droppedTagName.equals("validateLength") || droppedTagName.equals("validator") || droppedTagName.equals("valueChangeListener") || droppedTagName.equals("converter"))) {
                return true;
            }
            if (targetTagName.equals("inputHidden") && droppedTaglibUri.equals("http://java.sun.com/jsf/core") && (droppedTagName.equals("convertNumber") || droppedTagName.equals("convertDateTime"))) {
                return true;
            }
        } else if (targetTagName.equals("inputText") || targetTagName.equals("selectBooleanCheckbox") || targetTagName.equals("selectManyCheckbox") || targetTagName.equals("selectManyListbox") || targetTagName.equals("selectManyMenu") || targetTagName.equals("selectOneListbox") || targetTagName.equals("selectOneMenu") || targetTagName.equals("selectOneRadio") || targetTagName.equals("selectOneColor") || targetTagName.equals("inputMiniCalendar") ? droppedTaglibUri.equals("http://java.sun.com/jsf/core") && (droppedTagName.equals("valueChangeListener") || droppedTagName.equals("validator") || droppedTagName.equals("converter")) : (targetTagName.equals("inputRichText") ? droppedTaglibUri.equals("http://java.sun.com/jsf/core") && (droppedTagName.equals("validateLength") || droppedTagName.equals("validator")) : (targetTagName.equals("commandButton") || targetTagName.equals("commandLink") || targetTagName.equals("commandExButton") ? droppedTaglibUri.equals("http://java.sun.com/jsf/core") && droppedTagName.equals("actionListener") : droppedTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && (droppedTagName.equals("behavior") || droppedTagName.equals("behaviorKeyPress") || droppedTagName.equals("behaviorRightMouse"))))) {
            return true;
        }
        if (targetTagName.equals("graphDraw") || targetTagName.equals("graphDrawData")) {
            return true;
        }
        if (targetTagName.equals("tree") || targetTagName.equals("treeTable") || targetTagName.equals("treeNodeAttr")) {
            return true;
        }
        return !droppedTaglibUri.equals("http://java.sun.com/jsf/core") && !droppedTaglibUri.equals("http://www.ibm.com/jsf/html_extended") && !droppedTaglibUri.equals("http://www.ibm.com/jsf/rte") && !droppedTaglibUri.equals("http://java.sun.com/jsf/html") && !droppedTaglibUri.equals("http://www.ibm.com/jsf/BrowserFramework");
    }

    private Node findParentTag(Node node) {
        Node parent = node.getParentNode();
        while (parent != null) {
            if (parent.getNodeName().indexOf(58) != -1) {
                return parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    private boolean handleSpecialCases(String parentName, String currentTagName) {
        String selectPrefix = "select";
        String fFacet = this.corePrefix.concat("facet");
        String fParameter = this.corePrefix.concat("param");
        String fAttribute = this.corePrefix.concat("attribute");
        String fPhaseListener = this.corePrefix.concat("phaseListener");
        String fSetPropertyActionListener = this.corePrefix.concat("setPropertyActionListener");
        String hSelectItems = this.htmlPrefix.concat("selectItems");
        String hSelectItem = this.htmlPrefix.concat("selectItem");
        boolean specialCase = false;
        if (parentName.equals(fFacet) || parentName.equals(fParameter) || parentName.equals(fAttribute) || parentName.equals(fPhaseListener) || parentName.equals(fSetPropertyActionListener) || currentTagName.equals(fFacet) || currentTagName.equals(fParameter) || currentTagName.equals(fAttribute) || currentTagName.equals(fPhaseListener) || currentTagName.equals(fSetPropertyActionListener)) {
            specialCase = true;
        } else if (currentTagName.equals(hSelectItems) || currentTagName.equals(hSelectItem)) {
            specialCase = true;
            int index = parentName.lastIndexOf(":");
            if (index > 0 && parentName.length() > index + selectPrefix.length()) {
                String verifySelect = parentName.substring(index + 1, selectPrefix.length());
                verifySelect.equals(selectPrefix);
            }
        }
        return specialCase;
    }

    private void validateIdsValidJava() {
        IDOMDocument doc = this._model.getDocument();
        NodeIterator iter = ((DocumentTraversal)doc).createNodeIterator((Node)doc, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            IStatus val;
            Attr id = this.getAttribute(node, "id");
            String idValue = this.getAttributeValue(id);
            if (idValue != null && !this.isValidExpression(idValue) && (val = JavaConventions.validateJavaTypeName((String)idValue, (String)"1.3", (String)"1.3")).getSeverity() == 4) {
                this.addAttrValueWarning(id, NLS.bind((String)Messages.MESSAGE_JSF_ID_INVALID_JAVA, (Object)idValue));
            }
            node = iter.nextNode();
        }
    }

    private boolean isValidExpression(String id) {
        return id.startsWith(EXPRESSION_START) && id.endsWith(EXPRESSION_END);
    }

    public void setPrefixes() {
        IDOMModel model = this._model;
        IDOMDocument d = model.getDocument();
        TaglibPrefixUtil util = TaglibPrefixUtil.getMapperUtil((Document)d);
        this.corePrefix = String.valueOf(util.getPrefixForUri("http://java.sun.com/jsf/core")) + ":";
        this.htmlPrefix = String.valueOf(util.getPrefixForUri("http://java.sun.com/jsf/html")) + ":";
        this.extendedPrefix = String.valueOf(util.getPrefixForUri("http://www.ibm.com/jsf/html_extended")) + ":";
        this.rtePrefix = String.valueOf(util.getPrefixForUri("http://www.ibm.com/jsf/rte")) + ":";
    }

    public String getCorePrefix() {
        return this.corePrefix;
    }

    public String getHtmlPrefix() {
        return this.htmlPrefix;
    }

    public String getExtendedHtmlPrefix() {
        return this.extendedPrefix;
    }

    public String getExtendedRuntimePrefix() {
        return this.rtePrefix;
    }

    private String getAttributeValue(Attr attr) {
        if (attr == null) {
            return null;
        }
        if (attr instanceof IDOMNode) {
            return ((IDOMNode)attr).getValueSource();
        }
        return attr.getValue();
    }

    private Attr getAttribute(Node node, String name) {
        if (node != null && node.getNodeType() == 1) {
            return ((Element)node).getAttributeNode(name);
        }
        return null;
    }

    private void addAttrValueWarning(Attr attr, String message) {
        if (attr instanceof IDOMNode) {
            IStructuredDocument flatModel;
            ITextRegion region = ((IDOMNode)attr).getValueRegion();
            int offset = 0;
            if (region != null) {
                IDOMElement ownerElement;
                if (attr instanceof IDOMAttr && (ownerElement = (IDOMElement)((IDOMAttr)attr).getOwnerElement()) != null) {
                    offset = ownerElement.getFirstStructuredDocumentRegion().getStartOffset(region);
                }
            } else {
                offset = ((IDOMNode)attr).getStartOffset();
            }
            if ((flatModel = this._model.getStructuredDocument()) != null) {
                int line = flatModel.getLineOfOffset(offset);
                this._validator.addWarning(message, line + 1, offset + 1, region.getLength() > 2 ? region.getLength() - 2 : 0);
            }
        }
    }

    private void addTagWarning(Node tag, String message) {
        if (tag instanceof IDOMElement) {
            int offset = ((IDOMElement)tag).getStartOffset();
            int length = tag.getNodeName().length();
            IStructuredDocument flatModel = this._model.getStructuredDocument();
            if (flatModel != null) {
                int line = flatModel.getLineOfOffset(offset);
                this._validator.addWarning(message, line + 1, offset + 1, length);
            }
        }
    }
}

