/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.util;

import com.ibm.etools.jsf.library.emf.AttributeDefinitionType;
import com.ibm.etools.jsf.library.emf.DataBindingType;
import com.ibm.etools.jsf.library.emf.DropIntentType;
import com.ibm.etools.jsf.library.emf.FacesLibraryFactory;
import com.ibm.etools.jsf.library.emf.LibraryConfigType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.MappingType;
import com.ibm.etools.jsf.library.emf.MappingsType;
import com.ibm.etools.jsf.library.emf.PaletteVisibilityType;
import com.ibm.etools.jsf.library.emf.TagAttributesType;
import com.ibm.etools.jsf.library.emf.TagDropInfoType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.emf.TagTypeType;
import com.ibm.etools.jsf.library.emf.VisualizationType;
import com.ibm.etools.jsf.library.internal.nls.Messages;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.JsfRenderingUtil;
import com.ibm.etools.jsf.util.LibraryGenerationUtil;
import com.ibm.etools.jsf.util.TextNodeUtil;
import com.ibm.etools.jsf.util.TldEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isLibraryProject(IProject project) {
        boolean isLibrary = false;
        try {
            isLibrary = project.hasNature("com.ibm.etools.jsf.library.FacesLibraryNature");
        }
        catch (CoreException coreException) {}
        return isLibrary;
    }

    public static void addLibraryNature(IProject project) {
        if (project != null && project.isOpen()) {
            if (LibraryUtil.isLibraryProject(project)) {
                return;
            }
            try {
                IProjectDescription description = project.getDescription();
                String[] existingNatures = description.getNatureIds();
                String[] newNatures = new String[existingNatures.length + 1];
                System.arraycopy(existingNatures, 0, newNatures, 0, existingNatures.length);
                newNatures[existingNatures.length] = "com.ibm.etools.jsf.library.FacesLibraryNature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void fillTagsFromTLD(LibraryDefinitionType libraryDefinition, Document tldDoc, String categoryName, String jarPath, String[] extraJars, IProject componentLibraryProject, IProgressMonitor monitor) {
        try {
            Node descText;
            NodeList nodes;
            TagLibraryType categoryType = libraryDefinition.getTagLibrary();
            if (categoryType == null) {
                categoryType = FacesLibraryFactory.eINSTANCE.createTagLibraryType();
                libraryDefinition.setTagLibrary(categoryType);
            }
            if ((nodes = tldDoc.getElementsByTagName("taglib")).getLength() == 0) {
                return;
            }
            Element taglib = (Element)nodes.item(0);
            Node uriNode = LibraryUtil.findChildNamed(taglib, "uri");
            if (uriNode == null) {
                return;
            }
            Node uriText = TextNodeUtil.findChildTextNode((Node)uriNode);
            if (uriText == null) {
                return;
            }
            String taglibUri = uriText.getNodeValue();
            if (categoryName == null) {
                Node displayNameText;
                Node displayNameNode = LibraryUtil.findChildNamed(taglib, "display-name");
                categoryName = displayNameNode != null ? ((displayNameText = TextNodeUtil.findChildTextNode((Node)displayNameNode)) != null ? displayNameText.getNodeValue() : taglibUri) : taglibUri;
            }
            categoryType.setLabel(categoryName);
            Node descNode = LibraryUtil.findChildNamed(taglib, "description");
            if (descNode != null && (descText = TextNodeUtil.findChildTextNode((Node)descNode)) != null) {
                categoryType.setDescription(descText.getNodeValue());
            }
            categoryType.setInitiallyOpened(true);
            categoryType.setInitiallyPinned(false);
            categoryType.setVisible(true);
            nodes = taglib.getElementsByTagName("tag");
            if (monitor != null) {
                monitor.subTask(Messages.LibraryUtil_ProcessingTags);
            }
            ArrayList<String> tagNames = new ArrayList<String>();
            HashMap<String, TagType> tagNameToDefMap = new HashMap<String, TagType>();
            int i = 0;
            while (i < nodes.getLength()) {
                Node nameText;
                Element tldTag = (Element)nodes.item(i);
                Node nameNode = LibraryUtil.findChildNamed(tldTag, "name");
                if (nameNode != null && (nameText = TextNodeUtil.findChildTextNode((Node)nameNode)) != null) {
                    Node tagClassNameNode;
                    Node descText2;
                    Node displayNameText;
                    String tagName = nameText.getNodeValue();
                    TagType jldTag = FacesLibraryFactory.eINSTANCE.createTagType();
                    jldTag.setName(tagName);
                    Node displayNameNode = LibraryUtil.findChildNamed(tldTag, "display-name");
                    if (displayNameNode != null && (displayNameText = TextNodeUtil.findChildTextNode((Node)displayNameNode)) != null) {
                        jldTag.setLabel(displayNameText.getNodeValue());
                    }
                    if ((descNode = LibraryUtil.findChildNamed(tldTag, "description")) != null && (descText2 = TextNodeUtil.findChildTextNode((Node)descNode)) != null) {
                        jldTag.setDescription(descText2.getNodeValue());
                    }
                    jldTag.setPaletteVisibility(PaletteVisibilityType.VISIBLE);
                    TagAttributesType attrs = FacesLibraryFactory.eINSTANCE.createTagAttributesType();
                    jldTag.setAttributes(attrs);
                    DataBindingType binding = FacesLibraryFactory.eINSTANCE.createDataBindingType();
                    jldTag.setDataBinding(binding);
                    TagDropInfoType dropInfo = FacesLibraryFactory.eINSTANCE.createTagDropInfoType();
                    jldTag.setDropInfo(dropInfo);
                    VisualizationType vis = FacesLibraryFactory.eINSTANCE.createVisualizationType();
                    jldTag.setVisualization(vis);
                    NodeList attrNodes = tldTag.getElementsByTagName("attribute");
                    ArrayList<String> attrNames = new ArrayList<String>();
                    HashMap<String, String> attrNameDescMap = new HashMap<String, String>();
                    int attrIndex = 0;
                    while (attrIndex < attrNodes.getLength()) {
                        Node attrDescNode;
                        Node attrDescTextNode;
                        Node attrNameText;
                        Node attrNameNode;
                        String attrName = null;
                        Element attr = (Element)attrNodes.item(attrIndex);
                        NodeList names = attr.getElementsByTagName("name");
                        if (names.getLength() > 0 && (attrNameNode = names.item(0)) != null && (attrNameText = TextNodeUtil.findChildTextNode((Node)attrNameNode)) != null) {
                            attrName = attrNameText.getNodeValue();
                        }
                        NodeList descriptions = attr.getElementsByTagName("description");
                        String attrDesc = null;
                        if (descriptions.getLength() > 0 && (attrDescTextNode = TextNodeUtil.findChildTextNode((Node)(attrDescNode = descriptions.item(0)))) != null) {
                            attrDesc = attrDescTextNode.getNodeValue();
                        }
                        if (attrName != null) {
                            attrNames.add(attrName);
                            attrNameDescMap.put(attrName, attrDesc);
                        }
                        ++attrIndex;
                    }
                    Collections.sort(attrNames);
                    int attrCount = 0;
                    while (attrCount < attrNames.size()) {
                        String attrDesc;
                        AttributeDefinitionType attrType = FacesLibraryFactory.eINSTANCE.createAttributeDefinitionType();
                        attrs.getAttribute().add((Object)attrType);
                        String attrName = (String)attrNames.get(attrCount);
                        attrType.setName(attrName);
                        String typeString = LibraryUtil.getDefaultAttrType(attrName);
                        if (typeString != null) {
                            attrType.setType(typeString);
                        }
                        if ((attrDesc = (String)attrNameDescMap.get(attrName)) != null) {
                            attrType.setDescription(attrDesc);
                        }
                        ++attrCount;
                    }
                    Node tagClassNode = LibraryUtil.findChildNamed(tldTag, "tag-class");
                    if (tagClassNode != null && (tagClassNameNode = TextNodeUtil.findChildTextNode((Node)tagClassNode)) != null) {
                        String tagClassName = tagClassNameNode.getNodeValue();
                        if (componentLibraryProject == null) {
                            if (LibraryGenerationUtil.isUIComponentTag((String)tagClassName, (String)jarPath, (String[])extraJars)) {
                                dropInfo.setTagType(TagTypeType.UICOMPONENT);
                            } else if (LibraryGenerationUtil.isConverterTag((String)tagClassName, (String)jarPath, (String[])extraJars)) {
                                dropInfo.setTagType(TagTypeType.CONVERTER);
                            } else if (LibraryGenerationUtil.isValidatorTag((String)tagClassName, (String)jarPath, (String[])extraJars)) {
                                dropInfo.setTagType(TagTypeType.VALIDATOR);
                            } else {
                                dropInfo.setTagType(TagTypeType.NON_JSF);
                            }
                            dropInfo.setAllowsChildren(LibraryGenerationUtil.allowsChildren((String)tagClassName, (String)jarPath, (String[])extraJars));
                            dropInfo.setRequiresForm(LibraryGenerationUtil.requiresForm((String)tagClassName, (String)jarPath, (String[])extraJars));
                            if (LibraryGenerationUtil.checkComponentSuperClass((String)tagClassName, (String)"javax.faces.component.UIData", (String)jarPath, (String[])extraJars)) {
                                if (LibraryUtil.hasAttributeName(tldTag, "var")) {
                                    binding.setRepeatingValueAttribute("var");
                                }
                                binding.setMultiValuedBinding(true);
                            }
                        } else {
                            if (JsfComponentUtil.isJsfTag((String)taglibUri, (String)tagName, (IProject)componentLibraryProject)) {
                                dropInfo.setTagType(TagTypeType.UICOMPONENT);
                            } else if (JsfComponentUtil.isConverterTag((String)taglibUri, (String)tagName, (IProject)componentLibraryProject)) {
                                dropInfo.setTagType(TagTypeType.CONVERTER);
                            } else if (JsfComponentUtil.isValidatorTag((String)taglibUri, (String)tagName, (IProject)componentLibraryProject)) {
                                dropInfo.setTagType(TagTypeType.VALIDATOR);
                            } else {
                                dropInfo.setTagType(TagTypeType.NON_JSF);
                            }
                            dropInfo.setAllowsChildren(JsfRenderingUtil.getRendersChildren((String)taglibUri, (String)tagName, (IProject)componentLibraryProject, null));
                            dropInfo.setRequiresForm(true);
                            if (JsfComponentUtil.checkComponentSuperclass((String)taglibUri, (String)tagName, (IProject)componentLibraryProject, (String)"javax.faces.component.UIData")) {
                                if (LibraryUtil.hasAttributeName(tldTag, "var")) {
                                    binding.setRepeatingValueAttribute("var");
                                }
                                binding.setMultiValuedBinding(true);
                            }
                        }
                        binding.setDropIntent(DropIntentType.BIND);
                        if (attrNames.contains("value")) {
                            binding.setMainBindingAttribute("value");
                        }
                        tagNames.add(tagName);
                        tagNameToDefMap.put(tagName, jldTag);
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                    }
                }
                ++i;
            }
            EList<TagType> tags = categoryType.getTag();
            Collections.sort(tagNames);
            Iterator names = tagNames.iterator();
            while (names.hasNext()) {
                tags.add(tagNameToDefMap.get(names.next()));
            }
        }
        finally {
            LibraryGenerationUtil.freeCachedResources((String)jarPath);
        }
    }

    public static void updateLibraryDefinition(IFile jldFile, IProgressMonitor monitor) {
        LibraryDefinitionType libraryDefinition = LibraryManager.getInstance().getWritableLibraryDefinitionModel((IResource)jldFile);
        if (libraryDefinition == null) {
            return;
        }
        String taglibUri = libraryDefinition.getTaglibUri();
        if (taglibUri == null) {
            return;
        }
        IProject componentLibraryProject = null;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            String compositeTaglibUri;
            IVirtualComponent component;
            if (JsfProjectUtil.isCompositeProject((IProject)projects[i]) && (component = ComponentCore.createComponent((IProject)projects[i])) != null && taglibUri.equals(compositeTaglibUri = (String)component.getMetaProperties().get("JSFComposite.TAGLIB_URI"))) {
                componentLibraryProject = projects[i];
            }
            ++i;
        }
        String jarPath = null;
        String[] extraJars = null;
        String tldPath = null;
        if (componentLibraryProject != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(componentLibraryProject.getName());
            IFolder webContentFolder = (IFolder)ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder();
            String webContentName = webContentFolder.getName();
            jarPath = componentLibraryProject.getLocation().addTrailingSeparator().append(webContentName).addTrailingSeparator().append(componentLibraryProject.getName()).addFileExtension("jar").toOSString();
            File sourceFile = new File(jarPath);
            String fileName = sourceFile.getName();
            IFolder libraryFolder = (IFolder)jldFile.getParent();
            IFile targetFile = libraryFolder.getFile(fileName);
            try {
                FileInputStream sourceStream = new FileInputStream(sourceFile);
                if (!targetFile.exists()) {
                    targetFile.create((InputStream)sourceStream, true, null);
                } else {
                    targetFile.setContents((InputStream)sourceStream, true, false, null);
                }
                sourceStream.close();
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
            tldPath = LibraryUtil.checkJarForTld(jarPath, taglibUri);
        } else {
            MappingsType mappings;
            ArrayList<String> extraJarsList = new ArrayList<String>();
            IFolder definitionFolder = (IFolder)jldFile.getParent();
            LibraryConfigType config = libraryDefinition.getLibraryConfig();
            if (config != null && (mappings = config.getFileMappings()) != null) {
                EList<MappingType> mappingsList = mappings.getMapping();
                for (MappingType mapping : mappingsList) {
                    IFile sourceFile;
                    String sourcePath = mapping.getSourcePath();
                    if (sourcePath == null || !sourcePath.endsWith(".jar") || !(sourceFile = definitionFolder.getFile((IPath)new Path(sourcePath))).exists()) continue;
                    String fullSourcePath = sourceFile.getLocation().toOSString();
                    tldPath = LibraryUtil.checkJarForTld(fullSourcePath, taglibUri);
                    if (tldPath != null) {
                        jarPath = fullSourcePath;
                        if (libraryDefinition.getTldFile().equals(tldPath)) break;
                        libraryDefinition.setTldFile(tldPath);
                        break;
                    }
                    extraJarsList.add(fullSourcePath);
                }
                extraJars = extraJarsList.toArray(new String[0]);
            }
        }
        if (tldPath == null) {
            return;
        }
        Document tldDoc = LibraryUtil.getTldDoc(jarPath, tldPath);
        LibraryUtil.updateTagsAndAttributesFromTLD(libraryDefinition, tldDoc, jarPath, extraJars, componentLibraryProject, monitor);
        LibraryManager.getInstance().saveLibraryDefinitionModel(libraryDefinition);
    }

    /*
     * Exception decompiling
     */
    private static String checkJarForTld(String jarPath, String taglibUri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 24[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Document getTldDoc(String jarPath, String tldPath) {
        ZipEntry entry;
        ZipFile zipFile;
        Document doc;
        block21: {
            doc = null;
            zipFile = null;
            zipFile = new ZipFile(jarPath);
            entry = zipFile.getEntry(tldPath);
            if (entry != null) break block21;
            if (zipFile == null) return null;
            try {
                zipFile.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)new TldEntityResolver());
            InputStream stream = zipFile.getInputStream(entry);
            InputSource source = new InputSource("jar:file:///" + jarPath + "!/" + entry.getName());
            source.setByteStream(stream);
            doc = builder.parse(source);
            stream.close();
        }
        catch (IOException iOException) {
            if (zipFile == null) return doc;
            try {
                zipFile.close();
                return doc;
            }
            catch (IOException iOException2) {}
            return doc;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (zipFile == null) return doc;
            try {
                zipFile.close();
                return doc;
            }
            catch (IOException iOException) {}
            return doc;
        }
        catch (SAXException sAXException) {
            if (zipFile == null) return doc;
            {
                catch (Throwable throwable) {
                    if (zipFile == null) throw throwable;
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                zipFile.close();
                return doc;
            }
            catch (IOException iOException) {}
            return doc;
        }
        if (zipFile == null) return doc;
        try {
            zipFile.close();
            return doc;
        }
        catch (IOException iOException) {}
        return doc;
    }

    private static void updateTagsAndAttributesFromTLD(LibraryDefinitionType libraryDefinition, Document tldDoc, String jarPath, String[] extraJars, IProject componentLibraryProject, IProgressMonitor monitor) {
        try {
            TagLibraryType taglibType = libraryDefinition.getTagLibrary();
            EList<TagType> jldTags = taglibType.getTag();
            String taglibUri = libraryDefinition.getTaglibUri();
            NodeList nodes = tldDoc.getElementsByTagName("taglib");
            if (nodes.getLength() == 0) {
                return;
            }
            Element taglib = (Element)nodes.item(0);
            nodes = taglib.getElementsByTagName("tag");
            if (monitor != null) {
                monitor.subTask(Messages.LibraryUtil_ProcessingTags);
            }
            ArrayList<String> attrNames = new ArrayList<String>();
            HashMap<String, String> attrNameDescMap = new HashMap<String, String>();
            int i = 0;
            while (i < nodes.getLength()) {
                block45: {
                    String attrDesc;
                    TagType jldTag;
                    Element tldTag;
                    block46: {
                        Node tagClassNameNode;
                        Node descText;
                        Node descNode;
                        Node displayNameText;
                        Node nameText;
                        tldTag = (Element)nodes.item(i);
                        attrNames.clear();
                        attrNameDescMap.clear();
                        Node nameNode = LibraryUtil.findChildNamed(tldTag, "name");
                        if (nameNode == null || (nameText = TextNodeUtil.findChildTextNode((Node)nameNode)) == null) break block45;
                        String tagName = nameText.getNodeValue();
                        jldTag = null;
                        jldTag = LibraryUtil.findExistingTag(jldTags, tagName);
                        if (jldTag != null) break block46;
                        jldTag = FacesLibraryFactory.eINSTANCE.createTagType();
                        jldTag.setName(tagName);
                        Node displayNameNode = LibraryUtil.findChildNamed(tldTag, "display-name");
                        if (displayNameNode != null && (displayNameText = TextNodeUtil.findChildTextNode((Node)displayNameNode)) != null) {
                            jldTag.setLabel(displayNameText.getNodeValue());
                        }
                        if ((descNode = LibraryUtil.findChildNamed(tldTag, "description")) != null && (descText = TextNodeUtil.findChildTextNode((Node)descNode)) != null) {
                            jldTag.setDescription(descText.getNodeValue());
                        }
                        jldTag.setPaletteVisibility(PaletteVisibilityType.VISIBLE);
                        TagAttributesType attrs = FacesLibraryFactory.eINSTANCE.createTagAttributesType();
                        jldTag.setAttributes(attrs);
                        DataBindingType binding = FacesLibraryFactory.eINSTANCE.createDataBindingType();
                        jldTag.setDataBinding(binding);
                        TagDropInfoType dropInfo = FacesLibraryFactory.eINSTANCE.createTagDropInfoType();
                        jldTag.setDropInfo(dropInfo);
                        VisualizationType vis = FacesLibraryFactory.eINSTANCE.createVisualizationType();
                        jldTag.setVisualization(vis);
                        Node tagClassNode = LibraryUtil.findChildNamed(tldTag, "tag-class");
                        if (tagClassNode == null || (tagClassNameNode = TextNodeUtil.findChildTextNode((Node)tagClassNode)) == null) break block45;
                        String tagClassName = tagClassNameNode.getNodeValue();
                        if (componentLibraryProject == null) {
                            if (LibraryGenerationUtil.isUIComponentTag((String)tagClassName, (String)jarPath, (String[])extraJars)) {
                                dropInfo.setTagType(TagTypeType.UICOMPONENT);
                            } else if (LibraryGenerationUtil.isConverterTag((String)tagClassName, (String)jarPath, (String[])extraJars)) {
                                dropInfo.setTagType(TagTypeType.CONVERTER);
                            } else if (LibraryGenerationUtil.isValidatorTag((String)tagClassName, (String)jarPath, (String[])extraJars)) {
                                dropInfo.setTagType(TagTypeType.VALIDATOR);
                            } else {
                                dropInfo.setTagType(TagTypeType.NON_JSF);
                            }
                            dropInfo.setAllowsChildren(LibraryGenerationUtil.allowsChildren((String)tagClassName, (String)jarPath, (String[])extraJars));
                            dropInfo.setRequiresForm(LibraryGenerationUtil.requiresForm((String)tagClassName, (String)jarPath, (String[])extraJars));
                            if (LibraryGenerationUtil.checkComponentSuperClass((String)tagClassName, (String)"javax.faces.component.UIData", (String)jarPath, (String[])extraJars)) {
                                if (LibraryUtil.hasAttributeName(tldTag, "var")) {
                                    binding.setRepeatingValueAttribute("var");
                                }
                                binding.setMultiValuedBinding(true);
                            }
                        } else {
                            if (JsfComponentUtil.isJsfTag((String)taglibUri, (String)tagName, (IProject)componentLibraryProject)) {
                                dropInfo.setTagType(TagTypeType.UICOMPONENT);
                            } else if (JsfComponentUtil.isConverterTag((String)taglibUri, (String)tagName, (IProject)componentLibraryProject)) {
                                dropInfo.setTagType(TagTypeType.CONVERTER);
                            } else if (JsfComponentUtil.isValidatorTag((String)taglibUri, (String)tagName, (IProject)componentLibraryProject)) {
                                dropInfo.setTagType(TagTypeType.VALIDATOR);
                            } else {
                                dropInfo.setTagType(TagTypeType.NON_JSF);
                            }
                            dropInfo.setAllowsChildren(JsfRenderingUtil.getRendersChildren((String)taglibUri, (String)tagName, (IProject)componentLibraryProject, null));
                            dropInfo.setRequiresForm(true);
                            if (JsfComponentUtil.checkComponentSuperclass((String)taglibUri, (String)tagName, (IProject)componentLibraryProject, (String)"javax.faces.component.UIData")) {
                                if (LibraryUtil.hasAttributeName(tldTag, "var")) {
                                    binding.setRepeatingValueAttribute("var");
                                }
                                binding.setMultiValuedBinding(true);
                            }
                        }
                        binding.setDropIntent(DropIntentType.BIND);
                        if (attrNames.contains("value")) {
                            binding.setMainBindingAttribute("value");
                        }
                        jldTags.add(jldTag);
                    }
                    NodeList attrNodes = tldTag.getElementsByTagName("attribute");
                    int attrIndex = 0;
                    while (attrIndex < attrNodes.getLength()) {
                        Node attrDescNode;
                        Node attrDescTextNode;
                        Node attrNameText;
                        Node attrNameNode;
                        String attrName = null;
                        Element attr = (Element)attrNodes.item(attrIndex);
                        NodeList names = attr.getElementsByTagName("name");
                        if (names.getLength() > 0 && (attrNameNode = names.item(0)) != null && (attrNameText = TextNodeUtil.findChildTextNode((Node)attrNameNode)) != null) {
                            attrName = attrNameText.getNodeValue();
                        }
                        NodeList descriptions = attr.getElementsByTagName("description");
                        attrDesc = null;
                        if (descriptions.getLength() > 0 && (attrDescTextNode = TextNodeUtil.findChildTextNode((Node)(attrDescNode = descriptions.item(0)))) != null) {
                            attrDesc = attrDescTextNode.getNodeValue();
                        }
                        if (attrName != null) {
                            attrNames.add(attrName);
                            attrNameDescMap.put(attrName, attrDesc);
                        }
                        ++attrIndex;
                    }
                    Collections.sort(attrNames);
                    EList<AttributeDefinitionType> jldAttrs = jldTag.getAttributes().getAttribute();
                    int attrCount = 0;
                    while (attrCount < attrNames.size()) {
                        String attrName = (String)attrNames.get(attrCount);
                        AttributeDefinitionType attrType = LibraryUtil.findExistingAttribute(jldAttrs, attrName);
                        if (attrType == null) {
                            attrType = FacesLibraryFactory.eINSTANCE.createAttributeDefinitionType();
                            attrType.setName(attrName);
                            String typeString = LibraryUtil.getDefaultAttrType(attrName);
                            if (typeString != null) {
                                attrType.setType(typeString);
                            }
                            if ((attrDesc = (String)attrNameDescMap.get(attrName)) != null) {
                                attrType.setDescription(attrDesc);
                            }
                            if (attrCount == 0) {
                                jldAttrs.add(0, attrType);
                            } else {
                                String previousAttrName = (String)attrNames.get(attrCount - 1);
                                AttributeDefinitionType previousAttrType = LibraryUtil.findExistingAttribute(jldAttrs, previousAttrName);
                                int newIndex = jldAttrs.indexOf(previousAttrType) + 1;
                                if (newIndex < jldAttrs.size()) {
                                    jldAttrs.add(newIndex, attrType);
                                } else {
                                    jldAttrs.add(attrType);
                                }
                            }
                        }
                        ++attrCount;
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                ++i;
            }
        }
        finally {
            LibraryGenerationUtil.freeCachedResources((String)jarPath);
        }
    }

    private static TagType findExistingTag(List<TagType> jldTags, String tagName) {
        for (TagType tag : jldTags) {
            if (!tag.getName().equals(tagName)) continue;
            return tag;
        }
        return null;
    }

    private static AttributeDefinitionType findExistingAttribute(List<AttributeDefinitionType> attrs, String attrName) {
        for (AttributeDefinitionType attr : attrs) {
            if (!attr.getName().equals(attrName)) continue;
            return attr;
        }
        return null;
    }

    private static String getDefaultAttrType(String attrName) {
        if (attrName == null) {
            return null;
        }
        if ("id".equals(attrName)) {
            return "component_id";
        }
        if ("binding".equals(attrName)) {
            return "component_binding";
        }
        if ("immediate".equals(attrName) || "rendered".equals(attrName) || "disabled".equals(attrName) || "readonly".equals(attrName) || "escape".equals(attrName) || "required".equals(attrName)) {
            return "boolean";
        }
        if ("border".equals(attrName) || "cellpadding".equals(attrName) || "cellspacing".equals(attrName) || "cols".equals(attrName) || "width".equals(attrName) || "height".equals(attrName) || "rows".equals(attrName) || "first".equals(attrName) || "size".equals(attrName) || "tabindex".equals(attrName) || "hspace".equals(attrName) || "vspace".equals(attrName)) {
            return "integer";
        }
        if ("converter".equals(attrName)) {
            return "converter_id";
        }
        if ("value".equals(attrName)) {
            return "value_binding";
        }
        if ("dir".equals(attrName)) {
            return "enum {ltr, rtl}";
        }
        if ("align".equals(attrName)) {
            return "enum {left, center, right}";
        }
        if ("valign".equals(attrName)) {
            return "enum {top, middle, bottom}";
        }
        if ("shape".equals(attrName)) {
            return "enum {rect, circle, poly}";
        }
        if ("frame".equals(attrName)) {
            return "enum {void, above, below, hsides, vsides, lhs, rhs, box, border}";
        }
        if ("rules".equals(attrName)) {
            return "enum {none, groups, rows, cols, all}";
        }
        if ("styleClass".equals(attrName)) {
            return "css_class";
        }
        if ("style".equals(attrName)) {
            return "css_style";
        }
        if (attrName.endsWith("color")) {
            return "color";
        }
        if (attrName.equals("accesskey")) {
            return "char";
        }
        if ("for".equals(attrName)) {
            return "for";
        }
        if ("image".equals(attrName)) {
            return "web_path";
        }
        if ("rel".equals(attrName) || "rev".equals(attrName)) {
            return "link";
        }
        if ("action".equals(attrName)) {
            return "action";
        }
        if ("actionListener".equals(attrName)) {
            return "method_binding {;handle,Action;actionEvent;javax.faces.event.ActionEvent;;}";
        }
        if ("valueChangeListener".equals(attrName)) {
            return "method_binding {;handle,ValueChange;valueChangedEvent;javax.faces.event.ValueChangeEvent;;}";
        }
        if ("validator".equals(attrName)) {
            return "method_binding {;handle,Validate;facescontext,component,object;javax.faces.context.FacesContext,javax.faces.component.UIComponent,java.lang.Object;}";
        }
        if ("lang".equals(attrName) || "hreflang".equals(attrName)) {
            return "language";
        }
        if ("maxlength".equals(attrName)) {
            return "length";
        }
        if ("onabort".equals(attrName) || "onblur".equals(attrName) || "onchange".equals(attrName) || "onclick".equals(attrName) || "ondblclick".equals(attrName) || "ondragdrop".equals(attrName) || "onerror".equals(attrName) || "onfocus".equals(attrName) || "onhelp".equals(attrName) || "onkeydown".equals(attrName) || "onkeypress".equals(attrName) || "onkeyup".equals(attrName) || "onload".equals(attrName) || "onmousedown".equals(attrName) || "onmousemove".equals(attrName) || "onmouseout".equals(attrName) || "onmouseover".equals(attrName) || "onmouseup".equals(attrName) || "onmove".equals(attrName) || "onreset".equals(attrName) || "onresize".equals(attrName) || "onselect".equals(attrName) || "onsubmit".equals(attrName) || "onunload".equals(attrName)) {
            return "script";
        }
        if ("var".equals(attrName)) {
            return "var";
        }
        return null;
    }

    private static boolean hasAttributeName(Element tagElement, String attrName) {
        NodeList attributeNodes = tagElement.getElementsByTagName("attribute");
        int attrIndex = 0;
        while (attrIndex < attributeNodes.getLength()) {
            String foundAttrName;
            Node name;
            NodeList children;
            Element attrNode = (Element)attributeNodes.item(attrIndex);
            NodeList nameNodes = attrNode.getElementsByTagName("name");
            if (nameNodes.getLength() > 0 && (children = (name = nameNodes.item(0)).getChildNodes()).getLength() > 0 && attrName.equals(foundAttrName = children.item(0).getNodeValue())) {
                return true;
            }
            ++attrIndex;
        }
        return false;
    }

    private static Node findChildNamed(Node parentNode, String childName) {
        NodeList nodes = parentNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (childName.equals(node.getNodeName())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public static IPath constructWorkspaceRelativePath(IPath libraryDefinitionFilePath, String path) {
        IPath parentPath = libraryDefinitionFilePath.removeLastSegments(1);
        return parentPath.append(path);
    }

    public static boolean checkUpdatableLibraryTaglib(IProject project, String taglibUri) {
        if (!JsfProjectUtil.isJsfProject((IProject)project)) {
            return false;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return false;
        }
        Properties metaProps = component.getMetaProperties();
        if (metaProps.containsKey(taglibUri)) {
            String availableVersion;
            String installedVersion = metaProps.getProperty(taglibUri);
            LibraryDefinitionType libDef = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUri);
            if (libDef != null && (availableVersion = libDef.getVersion()) != null && LibraryManager.getInstance().compareVersions(installedVersion, availableVersion) > 0) {
                return true;
            }
        }
        return false;
    }
}

