/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.util;

import com.ibm.etools.jsf.library.Debug;
import com.ibm.etools.jsf.library.emf.AttributeDefinitionType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.emf.util.EmfResourceFactoryImpl;
import com.ibm.etools.jsf.library.event.ILibraryDefinitionChangeListener;
import com.ibm.etools.jsf.library.event.LibraryDefinitionChangeEvent;
import com.ibm.etools.jsf.library.internal.palette.PaletteRefreshListener;
import com.ibm.etools.jsf.library.internal.registry.ProductTaglibRegistry;
import com.ibm.etools.jsf.library.util.LibraryUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class LibraryManager
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static final String EMPTY_LIBRARY_DEFINITION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<library-definition xmlns=\"http://www.ibm.com/facesLibrary\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/facesLibrary http://www.ibm.com/facesLibrary.xsd\"></library-definition>";
    private static LibraryManager theInstance;
    private static List<IProject> libraryProjectsList;
    private static Map<String, IPath> taglibUriToPathMap;
    private static Map<IPath, LibraryDefinitionType> pathToModelMap;
    private static List<ILibraryDefinitionChangeListener> listeners;

    static {
        libraryProjectsList = new ArrayList<IProject>();
        taglibUriToPathMap = new HashMap<String, IPath>();
        pathToModelMap = new HashMap<IPath, LibraryDefinitionType>();
        listeners = new ArrayList<ILibraryDefinitionChangeListener>();
    }

    private LibraryManager() {
        this.init();
        this.addLibraryDefinitionChangeListener(new PaletteRefreshListener());
    }

    public static synchronized LibraryManager getInstance() {
        if (theInstance == null) {
            theInstance = new LibraryManager();
        }
        return theInstance;
    }

    private void init() {
        Debug.trace("[lib] library manager initializing", "library");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (LibraryUtil.isLibraryProject(projects[i])) {
                Debug.trace("[lib] scanning library project: " + projects[i].getName(), "library");
                List<IResource> files = this.internalFindLibraryDefinitionFiles((IContainer)projects[i]);
                ArrayList<IPath> filePaths = new ArrayList<IPath>();
                int fileCount = 0;
                while (fileCount < files.size()) {
                    filePaths.add(files.get(fileCount).getFullPath());
                    this.scanForTaglibUri(files.get(fileCount));
                    ++fileCount;
                }
                this.addLibraryProject(projects[i]);
            }
            ++i;
        }
        root.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (event.getType() == 4 || event.getType() == 2) {
            IProject project = (IProject)event.getResource();
            this.handleProjectRemoval(project);
        } else if (event.getType() == 1 && (delta = event.getDelta()) != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {}
        }
    }

    private void handleProjectRemoval(IProject project) {
        if (libraryProjectsList.contains(project)) {
            List<IPath> pathsToRemove = this.getPathsForRemovedProject(project);
            int i = 0;
            while (i < pathsToRemove.size()) {
                IPath locationPathToRemove = pathsToRemove.get(i);
                pathToModelMap.remove(locationPathToRemove);
                Debug.trace("[lib] removed cached EMF model for: " + locationPathToRemove.toOSString(), "library");
                String uriToRemove = this.getUriForPath(locationPathToRemove);
                if (uriToRemove != null) {
                    taglibUriToPathMap.remove(uriToRemove);
                    Debug.trace("[lib] removed library for: " + uriToRemove, "library");
                }
                this.fireChangeEvent(uriToRemove, locationPathToRemove, (short)2);
                ++i;
            }
            libraryProjectsList.remove(project);
            Debug.trace("[lib] removed library project: " + project.getName(), "library");
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                if ((delta.getFlags() & 0x4000) > 0 && project.isOpen()) {
                    Debug.trace("[lib] checking new project: " + project.getName(), "library");
                    if (LibraryUtil.isLibraryProject(project)) {
                        List<IResource> files = this.internalFindLibraryDefinitionFiles((IContainer)project);
                        ArrayList<IPath> filePaths = new ArrayList<IPath>();
                        int fileCount = 0;
                        while (fileCount < files.size()) {
                            filePaths.add(files.get(fileCount).getFullPath());
                            String taglibUri = this.scanForTaglibUri(files.get(fileCount));
                            if (taglibUri != null) {
                                this.fireChangeEvent(taglibUri, files.get(fileCount).getLocation(), (short)1);
                            }
                            ++fileCount;
                        }
                        this.addLibraryProject(project);
                        return false;
                    }
                }
            } else if (resource.getType() == 1) {
                IProject project = resource.getProject();
                if (!LibraryUtil.isLibraryProject(project)) {
                    return true;
                }
                if ("jld".equals(((IFile)resource).getFileExtension())) {
                    if ((delta.getKind() & 2) > 0) {
                        IPath path = resource.getLocation();
                        if (taglibUriToPathMap.containsValue(path)) {
                            for (String uri : taglibUriToPathMap.keySet()) {
                                if (!taglibUriToPathMap.get(uri).equals((Object)path)) continue;
                                IPath pathToRemove = taglibUriToPathMap.remove(uri);
                                pathToModelMap.remove(pathToRemove);
                                Debug.trace("[lib] removed cached EMF model for deleted file: " + path, "library");
                                Debug.trace("[lib] file deletion: removed library definition for '" + uri + "'", "library");
                                this.fireChangeEvent(uri, pathToRemove, (short)2);
                                break;
                            }
                        } else if (pathToModelMap.containsKey(path)) {
                            pathToModelMap.remove(path);
                            Debug.trace("[lib] removed cached EMF model for deleted file: " + path, "library");
                        }
                    } else if ((delta.getKind() & 1) > 0) {
                        String taglibUri = this.scanForTaglibUri(resource);
                        if (taglibUri != null) {
                            this.fireChangeEvent(taglibUri, resource.getLocation(), (short)1);
                        }
                    } else if ((delta.getKind() & 4) > 0) {
                        pathToModelMap.remove(resource.getLocation());
                        Debug.trace("[lib] removed cached EMF model for changed file: " + resource.getLocation(), "library");
                        String taglibUri = this.scanForTaglibUri(resource);
                        if (taglibUri != null) {
                            this.fireChangeEvent(taglibUri, resource.getLocation(), (short)3);
                        }
                    }
                }
            }
        }
        return true;
    }

    private List<IPath> getPathsForRemovedProject(IProject project) {
        ArrayList<IPath> pathsToRemove = new ArrayList<IPath>();
        IPath projectLoc = project.getLocation();
        for (IPath path : taglibUriToPathMap.values()) {
            if (!projectLoc.isPrefixOf(path)) continue;
            pathsToRemove.add(path);
        }
        for (IPath path : pathToModelMap.keySet()) {
            if (!projectLoc.isPrefixOf(path) || pathsToRemove.contains(path)) continue;
            pathsToRemove.add(path);
        }
        return pathsToRemove;
    }

    private String getUriForPath(IPath path) {
        for (Map.Entry<String, IPath> entry : taglibUriToPathMap.entrySet()) {
            if (!entry.getValue().equals((Object)path)) continue;
            return entry.getKey();
        }
        return null;
    }

    public IProject[] getLibraryProjects() {
        return libraryProjectsList.toArray(new IProject[0]);
    }

    private String scanForTaglibUri(IResource configFile) {
        LibraryDefinitionType lib = this.getLibraryDefinitionModel(configFile);
        String taglibUri = null;
        if (lib != null) {
            taglibUri = lib.getTaglibUri();
            if (ProductTaglibRegistry.getInstance().getProductTaglibUris().contains(taglibUri)) {
                Debug.trace("[lib] ignoring library definition for product-supplied taglib: " + configFile.getLocation(), "library");
                return null;
            }
            IPath configPath = configFile.getLocation();
            if (taglibUriToPathMap.containsValue(configPath)) {
                for (String existingUri : taglibUriToPathMap.keySet()) {
                    if (!taglibUriToPathMap.get(existingUri).equals((Object)configPath) || existingUri == null || existingUri.equals(taglibUri)) continue;
                    taglibUriToPathMap.remove(existingUri);
                    Debug.trace("[lib] taglibUri change in config file - removed library definition for '" + existingUri + "'", "library");
                    this.fireChangeEvent(existingUri, configPath, (short)2);
                    break;
                }
            }
            if (taglibUri == null) {
                Debug.trace("[lib] null taglib URI found in: " + configFile.getLocation().toOSString() + " - waiting for further changes", "library");
            } else if (taglibUriToPathMap.containsKey(taglibUri)) {
                if (configPath.equals((Object)taglibUriToPathMap.get(taglibUri))) {
                    return taglibUri;
                }
                Debug.trace("[lib] duplicate taglib URI '" + taglibUri + "' found in: " + configFile.getLocation().toOSString(), "library");
                IPath existingConfigPath = taglibUriToPathMap.get(taglibUri);
                IFile existingConfig = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(existingConfigPath);
                if (existingConfig == null || !existingConfig.exists()) {
                    Debug.trace("[lib] existing config file for '" + taglibUri + "' doesn't exist - overwriting mapping", "library");
                    taglibUriToPathMap.put(taglibUri, configFile.getLocation());
                    Debug.trace("[lib] added taglib '" + taglibUri + "' from: " + configFile.getLocation().toOSString(), "library");
                    this.addLibraryProject(configFile.getProject());
                } else {
                    String newVersion;
                    String existingVersion = null;
                    LibraryDefinitionType existingLib = this.getLibraryDefinitionModel((IResource)existingConfig);
                    if (existingLib != null) {
                        existingVersion = existingLib.getVersion();
                    }
                    if ((newVersion = lib.getVersion()) != null && existingVersion != null) {
                        if (this.compareVersions(existingVersion, newVersion) >= 0) {
                            taglibUriToPathMap.put(taglibUri, configFile.getLocation());
                            Debug.trace("[lib] equal or higher version - replaced taglib '" + taglibUri + "' from: " + configFile.getLocation().toOSString(), "library");
                            this.addLibraryProject(configFile.getProject());
                        } else {
                            Debug.trace("[lib] lower version - ignoring: " + configFile.getLocation().toOSString(), "library");
                        }
                    } else if (newVersion != null) {
                        taglibUriToPathMap.put(taglibUri, configFile.getLocation());
                        Debug.trace("[lib] null version - replaced taglib '" + taglibUri + "' from: " + configFile.getLocation().toOSString(), "library");
                        this.addLibraryProject(configFile.getProject());
                    } else if (existingVersion != null) {
                        Debug.trace("[lib] null version - ignoring config: " + configFile.getLocation().toOSString(), "library");
                    } else {
                        taglibUriToPathMap.put(taglibUri, configFile.getLocation());
                        Debug.trace("[lib] both null versions - replaced taglib '" + taglibUri + "' from: " + configFile.getLocation().toOSString(), "library");
                        this.addLibraryProject(configFile.getProject());
                    }
                }
            } else {
                taglibUriToPathMap.put(taglibUri, configFile.getLocation());
                Debug.trace("[lib] added taglib '" + taglibUri + "' from: " + configFile.getLocation().toOSString(), "library");
                this.addLibraryProject(configFile.getProject());
            }
        }
        return taglibUri;
    }

    private void addLibraryProject(IProject project) {
        if (!libraryProjectsList.contains(project)) {
            libraryProjectsList.add(project);
            Debug.trace("[lib] added library project: " + project.getName(), "library");
        }
    }

    private List<IResource> internalFindLibraryDefinitionFiles(IContainer parent) {
        ArrayList<IResource> defs = new ArrayList<IResource>();
        try {
            IResource[] members = parent.members();
            int i = 0;
            while (i < members.length) {
                if ("jld".equals(members[i].getFileExtension())) {
                    defs.add(members[i]);
                }
                if (members[i] instanceof IContainer) {
                    defs.addAll(this.internalFindLibraryDefinitionFiles((IContainer)members[i]));
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return defs;
    }

    public IResource createLibraryDefinitionFile(IProject project, IPath projectRelativePath) {
        IFile file;
        if (!LibraryUtil.isLibraryProject(project)) {
            LibraryUtil.addLibraryNature(project);
        }
        if ((file = project.getFile(projectRelativePath)).exists()) {
            return file;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(EMPTY_LIBRARY_DEFINITION.getBytes());
        try {
            file.create((InputStream)stream, true, null);
            return file;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String internationalize(Properties prop, String str) {
        if (str == null) {
            return str;
        }
        if (!str.startsWith("%")) {
            return str;
        }
        if (prop.getProperty(str.replace("%", "")) == null) {
            return str;
        }
        return prop.getProperty(str.replace("%", ""));
    }

    public LibraryDefinitionType getLibraryDefinitionModel(IResource libraryDefinitionFile) {
        if (libraryDefinitionFile == null || !libraryDefinitionFile.exists()) {
            return null;
        }
        if (pathToModelMap.containsKey(libraryDefinitionFile.getLocation())) {
            return pathToModelMap.get(libraryDefinitionFile.getLocation());
        }
        try {
            EmfResourceFactoryImpl factory = new EmfResourceFactoryImpl();
            URI resourceURI = URI.createPlatformResourceURI((String)libraryDefinitionFile.getFullPath().toString(), (boolean)true);
            Resource emfModel = factory.createResource(resourceURI);
            emfModel.load(Collections.EMPTY_MAP);
            if (!emfModel.getContents().isEmpty()) {
                LibraryDefinitionType libDef = (LibraryDefinitionType)emfModel.getContents().get(0);
                String path = libraryDefinitionFile.getProjectRelativePath().toOSString();
                path = path.replace(".jld", ".properties");
                if (libraryDefinitionFile.getProject().findMember(path) != null) {
                    IFile iFile = libraryDefinitionFile.getProject().getFile(path);
                    Properties prop = new Properties();
                    prop.load(iFile.getContents());
                    libDef.setDescription(this.internationalize(prop, libDef.getDescription()));
                    libDef.setLabel(this.internationalize(prop, libDef.getLabel()));
                    for (TagType tagType : libDef.getTagLibrary().getTag()) {
                        tagType.setDescription(this.internationalize(prop, tagType.getDescription()));
                        tagType.setLabel(this.internationalize(prop, tagType.getLabel()));
                        for (AttributeDefinitionType attrDefType : tagType.getAttributes().getAttribute()) {
                            attrDefType.setDescription(this.internationalize(prop, attrDefType.getDescription()));
                        }
                    }
                }
                pathToModelMap.put(libraryDefinitionFile.getLocation(), libDef);
                Debug.trace("[lib] cached EMF model for: " + libraryDefinitionFile.getLocation(), "library");
                return libDef;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public LibraryDefinitionType getWritableLibraryDefinitionModel(IResource libraryDefinitionFile) {
        if (libraryDefinitionFile == null || !libraryDefinitionFile.exists()) {
            return null;
        }
        try {
            EmfResourceFactoryImpl factory = new EmfResourceFactoryImpl();
            URI resourceURI = URI.createPlatformResourceURI((String)libraryDefinitionFile.getFullPath().toString(), (boolean)true);
            Resource emfModel = factory.createResource(resourceURI);
            emfModel.load(Collections.EMPTY_MAP);
            if (!emfModel.getContents().isEmpty()) {
                LibraryDefinitionType libDef = (LibraryDefinitionType)emfModel.getContents().get(0);
                return libDef;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public void saveLibraryDefinitionModel(LibraryDefinitionType libraryDefinition) {
        if (libraryDefinition != null) {
            try {
                libraryDefinition.eResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException iOException) {}
        }
    }

    public LibraryDefinitionType getLibraryDefinitionModel(String taglibUri) {
        if (taglibUri == null) {
            return null;
        }
        IPath path = taglibUriToPathMap.get(taglibUri);
        if (path != null) {
            IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            return this.getLibraryDefinitionModel((IResource)resource);
        }
        return null;
    }

    public IPath getLibraryDefinitionFilePath(String taglibUri) {
        if (taglibUri == null) {
            return null;
        }
        return taglibUriToPathMap.get(taglibUri);
    }

    public boolean isLibraryDefined(String taglibUri) {
        return this.getLibraryDefinitionFilePath(taglibUri) != null;
    }

    public String[] getLibraryTaglibUris() {
        return taglibUriToPathMap.keySet().toArray(new String[0]);
    }

    int compareVersions(String existing, String target) {
        if (existing == null) {
            existing = "";
        }
        if (target == null) {
            target = "";
        }
        StringTokenizer existingTokenizer = new StringTokenizer(existing, ".");
        String[] existingSegments = new String[4];
        int count = 0;
        while (existingTokenizer.hasMoreTokens()) {
            existingSegments[count++] = existingTokenizer.nextToken();
        }
        int i = count;
        while (i < 4) {
            existingSegments[i] = "0";
            ++i;
        }
        StringTokenizer targetTokenizer = new StringTokenizer(target, ".");
        String[] targetSegments = new String[4];
        count = 0;
        while (targetTokenizer.hasMoreTokens()) {
            targetSegments[count++] = targetTokenizer.nextToken();
        }
        int i2 = count;
        while (i2 < 4) {
            targetSegments[i2] = "0";
            ++i2;
        }
        try {
            int result = Integer.parseInt(targetSegments[0]) - Integer.parseInt(existingSegments[0]);
            if (result != 0) {
                return result;
            }
            result = Integer.parseInt(targetSegments[1]) - Integer.parseInt(existingSegments[1]);
            if (result != 0) {
                return result;
            }
            result = Integer.parseInt(targetSegments[2]) - Integer.parseInt(existingSegments[2]);
            if (result != 0) {
                return result;
            }
            return targetSegments[3].compareTo(existingSegments[3]);
        }
        catch (NumberFormatException numberFormatException) {
            return target.compareTo(existing);
        }
    }

    public TagType getTagModel(String taglibUri, String tagName) {
        TagLibraryType palette;
        LibraryDefinitionType library = this.getLibraryDefinitionModel(taglibUri);
        if (library != null && (palette = library.getTagLibrary()) != null) {
            for (TagType tag : palette.getTag()) {
                if (!tagName.equals(tag.getName())) continue;
                return tag;
            }
        }
        return null;
    }

    public void addLibraryDefinitionChangeListener(ILibraryDefinitionChangeListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void removeLibraryDefinitionChangeListener(ILibraryDefinitionChangeListener listener) {
        listeners.remove(listener);
    }

    private void fireChangeEvent(String taglibUri, IPath path, short type) {
        LibraryDefinitionChangeEvent event = new LibraryDefinitionChangeEvent(taglibUri, path, type);
        ArrayList<ILibraryDefinitionChangeListener> listenersCopy = new ArrayList<ILibraryDefinitionChangeListener>(listeners);
        for (ILibraryDefinitionChangeListener listener : listenersCopy) {
            listener.libraryChanged(event);
        }
    }
}

