/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.wizard;

import com.ibm.etools.jsf.library.Activator;
import com.ibm.etools.jsf.library.emf.FacesConfigType;
import com.ibm.etools.jsf.library.emf.FacesLibraryFactory;
import com.ibm.etools.jsf.library.emf.LibraryConfigType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.MappingType;
import com.ibm.etools.jsf.library.emf.MappingsType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.emf.TaglibDependencyType;
import com.ibm.etools.jsf.library.emf.WebXmlEditType;
import com.ibm.etools.jsf.library.internal.nls.Messages;
import com.ibm.etools.jsf.library.internal.registry.ProductTaglibRegistry;
import com.ibm.etools.jsf.library.internal.wizard.ImportAdditionalFilesPage;
import com.ibm.etools.jsf.library.internal.wizard.JarAndProjectChooserPage;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.library.util.LibraryUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.LibraryGenerationUtil;
import com.ibm.etools.jsf.util.TextNodeUtil;
import com.ibm.etools.jsf.util.TldEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LibraryWizard
extends Wizard
implements INewWizard,
SelectionListener {
    private static final String LIBRARY_DESCRIPTOR_EDITOR_ID = "com.ibm.etools.jsf.library";
    public static final String PAGE1_NAME = "page1";
    public static final String PAGE2_NAME = "page2";
    private JarAndProjectChooserPage firstPage;
    private ImportAdditionalFilesPage secondPage;
    static int FILESYSTEM = 1;
    static int WORKSPACE = 2;
    static int COMPONENTLIBRARY = 3;
    private int selectFrom = FILESYSTEM;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.firstPage = new JarAndProjectChooserPage(this, PAGE1_NAME);
        this.addPage((IWizardPage)this.firstPage);
        this.firstPage.setPageComplete(false);
        this.setWindowTitle(Messages.LibraryWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageDescriptor("faces_def_wiz"));
        this.firstPage.setTitle(Messages.LibraryWizard_Page1Title);
        this.firstPage.setDescription(Messages.LibraryWizard_Page1Desc);
        this.secondPage = new ImportAdditionalFilesPage(this, PAGE2_NAME);
        this.addPage((IWizardPage)this.secondPage);
        this.secondPage.setPageComplete(true);
        this.secondPage.setTitle(Messages.LibraryWizard_Page2Title);
        this.secondPage.setDescription(Messages.LibraryWizard_Page2Desc);
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete();
    }

    public boolean performFinish() {
        String filePath;
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
        IProgressMonitor monitor = monitorDialog.getProgressMonitor();
        monitorDialog.open();
        monitor.beginTask(Messages.LibraryWizard_CreateLibDef, 100);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.firstPage.getProjectName());
        if (!project.exists()) {
            try {
                monitor.subTask(Messages.LibraryWizard_CreateProject);
                IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.firstPage.getProjectName());
                String[] existingNatures = description.getNatureIds();
                String[] newNatures = new String[existingNatures.length + 1];
                System.arraycopy(existingNatures, 0, newNatures, 0, existingNatures.length);
                newNatures[existingNatures.length] = "com.ibm.etools.jsf.library.FacesLibraryNature";
                description.setNatureIds(newNatures);
                project.create(description, (IProgressMonitor)new NullProgressMonitor());
                project.open(null);
                monitor.worked(5);
            }
            catch (CoreException coreException) {}
        } else if (!LibraryUtil.isLibraryProject(project)) {
            LibraryUtil.addLibraryNature(project);
        }
        Path folderPath = new Path(this.firstPage.getLibraryName());
        String[] segments = folderPath.segments();
        IProject container = project;
        IFolder childContainer = null;
        int i = 0;
        while (i < segments.length) {
            childContainer = container.getFolder((IPath)new Path(segments[i]));
            if (!childContainer.exists()) {
                try {
                    childContainer.create(true, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            container = childContainer;
            ++i;
        }
        monitor.subTask(Messages.LibraryWizard_CopyRes);
        String configFileName = null;
        String libraryName = this.firstPage.getLibraryName();
        configFileName = String.valueOf(libraryName) + "." + "jld";
        IPath configFilePath = new Path(this.firstPage.getLibraryName()).addTrailingSeparator().append(configFileName);
        IResource configFile = LibraryManager.getInstance().createLibraryDefinitionFile(project, configFilePath);
        if (this.selectFrom != COMPONENTLIBRARY) {
            filePath = this.getAbsolutePath(this.firstPage.getJarFilePath());
        } else {
            IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(this.firstPage.getComponentLibraryProject());
            IFolder webContentFolder = (IFolder)ComponentCore.createComponent((IProject)prj).getRootFolder().getUnderlyingFolder();
            String webContentName = webContentFolder.getName();
            filePath = this.getAbsolutePath("/" + this.firstPage.getComponentLibraryProject() + "/" + webContentName + "/" + this.firstPage.getComponentLibraryProject() + ".jar");
        }
        if (filePath != null) {
            this.copyFile(filePath, project);
        }
        int i2 = 0;
        while (i2 < this.secondPage.getFilePaths().length) {
            String filePath0 = this.getAbsolutePath(this.secondPage.getFilePaths()[i2]);
            if (filePath0 != null) {
                this.copyFile(filePath0, project);
            }
            ++i2;
        }
        monitor.worked(5);
        LibraryDefinitionType library = LibraryManager.getInstance().getWritableLibraryDefinitionModel(configFile);
        library.setLabel(this.firstPage.getLibraryName());
        library.setVersion("1.0");
        this.fillResources(library, monitor);
        this.fillPalette(library, monitor);
        if (this.selectFrom == COMPONENTLIBRARY) {
            this.fillComponentLibraryInfo(library, configFile, monitor);
        }
        LibraryManager.getInstance().saveLibraryDefinitionModel(library);
        this.openConfigFile((IFile)configFile);
        monitor.done();
        return true;
    }

    private void fillResources(LibraryDefinitionType library, IProgressMonitor monitor) {
        String filePath;
        monitor.subTask(Messages.LibraryWizard_DefiningApp);
        LibraryConfigType resources = library.getLibraryConfig();
        if (resources == null) {
            resources = FacesLibraryFactory.eINSTANCE.createLibraryConfigType();
            library.setLibraryConfig(resources);
        }
        if (resources.getTaglibDependencies() == null) {
            TaglibDependencyType taglibDeps = FacesLibraryFactory.eINSTANCE.createTaglibDependencyType();
            resources.setTaglibDependencies(taglibDeps);
        }
        if (resources.getFileMappings() == null) {
            MappingsType mappings = FacesLibraryFactory.eINSTANCE.createMappingsType();
            resources.setFileMappings(mappings);
        }
        if (resources.getFacesConfig() == null) {
            FacesConfigType facesConfigEdit = FacesLibraryFactory.eINSTANCE.createFacesConfigType();
            resources.setFacesConfig(facesConfigEdit);
        }
        if (resources.getWebXmlEdit() == null) {
            WebXmlEditType webXmlEdit = FacesLibraryFactory.eINSTANCE.createWebXmlEditType();
            resources.setWebXmlEdit(webXmlEdit);
        }
        IProject componentProject = null;
        if (this.selectFrom == COMPONENTLIBRARY) {
            componentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.firstPage.getComponentLibraryProject());
        }
        if (componentProject != null) {
            if ("1.2".equals(JsfProjectUtil.getJsfFacetVersion(componentProject))) {
                library.setMinJsfLevel("1.2");
            } else {
                library.setMinJsfLevel("1.1");
            }
            String[] installedLibs = ProductTaglibRegistry.getInstance().getInstalledTaglibUris(componentProject);
            int i = 0;
            while (i < installedLibs.length) {
                resources.getTaglibDependencies().getTaglibUri().add((Object)installedLibs[i]);
                ++i;
            }
        } else {
            resources.getTaglibDependencies().getTaglibUri().add((Object)"http://java.sun.com/jsf/core");
            resources.getTaglibDependencies().getTaglibUri().add((Object)"http://java.sun.com/jsf/html");
        }
        if (this.selectFrom != COMPONENTLIBRARY) {
            filePath = this.getAbsolutePath(this.firstPage.getJarFilePath());
            String facesConfigVersion = LibraryGenerationUtil.getJsfVersion((String)filePath);
            library.setMinJsfLevel(facesConfigVersion);
        } else {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.firstPage.getComponentLibraryProject());
            IFolder webContentFolder = (IFolder)ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder();
            String webContentName = webContentFolder.getName();
            filePath = this.getAbsolutePath("/" + this.firstPage.getComponentLibraryProject() + "/" + webContentName + "/" + this.firstPage.getComponentLibraryProject() + ".jar");
        }
        if (filePath == null) {
            return;
        }
        File jarFile = new File(filePath);
        String jarName = jarFile.getName();
        MappingType mapping = FacesLibraryFactory.eINSTANCE.createMappingType();
        mapping.setSourcePath(jarName);
        mapping.setTargetPath("/WEB-INF/lib");
        resources.getFileMappings().getMapping().add((Object)mapping);
        int i = 0;
        while (i < this.secondPage.getFilePaths().length) {
            File jarFile2 = new File(this.secondPage.getFilePaths()[i]);
            String jarName2 = jarFile2.getName();
            MappingType mapping2 = FacesLibraryFactory.eINSTANCE.createMappingType();
            mapping2.setSourcePath(jarName2);
            if (this.secondPage.getFilePaths()[i].endsWith(".jar")) {
                mapping2.setTargetPath("/WEB-INF/lib");
            } else {
                mapping2.setTargetPath("/");
            }
            resources.getFileMappings().getMapping().add((Object)mapping2);
            ++i;
        }
        monitor.worked(1);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillPalette(LibraryDefinitionType library, IProgressMonitor monitor) {
        ZipFile zipFile;
        block49: {
            String filePath;
            InputStream stream;
            block45: {
                block46: {
                    stream = null;
                    zipFile = null;
                    if (this.selectFrom != COMPONENTLIBRARY) {
                        filePath = this.getAbsolutePath(this.firstPage.getJarFilePath());
                    } else {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.firstPage.getComponentLibraryProject());
                        IFolder webContentFolder = (IFolder)ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder();
                        String webContentName = webContentFolder.getName();
                        filePath = this.getAbsolutePath("/" + this.firstPage.getComponentLibraryProject() + "/" + webContentName + "/" + this.firstPage.getComponentLibraryProject() + ".jar");
                    }
                    if (filePath != null) break block45;
                    if (stream == null) break block46;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile == null) return;
                try {
                    zipFile.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            try {
                zipFile = new ZipFile(filePath);
                if (zipFile != null) {
                    ZipEntry entry = zipFile.getEntry(this.firstPage.getTldPath());
                    stream = zipFile.getInputStream(entry);
                    InputSource source = new InputSource("jar:file:///" + filePath + "!/" + this.firstPage.getTldPath());
                    source.setByteStream(stream);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setValidating(false);
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    builder.setEntityResolver((EntityResolver)new TldEntityResolver());
                    Document doc = builder.parse(source);
                    IProject componentProject = null;
                    if (this.selectFrom == COMPONENTLIBRARY) {
                        componentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.firstPage.getComponentLibraryProject());
                    }
                    String[] extraFiles = this.secondPage.getFilePaths();
                    ArrayList<String> extraJars = new ArrayList<String>();
                    int i = 0;
                    while (i < extraFiles.length) {
                        if (extraFiles[i].endsWith(".jar")) {
                            extraJars.add(extraFiles[i]);
                        }
                        ++i;
                    }
                    LibraryUtil.fillTagsFromTLD(library, doc, this.firstPage.getLibraryName(), filePath, extraJars.toArray(new String[0]), componentProject, monitor);
                    library.setTldFile(this.firstPage.getTldPath());
                    TreeWalker walker = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, -1, null, true);
                    boolean foundOne = false;
                    Node cursor = walker.firstChild();
                    while (cursor != null) {
                        if (cursor.getNodeType() == 1) {
                            Node textNode;
                            if (cursor.getNodeName().equalsIgnoreCase("uri") && (textNode = TextNodeUtil.findChildTextNode((Node)cursor)) != null) {
                                String taglibUri = textNode.getNodeValue().trim();
                                library.setTaglibUri(taglibUri);
                                if (foundOne) break;
                                foundOne = true;
                            }
                            if ((cursor.getNodeName().equalsIgnoreCase("shortname") || cursor.getNodeName().equalsIgnoreCase("short-name")) && (textNode = TextNodeUtil.findChildTextNode((Node)cursor)) != null) {
                                String shortName = textNode.getNodeValue().trim();
                                library.setPrefix(shortName);
                                if (foundOne) break;
                                foundOne = true;
                            }
                        }
                        cursor = walker.nextNode();
                    }
                    stream.close();
                }
                zipFile.close();
            }
            catch (IOException iOException) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (zipFile == null) return;
                try {
                    zipFile.close();
                    return;
                }
                catch (IOException iOException3) {}
                return;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                block47: {
                    if (stream == null) break block47;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile == null) return;
                try {
                    zipFile.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (SAXException sAXException) {
                block48: {
                    if (stream == null) break block48;
                    {
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (zipFile == null) throw throwable;
                            try {
                                zipFile.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile == null) return;
                try {
                    zipFile.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            if (stream == null) break block49;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (zipFile == null) return;
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * Exception decompiling
     */
    private void fillComponentLibraryInfo(LibraryDefinitionType library, IResource configFile, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TagType getTag(String tagName, LibraryDefinitionType library) {
        TagLibraryType palette = library.getTagLibrary();
        if (palette != null) {
            for (TagType tag : palette.getTag()) {
                if (!tagName.equals(tag.getName())) continue;
                return tag;
            }
        }
        return null;
    }

    private void openConfigFile(IFile configFile) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
        try {
            page.openEditor((IEditorInput)new FileEditorInput(configFile), LIBRARY_DESCRIPTOR_EDITOR_ID);
        }
        catch (PartInitException pie) {
            pie.printStackTrace();
        }
    }

    private String getAbsolutePath(String filePath) {
        if (this.selectFrom == WORKSPACE || this.selectFrom == COMPONENTLIBRARY) {
            Path source;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (workspaceRoot.exists((IPath)(source = new Path(filePath)))) {
                IResource resource = workspaceRoot.findMember((IPath)source, false);
                if (resource != null) {
                    filePath = resource.getLocation().toOSString();
                }
            } else {
                return null;
            }
        }
        return filePath;
    }

    private void copyFile(String filePath, IProject targetProject) {
        File sourceFile = new File(filePath);
        String fileName = sourceFile.getName();
        IFolder libraryFolder = targetProject.getFolder(this.firstPage.getLibraryName());
        IFile targetFile = libraryFolder.getFile(fileName);
        String targetPath = targetFile.getLocation().toOSString();
        if (filePath.equals(targetPath)) {
            return;
        }
        try {
            FileInputStream sourceStream = new FileInputStream(sourceFile);
            if (!targetFile.exists()) {
                targetFile.create((InputStream)sourceStream, true, null);
            } else {
                targetFile.setContents((InputStream)sourceStream, true, false, null);
            }
            sourceStream.close();
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    protected final void copyTree(File sourceDir, IPath targetPath) {
        try {
            if (sourceDir.exists()) {
                File[] srcFiles = sourceDir.isDirectory() ? sourceDir.listFiles() : new File[]{sourceDir};
                int i = 0;
                while (i < srcFiles.length) {
                    File srcFile = srcFiles[i];
                    if (srcFile.isFile()) {
                        IFile copyFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath.append(srcFile.getName()));
                        FileInputStream sourceStream = new FileInputStream(srcFile);
                        if (!copyFile.exists()) {
                            this.createFolderIfNecessary((IFolder)copyFile.getParent());
                            copyFile.create((InputStream)sourceStream, true, null);
                        } else if (copyFile.getWorkspace().validateEdit(new IFile[]{copyFile}, IWorkspace.VALIDATE_PROMPT).isOK()) {
                            copyFile.setContents((InputStream)sourceStream, true, false, null);
                        }
                        sourceStream.close();
                    } else if (srcFile.isDirectory()) {
                        IFolder packageDirFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(targetPath.append(srcFile.getName()));
                        this.createFolderIfNecessary(packageDirFolder);
                        this.copyTree(srcFile, targetPath.append(srcFile.getName()));
                    }
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
    }

    private void createFolderIfNecessary(IFolder folder) {
        if (!folder.exists()) {
            this.createFolderIfNecessary((IFolder)folder.getParent());
            try {
                folder.create(true, true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public int getSelectFrom() {
        return this.selectFrom;
    }

    public void setSelectFrom(int selectFrom) {
        this.selectFrom = selectFrom;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetDefaultSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.firstPage.getFromCompositePrj() || e.getSource() == this.firstPage.getFromFileSystem() || e.getSource() == this.firstPage.getFromWorkspace()) {
            this.secondPage.updateTable();
        }
    }
}

