/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.wizard;

import com.ibm.etools.jsf.library.Activator;
import com.ibm.etools.jsf.library.internal.nls.Messages;
import com.ibm.etools.jsf.library.internal.wizard.LibraryWizard;
import com.ibm.etools.jsf.library.internal.wizard.TLDFilesDialog;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TextNodeUtil;
import com.ibm.etools.jsf.util.TldEntityResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JarAndProjectChooserPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    private static final String JARFILE_MASK = "*.jar";
    private LibraryWizard wizard;
    private boolean bValidJar = true;
    private Label nameLabel = null;
    private Text nameText = null;
    private Group jarFileGroup;
    private Label fromLabel;
    private Button fromFileSystem;
    private Button fromWorkspace;
    private Button fromCompositePrj;
    private Composite stackedComposite;
    private StackLayout stackLayout;
    private Composite firstStack;
    private Label jarFileLabel = null;
    private Text jarFileText = null;
    private Button jarFileBtn = null;
    private Composite secondStack;
    private Label compLibLabel;
    private Combo compLibCombo;
    private Label projectLabel;
    private Combo projectCombo;
    private String tldPath;

    public JarAndProjectChooserPage(LibraryWizard wizard, String name) {
        super(name);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite subpanel1 = new Composite(parent, 0);
        subpanel1.setLayout(this.createLayout(3, 7, 7, 4, 4));
        this.nameLabel = new Label(subpanel1, 0);
        this.nameLabel.setText(Messages.JSFLibrary_BasicsDialog_Name);
        this.nameText = new Text(subpanel1, 2048);
        this.nameText.addModifyListener((ModifyListener)this);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.nameText.setLayoutData((Object)gridData);
        new Label(subpanel1, 0);
        new Label(subpanel1, 0);
        this.jarFileGroup = new Group(subpanel1, 0);
        this.jarFileGroup.setText(Messages.JSFLibrary_BasicsDialog_JarFileGroup);
        this.jarFileGroup.setLayout(this.createLayout(4, 7, 7, 4, 4));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.jarFileGroup.setLayoutData((Object)gridData);
        this.fromLabel = new Label((Composite)this.jarFileGroup, 0);
        this.fromLabel.setText(Messages.JSFLibrary_BasicsDialog_FromLabel);
        this.fromFileSystem = new Button((Composite)this.jarFileGroup, 16);
        this.fromFileSystem.setText(Messages.JSFLibrary_BasicsDialog_FromFileSystem);
        this.fromFileSystem.addSelectionListener((SelectionListener)this);
        this.fromFileSystem.addSelectionListener((SelectionListener)this.wizard);
        this.fromWorkspace = new Button((Composite)this.jarFileGroup, 16);
        this.fromWorkspace.setText(Messages.JSFLibrary_BasicsDialog_FromWorkspace);
        this.fromWorkspace.addSelectionListener((SelectionListener)this);
        this.fromWorkspace.addSelectionListener((SelectionListener)this.wizard);
        this.fromCompositePrj = new Button((Composite)this.jarFileGroup, 16);
        this.fromCompositePrj.setText(Messages.JSFLibrary_BasicsDialog_FromComponentProject);
        this.fromCompositePrj.addSelectionListener((SelectionListener)this);
        this.fromCompositePrj.addSelectionListener((SelectionListener)this.wizard);
        this.stackedComposite = new Composite((Composite)this.jarFileGroup, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 4;
        this.stackedComposite.setLayoutData((Object)gridData);
        this.stackLayout = new StackLayout();
        this.stackedComposite.setLayout((Layout)this.stackLayout);
        this.firstStack = new Composite(this.stackedComposite, 0);
        this.firstStack.setLayout(this.createLayout(3, 0, 0, 0, 0));
        gridData = new GridData(768);
        this.firstStack.setLayoutData((Object)gridData);
        this.jarFileLabel = new Label(this.firstStack, 0);
        this.jarFileLabel.setText(Messages.JSFLibrary_BasicsDialog_JarFile);
        this.jarFileText = new Text(this.firstStack, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.jarFileText.setLayoutData((Object)gridData);
        this.jarFileText.addModifyListener((ModifyListener)this);
        this.jarFileBtn = new Button(this.firstStack, 8);
        this.jarFileBtn.setToolTipText(Messages.JSFLibrary_BasicsDialog_JarFile_Browse);
        Image image = Activator.getDefault().getImage1("lookup");
        this.jarFileBtn.setImage(image);
        this.jarFileBtn.addSelectionListener((SelectionListener)this);
        this.jarFileBtn.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.JSFLibrary_BasicsDialog_JarFile_Browse;
            }
        });
        this.stackLayout.topControl = this.firstStack;
        this.stackedComposite.layout();
        this.secondStack = new Composite(this.stackedComposite, 0);
        this.secondStack.setLayout(this.createLayout(2, 0, 0, 0, 0));
        gridData = new GridData(768);
        this.secondStack.setLayoutData((Object)gridData);
        this.compLibLabel = new Label(this.secondStack, 0);
        this.compLibLabel.setText(Messages.JSFLibrary_BasicsDialog_CompLib);
        this.compLibCombo = new Combo(this.secondStack, 8);
        gridData = new GridData(768);
        this.compLibCombo.setLayoutData((Object)gridData);
        this.compLibCombo.addSelectionListener((SelectionListener)this);
        this.setupComponentLibrary();
        Label spacer = new Label(subpanel1, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        spacer.setLayoutData((Object)gridData);
        Group projectGroup = new Group(subpanel1, 0);
        projectGroup.setText(Messages.JarAndProjectChooserPage_ChooseProject);
        projectGroup.setLayout(this.createLayout(2, 7, 7, 4, 4));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        projectGroup.setLayoutData((Object)gridData);
        this.projectLabel = new Label((Composite)projectGroup, 0);
        this.projectLabel.setText(Messages.JarAndProjectChooserPage_ProjectLabel);
        this.projectCombo = new Combo((Composite)projectGroup, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.projectCombo.setLayoutData((Object)gridData);
        this.projectCombo.addModifyListener((ModifyListener)this);
        IProject[] projects = LibraryManager.getInstance().getLibraryProjects();
        int i = 0;
        while (i < projects.length) {
            if (!JsfProjectUtil.isCompositeProject((IProject)projects[i])) {
                this.projectCombo.add(projects[i].getName());
            }
            ++i;
        }
        if (this.projectCombo.getItemCount() > 0) {
            this.projectCombo.select(0);
        }
        this.nameText.setFocus();
        this.setControl((Control)subpanel1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)subpanel1, "com.ibm.etools.jsf.library.CreateJLD_Page1");
    }

    private Layout createLayout(int numCols, int vBorder, int hBorder, int vSpacing, int hSpacing) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numCols;
        gridLayout.marginHeight = vBorder;
        gridLayout.marginWidth = hBorder;
        gridLayout.verticalSpacing = vSpacing;
        gridLayout.horizontalSpacing = hSpacing;
        gridLayout.makeColumnsEqualWidth = false;
        return gridLayout;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.jarFileBtn) {
            if (this.fromFileSystem.getSelection()) {
                int lastSeparatorIndex;
                String selectedFile = null;
                FileDialog dialog = new FileDialog(this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{JARFILE_MASK});
                String currentSourceString = this.jarFileText.getText();
                if (currentSourceString != null && currentSourceString.equals("") && (lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator)) != -1) {
                    dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
                }
                if ((selectedFile = dialog.open()) != null) {
                    this.jarFileText.setText(selectedFile);
                }
            } else if (this.fromWorkspace.getSelection()) {
                ViewerFilter filter = this.getContainerDialogViewerFilter();
                WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
                DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                dialog.setTitle(Messages.JSFLibrary_BasicsDialog_Select_Title);
                dialog.setMessage(Messages.JSFLibrary_BasicsDialog_Select_Message);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.addFilter(filter);
                if (dialog.open() == 0) {
                    Object element = dialog.getFirstResult();
                    try {
                        if (element instanceof IFile) {
                            IFile selectedFile = (IFile)element;
                            this.jarFileText.setText(selectedFile.getFullPath().toString());
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (e.getSource() == this.fromFileSystem) {
            if (this.wizard.getSelectFrom() != LibraryWizard.FILESYSTEM) {
                this.wizard.setSelectFrom(LibraryWizard.FILESYSTEM);
                this.stackLayout.topControl = this.firstStack;
                this.stackedComposite.layout();
                this.jarFileText.setText("");
            }
        } else if (e.getSource() == this.fromWorkspace) {
            if (this.wizard.getSelectFrom() != LibraryWizard.WORKSPACE) {
                this.wizard.setSelectFrom(LibraryWizard.WORKSPACE);
                this.stackLayout.topControl = this.firstStack;
                this.stackedComposite.layout();
                this.jarFileText.setText("");
            }
        } else if (e.getSource() == this.fromCompositePrj) {
            if (this.wizard.getSelectFrom() != LibraryWizard.COMPONENTLIBRARY) {
                this.wizard.setSelectFrom(LibraryWizard.COMPONENTLIBRARY);
                this.stackLayout.topControl = this.secondStack;
                this.stackedComposite.layout();
                if (this.compLibCombo.getText() != null && !"".equals(this.compLibCombo.getText())) {
                    this.checkJarAndSelectTld();
                }
            }
        } else if (e.getSource() == this.compLibCombo) {
            this.checkJarAndSelectTld();
        }
        this.checkComplete();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (e.getSource() == this.jarFileText) {
            this.checkJarAndSelectTld();
        } else if (e.getSource() == this.nameText && ((text = this.projectCombo.getText()) == null || this.projectCombo.getSelectionIndex() == -1)) {
            this.projectCombo.setText(this.nameText.getText());
        }
        this.checkComplete();
    }

    private ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IContainer container;
                IProject project;
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return file.getFileExtension() != null && file.getFileExtension().equals("jar");
                }
                return !(element instanceof IProject ? !(project = (IProject)element).isOpen() || JsfProjectUtil.isCompositeProject((IProject)project) : element instanceof IContainer && (container = (IContainer)element).getName() != null && container.getName().startsWith("."));
            }
        };
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkJarAndSelectTld() {
        this.setErrorMessage(null);
        this.bValidJar = true;
        String filename = null;
        if (this.wizard.getSelectFrom() == LibraryWizard.FILESYSTEM) {
            String filePath = this.jarFileText.getText();
            if (filePath != null && !"".equals(filePath)) {
                File file = new File(filePath);
                if (file.exists()) {
                    filename = filePath;
                } else {
                    this.bValidJar = false;
                    this.setErrorMessage(Messages.JarAndProjectChooserPage_ERROR_DONOT_EXIST);
                }
            }
        } else {
            Path source;
            if (this.wizard.getSelectFrom() == LibraryWizard.WORKSPACE) {
                source = new Path(this.jarFileText.getText());
            } else {
                String projectName = this.compLibCombo.getText();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IFolder webContentFolder = (IFolder)ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder();
                String webContentName = webContentFolder.getName();
                source = new Path("/" + projectName + "/" + webContentName + "/" + projectName + ".jar");
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (workspaceRoot.exists((IPath)source)) {
                IResource resource = workspaceRoot.findMember((IPath)source, false);
                if (resource != null) {
                    filename = resource.getLocation().toString();
                }
            } else {
                this.bValidJar = false;
                if (this.wizard.getSelectFrom() == LibraryWizard.COMPONENTLIBRARY) {
                    this.setErrorMessage(Messages.JarAndProjectChooserPage_ERROR_HAVENOT_GENERATED);
                } else {
                    this.setErrorMessage(Messages.JarAndProjectChooserPage_ERROR_DONOT_EXIST);
                }
            }
        }
        if (filename == null) {
            this.bValidJar = false;
            return;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(filename);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            boolean isFacesLibrary = false;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equalsIgnoreCase("META-INF/faces-config.xml")) continue;
                isFacesLibrary = true;
            }
            ArrayList<String> tldList = new ArrayList<String>();
            ArrayList<String> taglibUriList = new ArrayList<String>();
            if (isFacesLibrary) {
                entries = zipFile.entries();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                builder.setEntityResolver((EntityResolver)new TldEntityResolver());
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".tld")) continue;
                    tldList.add(entry.getName());
                    InputStream stream = zipFile.getInputStream(entry);
                    InputSource source = new InputSource("jar:file:///" + filename + "!/" + entry.getName());
                    source.setByteStream(stream);
                    Document doc = builder.parse(source);
                    stream.close();
                    TreeWalker walker = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, -1, null, true);
                    Node cursor = walker.firstChild();
                    String taglibUri = "";
                    while (cursor != null) {
                        Node textNode;
                        if (cursor.getNodeType() == 1 && cursor.getNodeName().equalsIgnoreCase("uri") && (textNode = TextNodeUtil.findChildTextNode((Node)cursor)) != null) {
                            taglibUri = textNode.getNodeValue().trim();
                            break;
                        }
                        cursor = walker.nextNode();
                    }
                    taglibUriList.add(taglibUri);
                }
                if (tldList.size() > 1) {
                    String[] tldFiles = new String[tldList.size()];
                    tldList.toArray(tldFiles);
                    String[] taglibUris = new String[taglibUriList.size()];
                    taglibUriList.toArray(taglibUris);
                    TLDFilesDialog dialog = new TLDFilesDialog(this.getShell(), tldFiles, taglibUris);
                    int retCode = dialog.open();
                    if (retCode == 0) {
                        this.tldPath = dialog.getTLDFile();
                    } else if (retCode == 1) {
                        this.jarFileText.setText("");
                        this.tldPath = null;
                    }
                } else if (tldList.size() == 1) {
                    this.tldPath = (String)tldList.get(0);
                } else {
                    this.tldPath = null;
                    this.bValidJar = false;
                    this.setErrorMessage(Messages.JarAndProjectChooserPage_ERROR_NON_JSF_JAR);
                }
            } else {
                this.bValidJar = false;
                this.setErrorMessage(Messages.JarAndProjectChooserPage_ERROR_NON_JSF_JAR);
            }
        }
        catch (IOException iOException) {
            if (zipFile == null) return;
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException2) {}
            return;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (zipFile == null) return;
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (SAXException sAXException) {
            if (zipFile == null) return;
            {
                catch (Throwable throwable) {
                    if (zipFile == null) throw throwable;
                    try {
                        zipFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                zipFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (zipFile == null) return;
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public String getLibraryName() {
        return this.nameText.getText();
    }

    public String getJarFilePath() {
        return this.jarFileText.getText();
    }

    public String getProjectName() {
        return this.projectCombo.getText();
    }

    public String getTldPath() {
        return this.tldPath;
    }

    private void checkComplete() {
        if (!this.bValidJar) {
            this.setPageComplete(false);
        } else if (this.wizard.getSelectFrom() == LibraryWizard.COMPONENTLIBRARY) {
            if (!(this.getLibraryName() == null || "".equals(this.getLibraryName()) || this.compLibCombo.getText() == null || "".equals(this.compLibCombo.getText()) || this.getProjectName() == null || "".equals(this.getProjectName()) || this.getTldPath() == null || "".equals(this.getTldPath()))) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        } else if (!(this.getLibraryName() == null || "".equals(this.getLibraryName()) || this.getJarFilePath() == null || "".equals(this.getJarFilePath()) || this.getProjectName() == null || "".equals(this.getProjectName()) || this.getTldPath() == null || "".equals(this.getTldPath()) || this.isDuplicateFolder())) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDuplicateFolder() {
        Path folderPath = new Path(this.getLibraryName());
        String[] segments = folderPath.segments();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        if (project == null) {
            return false;
        }
        IFolder childContainer = null;
        int i = 0;
        while (i < segments.length) {
            childContainer = project.getFolder((IPath)new Path(segments[i]));
            if (childContainer.exists()) {
                try {
                    IResource[] members = childContainer.members();
                    int memberCount = 0;
                    while (memberCount < members.length) {
                        IResource member = members[memberCount];
                        if ("jld".equals(member.getFileExtension())) {
                            return true;
                        }
                        ++memberCount;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return false;
    }

    private void setupComponentLibrary() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        int count = 0;
        int i = 0;
        while (i < projects.length) {
            if (JsfProjectUtil.isCompositeProject((IProject)projects[i])) {
                this.compLibCombo.add(projects[i].getName());
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            this.fromCompositePrj.setEnabled(false);
            this.fromFileSystem.setSelection(true);
        } else {
            this.fromCompositePrj.setSelection(true);
            this.wizard.setSelectFrom(LibraryWizard.COMPONENTLIBRARY);
            if (count == 1) {
                this.compLibCombo.select(0);
                this.checkJarAndSelectTld();
            }
            this.stackLayout.topControl = this.secondStack;
            this.stackedComposite.layout();
        }
    }

    public String getComponentLibraryProject() {
        return this.compLibCombo.getText();
    }

    public Button getFromFileSystem() {
        return this.fromFileSystem;
    }

    public Button getFromWorkspace() {
        return this.fromWorkspace;
    }

    public Button getFromCompositePrj() {
        return this.fromCompositePrj;
    }
}

