/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.wizard;

import com.ibm.etools.jsf.library.internal.nls.Messages;
import com.ibm.etools.jsf.library.internal.wizard.LibraryWizard;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ImportAdditionalFilesPage
extends WizardPage
implements SelectionListener {
    private Table table;
    private Button addBtn;
    private Button removeBtn;
    private LibraryWizard wizard;
    private int oldSelectFrom = LibraryWizard.FILESYSTEM;

    public ImportAdditionalFilesPage(LibraryWizard wizard, String name) {
        super(name);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite subpanel1 = new Composite(parent, 0);
        subpanel1.setLayout(this.createLayout(2, 7, 7, 4, 4));
        Label tableLabel = new Label(subpanel1, 0);
        tableLabel.setText(Messages.ImportAdditionalFilesPage_Files);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)gridData);
        this.table = new Table(subpanel1, 2048);
        gridData = new GridData(768);
        gridData.heightHint = 200;
        this.table.setLayoutData((Object)gridData);
        this.table.addSelectionListener((SelectionListener)this);
        Composite subpanel2 = new Composite(subpanel1, 0);
        subpanel2.setLayout(this.createLayout(1, 7, 7, 4, 4));
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        subpanel2.setLayoutData((Object)gridData);
        this.addBtn = new Button(subpanel2, 8);
        this.addBtn.setText(Messages.ImportAdditionalFilesPage_Add);
        this.addBtn.addSelectionListener((SelectionListener)this);
        gridData = new GridData(768);
        this.addBtn.setLayoutData((Object)gridData);
        this.removeBtn = new Button(subpanel2, 8);
        this.removeBtn.setText(Messages.ImportAdditionalFilesPage_Remove);
        this.removeBtn.addSelectionListener((SelectionListener)this);
        gridData = new GridData(768);
        this.removeBtn.setLayoutData((Object)gridData);
        this.setControl((Control)subpanel1);
        this.enableControls();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)subpanel1, "com.ibm.etools.jsf.library.CreateJLD_Page2");
    }

    private Layout createLayout(int numCols, int vBorder, int hBorder, int vSpacing, int hSpacing) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numCols;
        gridLayout.marginHeight = vBorder;
        gridLayout.marginWidth = hBorder;
        gridLayout.verticalSpacing = vSpacing;
        gridLayout.horizontalSpacing = hSpacing;
        gridLayout.makeColumnsEqualWidth = false;
        return gridLayout;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.addBtn) {
            String selectedFile = null;
            if (this.wizard.getSelectFrom() == LibraryWizard.FILESYSTEM) {
                FileDialog dialog = new FileDialog(this.getShell(), 4096);
                selectedFile = dialog.open();
            } else {
                ViewerFilter filter = this.getContainerDialogViewerFilter();
                WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
                DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
                dialog.setTitle(Messages.JSFLibrary_BasicsDialog_SelectFile_Title);
                dialog.setMessage(Messages.JSFLibrary_BasicsDialog_SelectFile_Message);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.addFilter(filter);
                if (dialog.open() == 0) {
                    Object element = dialog.getFirstResult();
                    try {
                        if (element instanceof IFile) {
                            selectedFile = ((IFile)element).getFullPath().toString();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (selectedFile != null) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(selectedFile);
            }
        } else if (e.getSource() == this.removeBtn) {
            this.table.remove(this.table.getSelectionIndices());
        } else if (e.getSource() == this.table) {
            this.enableControls();
        }
    }

    private ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IContainer container;
                IProject project;
                IFile file;
                return !(element instanceof IFile ? (file = (IFile)element).getName().startsWith(".") : (element instanceof IProject ? !(project = (IProject)element).isOpen() : element instanceof IContainer && (container = (IContainer)element).getName() != null && container.getName().startsWith(".")));
            }
        };
    }

    private void enableControls() {
        this.removeBtn.setEnabled(this.table.getSelectionCount() > 0);
    }

    public String[] getFilePaths() {
        TableItem[] items = this.table.getItems();
        String[] strings = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strings[i] = items[i].getText();
            ++i;
        }
        return strings;
    }

    public void updateTable() {
        if (this.wizard.getSelectFrom() == this.oldSelectFrom) {
            return;
        }
        this.table.removeAll();
        this.oldSelectFrom = this.wizard.getSelectFrom();
    }
}

