/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.ui.editor.dialogs;

import com.ibm.etools.jsf.library.internal.ui.editor.dialogs.SelectIconPaletteCategory;
import com.ibm.etools.jsf.library.internal.ui.editor.dialogs.SelectIconPaletteItem;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

class SelectIconPaletteLabelProvider
implements ILabelProvider {
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();
    private boolean bSmallIcon = true;

    public SelectIconPaletteLabelProvider(boolean bSmallIcon) {
        this.bSmallIcon = bSmallIcon;
    }

    private Image getCachedImage(ImageDescriptor descriptor) {
        Image image = this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public Image getImage(Object element) {
        if (element instanceof SelectIconPaletteCategory) {
            URL url;
            if (this.bSmallIcon) {
                SelectIconPaletteCategory category = (SelectIconPaletteCategory)element;
                String bundle = category.getBundle();
                String icon = category.getSmallIcon();
                url = FileLocator.find((Bundle)Platform.getBundle((String)bundle), (IPath)new Path(icon), null);
            } else {
                url = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.library"), (IPath)new Path("icons/empty.gif"), null);
            }
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            return this.getCachedImage(descriptor);
        }
        if (element instanceof SelectIconPaletteItem) {
            SelectIconPaletteItem item = (SelectIconPaletteItem)element;
            String bundle = item.getBundle();
            String icon = this.bSmallIcon ? item.getSmallIcon() : item.getLargeIcon();
            URL url = FileLocator.find((Bundle)Platform.getBundle((String)bundle), (IPath)new Path(icon), null);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
            return this.getCachedImage(descriptor);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof SelectIconPaletteCategory) {
            return ((SelectIconPaletteCategory)element).getLabel();
        }
        if (element instanceof SelectIconPaletteItem) {
            return ((SelectIconPaletteItem)element).getLabel();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Iterator<Image> images = this.imageCache.values().iterator();
        while (images.hasNext()) {
            images.next().dispose();
        }
        this.imageCache = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

