/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.ui.editor.dialogs;

import com.ibm.etools.jsf.library.internal.nls.Messages;
import com.ibm.etools.jsf.library.internal.ui.editor.dialogs.SelectIconPaletteCategory;
import com.ibm.etools.jsf.library.internal.ui.editor.dialogs.SelectIconPaletteItem;
import com.ibm.etools.jsf.library.internal.ui.editor.dialogs.SelectIconPaletteLabelProvider;
import com.ibm.etools.jsf.library.internal.ui.editor.dialogs.SelectIconPaletteTreeProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class SelectIconDialog
extends TrayDialog
implements SelectionListener,
ModifyListener {
    private static final int VERTICAL_MARGIN = 7;
    private static final int VERTICAL_SPACING = 4;
    private static final int HORIZONTAL_MARGIN = 7;
    private static final int HORIZONTAL_SPACING = 4;
    private String filename = null;
    private String otherFilename = null;
    private Composite stackedComposite;
    private Tree imageTable;
    private TreeViewer imageTableViewer;
    private Button pickOtherBtn;
    private StackLayout stackLayout;
    private Composite option1Container;
    private Composite option4Container;
    private boolean bSmallIcon = true;
    private boolean bPickOther = true;
    private List<SelectIconPaletteCategory> categories = new ArrayList<SelectIconPaletteCategory>();

    public SelectIconDialog(Shell shell, IProject project, boolean bSmallIcon, boolean bPickOther) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.bSmallIcon = bSmallIcon;
        this.bPickOther = bPickOther;
    }

    private Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createBaseComposite(parent, 1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setData((Object)gridData);
        this.stackedComposite = new Composite(composite, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.stackedComposite.setLayoutData((Object)gridData);
        this.stackLayout = new StackLayout();
        this.stackedComposite.setLayout((Layout)this.stackLayout);
        this.createFirstStack(this.stackedComposite);
        this.createSecondStack(this.stackedComposite);
        this.createThirdStack(this.stackedComposite);
        this.createFourthStack(this.stackedComposite);
        this.stackLayout.topControl = this.option1Container;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.library.SelectIcon");
        return composite;
    }

    private void createFirstStack(Composite parent) {
        this.option1Container = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.option1Container.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.option1Container.setLayout((Layout)gridLayout);
        Label imageLabel = new Label(this.option1Container, 0);
        imageLabel.setText(Messages.SelectIconDialog_SelectIcon);
        this.imageTable = new Tree(this.option1Container, 2052);
        gridData = new GridData(1296);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.imageTable.setLayoutData((Object)gridData);
        this.imageTable.addSelectionListener((SelectionListener)this);
        this.readRegistry();
        this.imageTableViewer = new TreeViewer(this.imageTable);
        this.imageTableViewer.setContentProvider((IContentProvider)new SelectIconPaletteTreeProvider());
        this.imageTableViewer.setLabelProvider((IBaseLabelProvider)new SelectIconPaletteLabelProvider(this.bSmallIcon));
        this.imageTableViewer.setInput(this.categories);
        this.imageTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof SelectIconPaletteCategory && object2 instanceof SelectIconPaletteCategory) {
                    String str1 = ((SelectIconPaletteCategory)object1).getLabel();
                    String id1 = ((SelectIconPaletteCategory)object1).getId();
                    String str2 = ((SelectIconPaletteCategory)object2).getLabel();
                    String id2 = ((SelectIconPaletteCategory)object2).getId();
                    if (id1.equals("jsf.html.standard")) {
                        return -1;
                    }
                    if (id2.equals("jsf.html.standard")) {
                        return 1;
                    }
                    if (id1.equals("jsf.html")) {
                        return -1;
                    }
                    if (id2.equals("jsf.html")) {
                        return 1;
                    }
                    return str1.compareTo(str2);
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.imageTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (SelectIconDialog.this.getButton(0).isEnabled()) {
                    SelectIconDialog.this.okPressed();
                }
            }
        });
        if (this.bPickOther) {
            this.pickOtherBtn = new Button(this.option1Container, 32);
            this.pickOtherBtn.setSelection(true);
            if (this.bSmallIcon) {
                this.pickOtherBtn.setText(Messages.JSFLibrary_PaletteTab_SelectIconDialog_PickOther2);
            } else {
                this.pickOtherBtn.setText(Messages.JSFLibrary_PaletteTab_SelectIconDialog_PickOther1);
            }
        }
    }

    private void createSecondStack(Composite parent) {
    }

    private void createThirdStack(Composite parent) {
    }

    private void createFourthStack(Composite parent) {
        this.option4Container = new Composite(parent, 0);
        this.option4Container.setLayoutData((Object)new GridData(1808));
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableControls();
        return control;
    }

    public String getFilename() {
        return this.filename;
    }

    protected void okPressed() {
        ISelection selection = this.imageTableViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object selectedObj = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObj instanceof SelectIconPaletteCategory) {
                SelectIconPaletteCategory category = (SelectIconPaletteCategory)selectedObj;
                this.filename = "${" + category.getBundle() + "}/" + category.getSmallIcon();
                this.otherFilename = null;
            } else if (selectedObj instanceof SelectIconPaletteItem) {
                SelectIconPaletteItem item = (SelectIconPaletteItem)selectedObj;
                this.filename = "${" + item.getBundle() + "}/" + (this.bSmallIcon ? item.getSmallIcon() : item.getLargeIcon());
                this.otherFilename = this.bPickOther && this.pickOtherBtn.getSelection() ? "${" + item.getBundle() + "}/" + (this.bSmallIcon ? item.getLargeIcon() : item.getSmallIcon()) : null;
            }
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.JSFLibrary_PaletteTab_SelectIconDialog_Title);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.imageTable) {
            this.enableControls();
        }
    }

    private void enableControls() {
        Object selectedObj;
        boolean bEnableOKBtn = true;
        boolean bEnablePickOtherBtn = true;
        ISelection selection = this.imageTableViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedObj = ((IStructuredSelection)selection).getFirstElement()) instanceof SelectIconPaletteCategory) {
            if (!this.bSmallIcon) {
                bEnableOKBtn = false;
            }
            bEnablePickOtherBtn = false;
        }
        this.getButton(0).setEnabled(bEnableOKBtn);
        if (this.bPickOther) {
            this.pickOtherBtn.setVisible(bEnablePickOtherBtn);
        }
    }

    private void readRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("com.ibm.etools.webedit.palette", "PageDesignerPaletteContributions");
        if (point != null) {
            String label;
            String bundle;
            String name;
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                name = elements[i].getName();
                bundle = elements[i].getContributor().getName();
                if (name.equals("category")) {
                    label = elements[i].getAttribute("label");
                    String icon = elements[i].getAttribute("icon");
                    String id = elements[i].getAttribute("id");
                    this.categories.add(new SelectIconPaletteCategory(bundle, id, label, icon));
                }
                ++i;
            }
            i = 0;
            while (i < elements.length) {
                name = elements[i].getName();
                bundle = elements[i].getContributor().getName();
                if (name.equals("item")) {
                    label = elements[i].getAttribute("label");
                    String smallIcon = elements[i].getAttribute("iconSmall");
                    String largeIcon = elements[i].getAttribute("iconLarge");
                    String category = elements[i].getAttribute("category");
                    SelectIconPaletteItem item = new SelectIconPaletteItem(bundle, label, smallIcon, largeIcon);
                    int j = 0;
                    while (j < this.categories.size()) {
                        if (category != null && category.equals(this.categories.get(j).getId())) {
                            this.categories.get(j).addPaletteItem(item);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    public String getOtherFilename() {
        return this.otherFilename;
    }
}

