/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.ui.editor.dialogs;

import com.ibm.etools.jsf.library.internal.nls.Messages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class PathSelectionDialog
extends ElementTreeSelectionDialog
implements SelectionListener,
ISelectionChangedListener,
ModifyListener {
    private Label createNewLbl = null;
    private Text createNewText = null;
    private Button createNewButton = null;

    public PathSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        panel.setLayoutData((Object)layoutData);
        this.createNewLbl = new Label(panel, 0);
        this.createNewLbl.setText(Messages.JSFLibrary_PathSelectionDialog_Label);
        this.createNewText = new Text(panel, 2048);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.createNewText.setLayoutData((Object)layoutData);
        this.createNewText.addModifyListener((ModifyListener)this);
        this.createNewButton = new Button(panel, 0);
        this.createNewButton.setText(Messages.JSFLibrary_PathSelectionDialog_Button);
        this.createNewButton.addSelectionListener((SelectionListener)this);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.setAllowMultiple(false);
        this.enableControls();
        return composite;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetDefaultSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.createNewButton) {
            TreeItem item = this.getTreeViewer().getTree().getSelection()[0];
            Object data = item.getData();
            IPath folderPath = null;
            if (data instanceof IProject) {
                folderPath = ((IProject)data).getFullPath();
            } else if (data instanceof IFolder) {
                folderPath = ((IFolder)data).getFullPath();
            }
            if (folderPath != null) {
                folderPath = folderPath.append(this.createNewText.getText());
                IFolder newFolderHandle = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(folderPath);
                try {
                    newFolderHandle.create(false, true, null);
                    this.createNewText.setText("");
                    this.enableControls();
                }
                catch (CoreException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSource() == this.getTreeViewer()) {
            this.enableControls();
        }
    }

    private void enableControls() {
        ISelection selection = this.getTreeViewer().getSelection();
        if (selection == null || selection == TreeSelection.EMPTY || selection.isEmpty()) {
            this.createNewButton.setEnabled(false);
            this.createNewLbl.setEnabled(false);
            this.createNewText.setEnabled(false);
        } else {
            this.createNewLbl.setEnabled(true);
            this.createNewText.setEnabled(true);
            if (this.createNewText.getText() == null || this.createNewText.getText().equals("")) {
                this.createNewButton.setEnabled(false);
            } else {
                this.createNewButton.setEnabled(true);
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.createNewText) {
            this.enableControls();
        }
    }
}

