/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.ui.editor;

import com.ibm.etools.jsf.library.internal.nls.Messages;
import com.ibm.etools.jsf.library.internal.ui.editor.dialogs.ExtendedElementTreeSelectionDialog;
import com.ibm.xwt.dde.customization.IAdvancedCustomizationObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SelectJsIncludeCustomization
implements IAdvancedCustomizationObject {
    private IProject project = null;

    public String invoke(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        IFile file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
        this.project = file.getProject();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ExtendedElementTreeSelectionDialog dialog = new ExtendedElementTreeSelectionDialog(editorPart.getSite().getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider, new String[]{"*.js", "*.*"});
        dialog.setTitle(Messages.JSFLibrary_AddJsInclude_SelectJs_Title);
        dialog.setMessage(Messages.JSFLibrary_AddJsInclude_SelectJs_Message);
        dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(filter);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                if (element instanceof IFile) {
                    IFile file2 = (IFile)element;
                    String fullPath = file2.getFullPath().toString();
                    return fullPath.substring(this.project.getName().length() + 2);
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IContainer container;
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    if (file.getName().startsWith(".")) {
                        return false;
                    }
                    return file.getFileExtension() != null && file.getFileExtension().equals("js");
                }
                if (element instanceof IProject) {
                    return element.equals(SelectJsIncludeCustomization.this.project);
                }
                return !(element instanceof IContainer) || (container = (IContainer)element).getName() == null || !container.getName().startsWith(".");
            }
        };
    }
}

