/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.registry;

import com.ibm.etools.jsf.library.extension.ITaglibUriProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ProductTaglibRegistry {
    private static ProductTaglibRegistry registry = null;
    private List<String> productTaglibUris = new ArrayList<String>();
    private ITaglibUriProvider provider = null;

    private ProductTaglibRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint taglibExtPoint = extensionRegistry.getExtensionPoint("com.ibm.etools.jsf.library.taglibUriProvider");
        if (taglibExtPoint != null) {
            IConfigurationElement[] elements = taglibExtPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String className = elements[i].getAttribute("class");
                Class provClass = null;
                try {
                    String pluginID = elements[i].getDeclaringExtension().getNamespaceIdentifier();
                    Bundle plugin = Platform.getBundle((String)pluginID);
                    provClass = plugin.loadClass(className);
                    if (provClass != null && ITaglibUriProvider.class.isAssignableFrom(provClass)) {
                        ITaglibUriProvider tlProvider;
                        this.provider = tlProvider = (ITaglibUriProvider)provClass.newInstance();
                        List<String> list = tlProvider.getJsfTaglibUris();
                        int uris = 0;
                        while (uris < list.size()) {
                            String uri = list.get(uris);
                            if (!this.productTaglibUris.contains(uri)) {
                                this.productTaglibUris.add(uri);
                            }
                            ++uris;
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
                ++i;
            }
        }
    }

    public static synchronized ProductTaglibRegistry getInstance() {
        if (registry == null) {
            registry = new ProductTaglibRegistry();
        }
        return registry;
    }

    public List<String> getProductTaglibUris() {
        return Collections.unmodifiableList(this.productTaglibUris);
    }

    public String[] getInstalledTaglibUris(IProject project) {
        if (this.provider != null && project != null) {
            return this.provider.getInstalledJsfTaglibUris(project);
        }
        return null;
    }
}

