/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class EditorCustomizationRegistry {
    private static EditorCustomizationRegistry registry;
    private Map<String, Object> idToDelegateMap = new HashMap<String, Object>();

    private EditorCustomizationRegistry() {
        this.load();
    }

    public static synchronized EditorCustomizationRegistry getInstance() {
        if (registry == null) {
            registry = new EditorCustomizationRegistry();
        }
        return registry;
    }

    private void load() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extensionRegistry.getExtensionPoint("com.ibm.etools.jsf.library.editorCustomizationDelegate");
        if (extPoint != null) {
            IConfigurationElement[] elements = extPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String className = elements[i].getAttribute("class");
                Class provClass = null;
                try {
                    String pluginID = elements[i].getDeclaringExtension().getNamespaceIdentifier();
                    Bundle plugin = Platform.getBundle((String)pluginID);
                    provClass = plugin.loadClass(className);
                    if (provClass != null) {
                        Object delegate = provClass.newInstance();
                        String id = elements[i].getAttribute("id");
                        if (id != null) {
                            this.idToDelegateMap.put(id, delegate);
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
                ++i;
            }
        }
    }

    public Object getDelegate(String id) {
        return this.idToDelegateMap.get(id);
    }
}

