/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.palette;

import com.ibm.etools.jsf.library.emf.DropAttributeType;
import com.ibm.etools.jsf.library.emf.LibraryDefinitionType;
import com.ibm.etools.jsf.library.emf.PaletteVisibilityType;
import com.ibm.etools.jsf.library.emf.TagLibraryType;
import com.ibm.etools.jsf.library.emf.TagType;
import com.ibm.etools.jsf.library.emf.TagTypeType;
import com.ibm.etools.jsf.library.util.LibraryManager;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteContextData;
import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.palette.PaletteProvider;
import com.ibm.etools.webedit.palette.customize.PaletteLibraryProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.osgi.framework.Bundle;

public class LibraryPaletteProvider
implements PaletteProvider {
    private static final String COMPONENT_DROP_ACTION_CLASS = "com.ibm.etools.jsf.palette.actions.JsfDropAction";
    private static final String NON_COMPONENT_DROP_ACTION_CLASS = "com.ibm.etools.jsf.palette.actions.NonUIComponentDropAction";
    private static final String BUNDLE_NAME = "com.ibm.etools.jsf";
    private static final String BASE_CONTEXT = "BaseFaces";
    private static final String ENHANCED_CONTEXT = "EnhancedFaces";
    private static final String TRUE = "true";
    private static final URL DEFAULT_CATEGORY_ICON = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.library"), (IPath)new Path("icons/jsfcmpdrawer_pal.gif"), null);
    private static final URL DEFAULT_TAG_SMALL_ICON = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.library"), (IPath)new Path("icons/jsf_cmp_pal_16.gif"), null);
    private static final URL DEFAULT_TAG_LARGE_ICON = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.library"), (IPath)new Path("icons/jsf_cmp_pal_24.gif"), null);

    public PaletteData[] providePaletteItems() {
        ArrayList<Object> listOfPaletteItems = new ArrayList<Object>();
        PaletteLibraryProvider paletteLibraryProvider = PaletteLibraryProvider.getInstance();
        String[] taglibUris = LibraryManager.getInstance().getLibraryTaglibUris();
        String compositeTaglib = null;
        IProject project = JsfProjectUtil.getProject();
        if (project != null && JsfProjectUtil.isCompositeProject((IProject)project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            Properties props = component.getMetaProperties();
            compositeTaglib = props.getProperty("JSFComposite.TAGLIB_URI");
        }
        int i = 0;
        while (i < taglibUris.length) {
            LibraryDefinitionType lib = LibraryManager.getInstance().getLibraryDefinitionModel(taglibUris[i]);
            if (lib != null && this.checkValidJsfVersion(lib)) {
                TagLibraryType category;
                String taglibUri = lib.getTaglibUri();
                if (!(compositeTaglib != null && compositeTaglib.equals(taglibUri) || (category = lib.getTagLibrary()) == null || lib.getTaglibUri() == null)) {
                    PaletteCategoryData newCategory = paletteLibraryProvider.createCategoryData();
                    newCategory.setLabel(category.getLabel());
                    newCategory.setDescription(category.getDescription());
                    newCategory.setId(taglibUri);
                    if (category.getIcon() != null && !"".equals(category.getIcon())) {
                        URL url = this.getIconUrl(category.getIcon());
                        if (url != null) {
                            newCategory.setSmallIcon(url);
                        } else {
                            newCategory.setSmallIcon(DEFAULT_CATEGORY_ICON);
                        }
                    } else {
                        newCategory.setSmallIcon(DEFAULT_CATEGORY_ICON);
                    }
                    newCategory.setVisible(false);
                    newCategory.setInitiallyOpen(category.isInitiallyOpened());
                    newCategory.setInitiallyPinned(category.isInitiallyPinned());
                    PaletteContextData baseContext = new PaletteContextData();
                    baseContext.setContextId(BASE_CONTEXT);
                    if (category.isVisible()) {
                        baseContext.setVisible(TRUE);
                    }
                    PaletteContextData enhancedContext = new PaletteContextData();
                    enhancedContext.setContextId(ENHANCED_CONTEXT);
                    if (category.isVisible()) {
                        enhancedContext.setVisible(TRUE);
                    }
                    ArrayList<PaletteContextData> contexts = new ArrayList<PaletteContextData>();
                    contexts.add(baseContext);
                    contexts.add(enhancedContext);
                    newCategory.setApplicableContexts(contexts);
                    listOfPaletteItems.add(newCategory);
                    EList<TagType> tags = category.getTag();
                    int tagIndex = 0;
                    while (tagIndex < tags.size()) {
                        TagType tagDef = (TagType)tags.get(tagIndex);
                        if (!PaletteVisibilityType.ABSENT.equals((Object)tagDef.getPaletteVisibility())) {
                            URL url;
                            PaletteItemData newTag = paletteLibraryProvider.createItemData();
                            if (tagDef.getLabel() != null && !"".equals(tagDef.getLabel())) {
                                newTag.setLabel(tagDef.getLabel());
                            } else {
                                newTag.setLabel(tagDef.getName());
                            }
                            newTag.setId(String.valueOf(taglibUri) + tagDef.getName());
                            newTag.setDescription(tagDef.getDescription());
                            if (tagDef.getSmallIcon() != null && !"".equals(tagDef.getSmallIcon())) {
                                url = this.getIconUrl(tagDef.getSmallIcon());
                                if (url != null) {
                                    newTag.setSmallIcon(url);
                                } else {
                                    newTag.setSmallIcon(DEFAULT_TAG_SMALL_ICON);
                                }
                            } else {
                                newTag.setSmallIcon(DEFAULT_TAG_SMALL_ICON);
                            }
                            if (tagDef.getLargeIcon() != null && !"".equals(tagDef.getLargeIcon())) {
                                url = this.getIconUrl(tagDef.getLargeIcon());
                                if (url != null) {
                                    newTag.setLargeIcon(url);
                                } else {
                                    newTag.setLargeIcon(DEFAULT_TAG_LARGE_ICON);
                                }
                            } else {
                                newTag.setLargeIcon(DEFAULT_TAG_LARGE_ICON);
                            }
                            newTag.setTagName(tagDef.getName());
                            if (tagDef.getDropInfo() != null) {
                                for (DropAttributeType attr : tagDef.getDropInfo().getInitAttribute()) {
                                    newTag.addTagAttribute(attr.getName(), attr.getValue());
                                }
                            }
                            newTag.setTagAttributesEditable(true);
                            newTag.setCategory(newCategory);
                            newTag.setTaglibUri(taglibUri);
                            newTag.addAttribute("bundle", BUNDLE_NAME);
                            if (TagTypeType.UICOMPONENT == tagDef.getDropInfo().getTagType()) {
                                newTag.addAttribute("actionclass", COMPONENT_DROP_ACTION_CLASS);
                            } else {
                                newTag.addAttribute("actionclass", NON_COMPONENT_DROP_ACTION_CLASS);
                            }
                            String tagPrefix = lib.getPrefix();
                            if (tagPrefix != null && !"".equals(tagPrefix)) {
                                newTag.addProperty("preferredprefix", tagPrefix);
                            }
                            if (PaletteVisibilityType.VISIBLE.equals((Object)tagDef.getPaletteVisibility())) {
                                newTag.setVisible(true);
                            } else if (PaletteVisibilityType.HIDDEN.equals((Object)tagDef.getPaletteVisibility())) {
                                newTag.setVisible(false);
                            }
                            listOfPaletteItems.add(newTag);
                        }
                        ++tagIndex;
                    }
                }
            }
            ++i;
        }
        PaletteData[] arrayOfPaletteItems = listOfPaletteItems.toArray(new PaletteData[0]);
        return arrayOfPaletteItems;
    }

    private URL getIconUrl(String icon) {
        int index;
        if (icon.startsWith("${") && (index = icon.indexOf("}/")) > 0) {
            String bundleStr = icon.substring(2, index);
            String pathName = icon.substring(index + 2);
            Bundle bundle = Platform.getBundle((String)bundleStr);
            if (bundle != null) {
                return FileLocator.find((Bundle)bundle, (IPath)new Path(pathName), null);
            }
        }
        return null;
    }

    private boolean checkValidJsfVersion(LibraryDefinitionType lib) {
        IProject project;
        String minJsf = lib.getMinJsfLevel();
        return !"1.2".equals(minJsf) || (project = JsfProjectUtil.getProject()) == null || "1.2".equals(JsfProjectUtil.getJsfFacetVersion((IProject)project));
    }
}

