/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.util;

import com.ibm.etools.jsf.facesconfig.util.AddOrModifyJ2EEContextParamRunnable;
import com.ibm.etools.jsf.facesconfig.util.AddOrModifyJEEContextParamRunnable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class JSFFacesConfigUtil {
    public static final String FACES_CONFIG_CONTENT_TYPE_ID = "com.ibm.etools.jsf.facesconfig.facesConfigFile";
    private static final String RI_PLUGIN = "com.ibm.etools.jsf.ri";
    private static final String TEMPLATE_PATH = "/template/faces-config.xml";
    private static final String TEMPLATE_PATH_JSF12 = "/template/faces-config-12.xml";
    private static final String DEFAULT_FACES_CONFIG_PATH = "/WEB-INF/faces-config.xml";
    private static final String CONFIG_FILES_NAME = "javax.faces.CONFIG_FILES";
    private static final String CONFIG_FILES_DESC = "Comma-delimited list of context-relative resource paths under which the JSF implementation\nwill look for application configuration resources, before loading a configuration resource\nnamed /WEB-INF/facesconfig.xml (if such a resource exists).";
    protected static WeakHashMap projectToFacesConfigsMap = new WeakHashMap();

    public static boolean isFacesConfigFile(IFile file) {
        return JSFFacesConfigUtil.isFacesConfigFile(file, true);
    }

    public static boolean isFacesConfigFile(IFile file, boolean ignoreNonFacesProject) {
        IPath filePath;
        IProject project = file.getProject();
        if (project == null) {
            return false;
        }
        if (!JSFFacesConfigUtil.isFacesProject(project)) {
            return false;
        }
        MapItem item = (MapItem)projectToFacesConfigsMap.get(project);
        if (item == null) {
            IPath prefix;
            IVirtualFolder rootFolder;
            String[] pathsArray = JSFFacesConfigUtil.getFacesConfigPaths(project);
            ArrayList<String> paths = new ArrayList<String>();
            int i = 0;
            while (i < pathsArray.length) {
                paths.add(pathsArray[i]);
                ++i;
            }
            item = new MapItem();
            item.facesConfigPaths = paths;
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            if (component != null && (rootFolder = component.getRootFolder()) != null && (prefix = rootFolder.getProjectRelativePath()) != null) {
                item.initialPathSegments = prefix.segmentCount();
            }
            projectToFacesConfigsMap.put(project, item);
        }
        if ((filePath = file.getProjectRelativePath()) != null) {
            String path = filePath.removeFirstSegments(item.initialPathSegments).toString();
            String pathWithSlash = filePath.removeFirstSegments(item.initialPathSegments).makeAbsolute().toString();
            if (item.facesConfigPaths.contains(path) || item.facesConfigPaths.contains(pathWithSlash)) {
                return true;
            }
        }
        return false;
    }

    public static String[] getFacesConfigPaths(IProject project) {
        ArrayList<String> facesConfigPaths = new ArrayList<String>();
        String configFiles = JSFFacesConfigUtil.getFacesConfigContextParamValue(project);
        if (configFiles != null) {
            StringTokenizer tokenizer = new StringTokenizer(configFiles, ",");
            while (tokenizer.hasMoreTokens()) {
                String filePathStr = tokenizer.nextToken();
                if (filePathStr == null || facesConfigPaths.contains(filePathStr = filePathStr.trim())) continue;
                facesConfigPaths.add(filePathStr);
            }
        }
        if (!facesConfigPaths.contains(DEFAULT_FACES_CONFIG_PATH)) {
            facesConfigPaths.add(DEFAULT_FACES_CONFIG_PATH);
        }
        return facesConfigPaths.toArray(new String[0]);
    }

    public static String getFacesConfigContextParamValue(IProject project) {
        block9: {
            Object webAppObj;
            block8: {
                if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
                    return null;
                }
                IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
                if (provider == null) {
                    return null;
                }
                webAppObj = provider.getModelObject();
                if (webAppObj == null) {
                    return null;
                }
                if (!(webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp)) break block8;
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                if (webApp.getJ2EEVersionID() >= 14) {
                    for (ParamValue parm : webApp.getContextParams()) {
                        if (!CONFIG_FILES_NAME.equals(parm.getName())) continue;
                        return parm.getValue();
                    }
                } else {
                    for (ContextParam parm : webApp.getContexts()) {
                        if (!CONFIG_FILES_NAME.equals(parm.getParamName())) continue;
                        return parm.getParamValue();
                    }
                }
                break block9;
            }
            if (!(webAppObj instanceof WebApp)) break block9;
            WebApp webApp = (WebApp)webAppObj;
            for (org.eclipse.jst.javaee.core.ParamValue parm : webApp.getContextParams()) {
                if (!CONFIG_FILES_NAME.equals(parm.getParamName())) continue;
                return parm.getParamValue();
            }
        }
        return null;
    }

    public static void createFacesConfigFile(IProject project, String path) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IContainer webContentFolder = component.getRootFolder().getUnderlyingFolder();
        IFile newFacesConfigFile = webContentFolder.getFile((IPath)new Path(path));
        if (newFacesConfigFile.exists()) {
            String[] paths = JSFFacesConfigUtil.getFacesConfigPaths(project);
            int i = 0;
            while (i < paths.length) {
                if (paths[i].equals(path)) {
                    return;
                }
                ++i;
            }
        } else {
            try {
                String sourcePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)RI_PLUGIN), (IPath)new Path(JSFFacesConfigUtil.getFacesConfigTemplatePath(project)), null)).getPath().toString();
                File f = new File(sourcePath);
                FileInputStream sourceStream = new FileInputStream(f);
                JSFFacesConfigUtil.createFolderIfNecessary((IFolder)newFacesConfigFile.getParent());
                newFacesConfigFile.create((InputStream)sourceStream, true, null);
                sourceStream.close();
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        String param = JSFFacesConfigUtil.getFacesConfigContextParamValue(project);
        param = param == null ? path : String.valueOf(param) + ", " + path;
        if (!J2EEProjectUtilities.isJEEProject((IProject)project) && !J2EEProjectUtilities.isLegacyJ2EEProject((IProject)project)) {
            return;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            return;
        }
        if (provider.validateEdit(null, webAppObj).isOK()) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                provider.modify((Runnable)new AddOrModifyJ2EEContextParamRunnable((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj, CONFIG_FILES_NAME, CONFIG_FILES_DESC, param, true), null);
            } else if (webAppObj instanceof WebApp) {
                provider.modify((Runnable)new AddOrModifyJEEContextParamRunnable((WebApp)webAppObj, CONFIG_FILES_NAME, CONFIG_FILES_DESC, param, true), null);
            }
        }
    }

    private static String getFacesConfigTemplatePath(IProject project) {
        boolean isJsf12 = false;
        try {
            IProjectFacet jsfFacet;
            IProjectFacetVersion jsfVersion;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (ProjectFacetsManager.isProjectFacetDefined((String)"jst.jsf") && (jsfVersion = facetedProject.getInstalledVersion(jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf"))) != null && "1.2".equals(jsfVersion.getVersionString())) {
                isJsf12 = true;
            }
        }
        catch (CoreException coreException) {}
        if (!isJsf12) {
            return TEMPLATE_PATH;
        }
        return TEMPLATE_PATH_JSF12;
    }

    private static void createFolderIfNecessary(IFolder folder) {
        if (!folder.exists()) {
            JSFFacesConfigUtil.createFolderIfNecessary((IFolder)folder.getParent());
            try {
                folder.create(true, true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    static boolean isFacesProject(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)"jsf.base")) {
                IProjectFacet jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jsf.base");
                return facetedProject.hasProjectFacet(jsfFacet);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    static class MapItem {
        List facesConfigPaths;
        int initialPathSegments;

        MapItem() {
        }
    }
}

