/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.scheme.internal;

import com.ibm.etools.jsf.facesconfig.scheme.internal.ContributedArtifact;
import com.ibm.etools.jsf.facesconfig.scheme.internal.ContributedScheme;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SchemeRegistryReader {
    private static final String ID_ATT = "id";
    private static final String NAME_ATT = "name";
    private static final String DESCRIPTION_ATT = "description";
    private static final String ENABLEMENT_ATT = "enablement";
    private static final String ARTIFACT_ATT = "artifact";
    public static final String SCHEME_CLASS_ATT = "class";
    private static final String EXPLICIT_FILE_PATH_ATT = "explicitFilePath";

    public static List parseArtifactContributions() {
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint artifactExtPoint = extRegistry.getExtensionPoint("com.ibm.etools.jsf.facesconfig.FacesConfigArtifact");
        IExtension[] artifactExtension = artifactExtPoint.getExtensions();
        ArrayList<ContributedArtifact> contributions = new ArrayList<ContributedArtifact>();
        int i = 0;
        while (i < artifactExtension.length) {
            IExtension currentExtension = artifactExtension[i];
            if (currentExtension.isValid()) {
                IConfigurationElement[] elements = currentExtension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String description;
                    String name;
                    IConfigurationElement currentMigrateElement = elements[j];
                    ContributedArtifact artifact = new ContributedArtifact();
                    String id = currentMigrateElement.getAttribute(ID_ATT);
                    if (id != null && !id.equals("")) {
                        artifact.setId(id);
                    }
                    if ((name = currentMigrateElement.getAttribute(NAME_ATT)) != null && !name.equals("")) {
                        artifact.setName(name);
                    }
                    if ((description = currentMigrateElement.getAttribute(DESCRIPTION_ATT)) != null && !description.equals("")) {
                        artifact.setDescription(description);
                    }
                    contributions.add(artifact);
                    ++j;
                }
            }
            ++i;
        }
        return contributions;
    }

    public static Map parseSchemeContributions() {
        HashMap<String, ContributedScheme> schemes = new HashMap<String, ContributedScheme>(4);
        IExtensionRegistry extRegistry = Platform.getExtensionRegistry();
        IExtensionPoint schemeExtPoint = extRegistry.getExtensionPoint("com.ibm.etools.jsf.facesconfig.FacesConfigScheme");
        IExtension[] migrationExtensions = schemeExtPoint.getExtensions();
        int i = 0;
        while (i < migrationExtensions.length) {
            IExtension currentExtension = migrationExtensions[i];
            if (currentExtension.isValid()) {
                IConfigurationElement[] elements = currentExtension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String explicitFilePath;
                    String description;
                    ContributedScheme currentScheme = new ContributedScheme();
                    IConfigurationElement currentSchemeElement = elements[j];
                    String id = currentSchemeElement.getAttribute(ID_ATT);
                    currentScheme.setId(id);
                    String name = currentSchemeElement.getAttribute(NAME_ATT);
                    if (name != null && !name.equals("")) {
                        currentScheme.setName(name);
                    }
                    if ((description = currentSchemeElement.getAttribute(DESCRIPTION_ATT)) != null && !description.equals("")) {
                        currentScheme.setDescription(description);
                    }
                    if ((explicitFilePath = currentSchemeElement.getAttribute(EXPLICIT_FILE_PATH_ATT)) != null && explicitFilePath.equals("true")) {
                        currentScheme.setHasExplicitFilePath(true);
                    }
                    currentScheme.setSchemeClassElement(currentSchemeElement);
                    IConfigurationElement[] enablement = currentSchemeElement.getChildren(ENABLEMENT_ATT);
                    int k = 0;
                    while (k < enablement.length) {
                        IConfigurationElement enablementElement = enablement[k];
                        IConfigurationElement[] artifacts = enablementElement.getChildren(ARTIFACT_ATT);
                        String[] artifactStrings = new String[artifacts.length];
                        int z = 0;
                        while (z < artifacts.length) {
                            String artifactId;
                            IConfigurationElement artifactElement = artifacts[z];
                            artifactStrings[z] = artifactId = artifactElement.getAttribute(ID_ATT);
                            ++z;
                        }
                        currentScheme.setEnabledForArtifacts(artifactStrings);
                        ++k;
                    }
                    schemes.put(id, currentScheme);
                    ++j;
                }
            }
            ++i;
        }
        return schemes;
    }
}

