/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.scheme.internal;

import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SchemePropertyViewerFilter
extends ViewerFilter {
    private IPath workspaceRelativePath;

    public SchemePropertyViewerFilter(IVirtualComponent component) {
        this.workspaceRelativePath = component.getRootFolder().getWorkspaceRelativePath();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean ret = false;
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            ret = this.isConfigFile(file);
        } else if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            try {
                IResource[] resources = container.members();
                int i = 0;
                while (i < resources.length) {
                    ret = this.select(viewer, parentElement, resources[i]);
                    if (!ret) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
        } else {
            ret = true;
        }
        return ret;
    }

    private boolean isConfigFile(IFile file) {
        String[] configFilePaths = JSFFacesConfigUtil.getFacesConfigPaths(file.getProject());
        int i = 0;
        while (i < configFilePaths.length) {
            try {
                if (this.workspaceRelativePath.append(configFilePaths[i]).toString().equals(file.getFullPath().toString())) {
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

