/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.scheme.internal;

import com.ibm.etools.common.ui.presentation.FilteredFileSelectionDialog;
import com.ibm.etools.jsf.facesconfig.FacesConfigPlugin;
import com.ibm.etools.jsf.facesconfig.internal.nls.Messages;
import com.ibm.etools.jsf.facesconfig.scheme.internal.ContributedArtifact;
import com.ibm.etools.jsf.facesconfig.scheme.internal.ContributedScheme;
import com.ibm.etools.jsf.facesconfig.scheme.internal.SchemePropertyViewerFilter;
import com.ibm.etools.jsf.facesconfig.scheme.internal.SchemeRegistryReader;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class SchemePropertyPage
extends PropertyPage
implements SelectionListener,
Listener {
    public static final String JSF_SCHEME_PREF_PREFIX_ID = "jsf.standard.scheme.";
    public static final String JSF_SCHEME_PREF_DEFAULT = "singleFile";
    public static final String JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID = ".filePath";
    public static final String JSF_SCHEME_PREF_FILE_PATH_DEFAULT = "/WEB-INF/faces-config.xml";
    static final String CONTEXT_HELP_ID = "com.ibm.etools.jsf.facesconfig.jsfscheme0010";
    private List artifacts;
    private Collection schemes;
    private Combo[] schemeCombos;
    private Text[] schemeFileTexts;
    private Label[] schemeFileTextLabels;
    private Button[] schemeFileBrowserButtons;
    private IVirtualComponent component;

    private static Composite createGridComposite(Composite parent, int numColumns, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, boolean noMargin) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (noMargin) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private static void setHorizontalIndent(Control control, int horizontalIndent) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).horizontalIndent = horizontalIndent;
            } else {
                GridData gridData = new GridData();
                gridData.horizontalIndent = horizontalIndent;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    public static void initializeDefaultPrefs(IVirtualComponent component, List artifacts) {
        Properties properties = component.getMetaProperties();
        int size = artifacts.size();
        int i = 0;
        while (i < size) {
            ContributedArtifact artifact = (ContributedArtifact)artifacts.get(i);
            properties.setProperty(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId(), FacesConfigPlugin.getPlugin().getPreferenceStore().getString(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId()));
            String filePath = FacesConfigPlugin.getPlugin().getPreferenceStore().getString(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID);
            if (filePath != null) {
                properties.setProperty(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID, FacesConfigPlugin.getPlugin().getPreferenceStore().getString(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID));
            }
            ++i;
        }
        component.setMetaProperties(properties);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), CONTEXT_HELP_ID);
        this.component = this.getComponent();
        this.artifacts = SchemeRegistryReader.parseArtifactContributions();
        this.schemes = SchemeRegistryReader.parseSchemeContributions().values();
        this.schemeCombos = new Combo[this.artifacts.size()];
        this.schemeFileTexts = new Text[this.artifacts.size()];
        this.schemeFileTextLabels = new Label[this.artifacts.size()];
        this.schemeFileBrowserButtons = new Button[this.artifacts.size()];
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 16384);
        label.setText(Messages.SchemePropertyPage_Scheme_Description);
        GridData dataLayout = new GridData();
        dataLayout.heightHint = 20;
        label.setLayoutData((Object)dataLayout);
        int size = this.artifacts.size();
        int i = 0;
        while (i < size) {
            ContributedArtifact artifact = (ContributedArtifact)this.artifacts.get(i);
            label = new Label(composite, 16384);
            label.setText(artifact.getName());
            Composite schemeComposite = SchemePropertyPage.createGridComposite(composite, 2, false, false, false);
            GridLayout schemeLayout = new GridLayout();
            schemeLayout.numColumns = 2;
            schemeLayout.marginHeight = 0;
            schemeLayout.horizontalSpacing = 0;
            schemeLayout.verticalSpacing = 3;
            schemeLayout.marginHeight = 0;
            schemeLayout.marginWidth = 0;
            schemeComposite.setLayout((Layout)schemeLayout);
            SchemePropertyPage.setHorizontalIndent((Control)schemeComposite, 20);
            label = new Label(schemeComposite, 16384);
            label.setText(Messages.SchemePropertyPage_Scheme);
            this.schemeCombos[i] = new Combo(schemeComposite, 12);
            GridData data = new GridData();
            data.horizontalSpan = 1;
            data.widthHint = 300;
            this.schemeCombos[i].setLayoutData((Object)data);
            this.schemeCombos[i].addSelectionListener((SelectionListener)this);
            this.populateList(this.schemeCombos[i], artifact.getId());
            this.schemeFileTextLabels[i] = new Label(schemeComposite, 16384);
            this.schemeFileTextLabels[i].setText(Messages.SchemePropertyPage_File);
            Composite schemeFileTextComponent = SchemePropertyPage.createGridComposite(schemeComposite, 2, false, false, false);
            schemeLayout = new GridLayout(768, false);
            schemeLayout.numColumns = 2;
            schemeLayout.marginHeight = 0;
            schemeLayout.horizontalSpacing = 0;
            schemeLayout.verticalSpacing = 3;
            schemeLayout.marginHeight = 0;
            schemeLayout.marginWidth = 0;
            schemeFileTextComponent.setLayout((Layout)schemeLayout);
            this.schemeFileTexts[i] = new Text(schemeFileTextComponent, 18432);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.schemeFileTexts[i].setLayoutData((Object)data);
            this.schemeFileBrowserButtons[i] = new Button(schemeFileTextComponent, 8);
            data = new GridData();
            data.horizontalSpan = 1;
            this.schemeFileBrowserButtons[i].setText("...");
            this.schemeFileBrowserButtons[i].getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (e.childID == -1) {
                        e.result = Messages.SchemePropertyPage_Choose_File_Ttile;
                    }
                }
            });
            this.schemeFileBrowserButtons[i].setLayoutData((Object)data);
            this.schemeFileBrowserButtons[i].addListener(13, (Listener)this);
            this.updateFilePath(i);
            ++i;
        }
        return composite;
    }

    private void updateFilePath(int artifactIndex) {
        ContributedScheme scheme = this.getSchemeByName(this.schemeCombos[artifactIndex].getText());
        if (scheme != null) {
            if (scheme.getHasExplicitFilePath()) {
                String filePath = this.component.getMetaProperties().getProperty(JSF_SCHEME_PREF_PREFIX_ID + ((ContributedArtifact)this.artifacts.get(artifactIndex)).getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID);
                if (filePath != null) {
                    this.schemeFileTexts[artifactIndex].setText(filePath);
                } else {
                    this.schemeFileTexts[artifactIndex].setText("");
                }
                this.schemeFileTexts[artifactIndex].setEnabled(true);
                this.schemeFileTextLabels[artifactIndex].setEnabled(true);
                this.schemeFileBrowserButtons[artifactIndex].setEnabled(true);
            } else {
                this.schemeFileTexts[artifactIndex].setText("");
                this.schemeFileTexts[artifactIndex].setEnabled(false);
                this.schemeFileTextLabels[artifactIndex].setEnabled(false);
                this.schemeFileBrowserButtons[artifactIndex].setEnabled(false);
            }
        }
    }

    private void populateList(Combo comboList, String artifactID) {
        String storedScheme = this.component.getMetaProperties().getProperty(JSF_SCHEME_PREF_PREFIX_ID + artifactID);
        if (storedScheme == null) {
            SchemePropertyPage.initializeDefaultPrefs(this.component, this.artifacts);
            storedScheme = this.component.getMetaProperties().getProperty(JSF_SCHEME_PREF_PREFIX_ID + artifactID);
        }
        block0: for (ContributedScheme scheme : this.schemes) {
            String[] enabledArtifacts = scheme.getEnabledForArtifacts();
            int i = 0;
            while (i < enabledArtifacts.length) {
                if (artifactID.equals(enabledArtifacts[i])) {
                    comboList.add(scheme.getName());
                    if (storedScheme == null || !scheme.getId().equals(storedScheme)) continue block0;
                    comboList.select(comboList.getItemCount() - 1);
                    continue block0;
                }
                ++i;
            }
        }
    }

    private IVirtualComponent getComponent() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return ComponentCore.createComponent((IProject)project);
        }
        return null;
    }

    public boolean performOk() {
        Properties properties = this.component.getMetaProperties();
        int size = this.artifacts.size();
        int i = 0;
        while (i < size) {
            ContributedArtifact artifact = (ContributedArtifact)this.artifacts.get(i);
            ContributedScheme scheme = this.getSchemeByName(this.schemeCombos[i].getText());
            if (scheme != null) {
                properties.setProperty(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId(), scheme.getId());
                if (scheme.getHasExplicitFilePath()) {
                    properties.setProperty(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID, this.schemeFileTexts[i].getText());
                }
            }
            ++i;
        }
        this.component.setMetaProperties(properties);
        return super.performOk();
    }

    private String handleBrowseButton() {
        Object[] o;
        IVirtualFolder folder;
        String file = null;
        FilteredFileSelectionDialog dialog = new FilteredFileSelectionDialog(this.getShell(), Messages.SchemePropertyPage_Choose_File_Ttile, Messages.SchemePropertyPage_Choose_File_Description, new String[]{"xml"}, false);
        IProject rootFolder = null;
        IVirtualComponent comp = this.getComponent();
        if (comp != null && (folder = comp.getRootFolder()) != null) {
            rootFolder = folder.getUnderlyingFolder();
        }
        if (rootFolder == null) {
            rootFolder = this.getComponent().getProject();
        }
        dialog.setInput(rootFolder);
        SchemePropertyViewerFilter viewerFilter = new SchemePropertyViewerFilter(this.getComponent());
        dialog.addFilter((ViewerFilter)viewerFilter);
        if (dialog.open() == 0 && (o = dialog.getResult()) != null) {
            IFile inputFile = (IFile)o[0];
            file = SchemePropertyPage.getWebAppRelativePath(this.getComponent(), inputFile.getLocation()).toString();
        }
        return file;
    }

    private static final IPath getWebAppRelativePath(IVirtualComponent comp, IPath filePath) {
        IPath webModuleRootLocationPath = comp.getRootFolder().getUnderlyingFolder().getLocation();
        int matchCount = filePath.matchingFirstSegments(webModuleRootLocationPath);
        IPath suffixPath = filePath.removeFirstSegments(matchCount);
        IPath basePath = webModuleRootLocationPath.removeFirstSegments(matchCount);
        int numOfDots = basePath.segmentCount();
        Path webModuleRootRelativePath = new Path("/");
        int i = 1;
        while (i <= numOfDots - 1) {
            webModuleRootRelativePath = webModuleRootRelativePath.append("../");
            ++i;
        }
        webModuleRootRelativePath = webModuleRootRelativePath.append(suffixPath);
        return webModuleRootRelativePath;
    }

    protected void performDefaults() {
        super.performDefaults();
        Properties properties = this.component.getMetaProperties();
        int size = this.artifacts.size();
        int i = 0;
        while (i < size) {
            ContributedArtifact artifact = (ContributedArtifact)this.artifacts.get(i);
            ContributedScheme scheme = this.getSchemeByName(this.schemeCombos[i].getText());
            if (scheme != null) {
                properties.setProperty(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId(), FacesConfigPlugin.getPlugin().getPreferenceStore().getString(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId()));
                if (scheme.getHasExplicitFilePath()) {
                    properties.setProperty(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID, FacesConfigPlugin.getPlugin().getPreferenceStore().getString(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID));
                }
                this.populateList(this.schemeCombos[i], artifact.getId());
                this.updateFilePath(i);
            }
            ++i;
        }
        this.component.setMetaProperties(properties);
    }

    private ContributedScheme getSchemeByName(String schemeName) {
        for (ContributedScheme scheme : this.schemes) {
            if (!schemeName.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int i = 0;
        while (i < this.schemeCombos.length) {
            if (e.getSource() == this.schemeCombos[i]) {
                this.updateFilePath(i);
                break;
            }
            ++i;
        }
    }

    public void handleEvent(Event e) {
        int i = 0;
        while (i < this.schemeFileBrowserButtons.length) {
            if (e.widget == this.schemeFileBrowserButtons[i]) {
                String file = this.handleBrowseButton();
                if (file == null) break;
                this.schemeFileTexts[i].setText(file);
                break;
            }
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }
}

