/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.scheme.internal;

import com.ibm.etools.jsf.facesconfig.FacesConfigPlugin;
import com.ibm.etools.jsf.facesconfig.internal.nls.Messages;
import com.ibm.etools.jsf.facesconfig.scheme.internal.ContributedArtifact;
import com.ibm.etools.jsf.facesconfig.scheme.internal.ContributedScheme;
import com.ibm.etools.jsf.facesconfig.scheme.internal.SchemeRegistryReader;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SchemePreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    public static final String JSF_SCHEME_PREF_PREFIX_ID = "jsf.standard.scheme.";
    public static final String JSF_SCHEME_PREF_DEFAULT = "singleFile";
    public static final String JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID = ".filePath";
    public static final String JSF_SCHEME_PREF_FILE_PATH_DEFAULT = "/WEB-INF/faces-config.xml";
    private List artifacts;
    private Collection schemes;
    private Combo[] schemeCombos;
    private Text[] schemeFileTexts;
    private Label[] schemeFileTextLabels;

    private static Composite createGridComposite(Composite parent, int numColumns, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, boolean noMargin) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        if (noMargin) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private static void setHorizontalIndent(Control control, int horizontalIndent) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData != null && layoutData instanceof GridData) {
                ((GridData)layoutData).horizontalIndent = horizontalIndent;
            } else {
                GridData gridData = new GridData();
                gridData.horizontalIndent = horizontalIndent;
                control.setLayoutData((Object)gridData);
            }
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.etools.jsf.facesconfig.jsfscheme0010");
        this.artifacts = SchemeRegistryReader.parseArtifactContributions();
        this.schemes = SchemeRegistryReader.parseSchemeContributions().values();
        this.schemeCombos = new Combo[this.artifacts.size()];
        this.schemeFileTexts = new Text[this.artifacts.size()];
        this.schemeFileTextLabels = new Label[this.artifacts.size()];
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 16384);
        label.setText(Messages.SchemePropertyPage_Scheme_Description_Global);
        GridData dataLayout = new GridData();
        dataLayout.heightHint = 20;
        label.setLayoutData((Object)dataLayout);
        int size = this.artifacts.size();
        int i = 0;
        while (i < size) {
            ContributedArtifact artifact = (ContributedArtifact)this.artifacts.get(i);
            label = new Label(composite, 16384);
            label.setText(artifact.getName());
            Composite renamingFilesComponent = SchemePreferencesPage.createGridComposite(composite, 2, false, false, false);
            GridLayout renamingFilesLayout = new GridLayout();
            renamingFilesLayout.numColumns = 2;
            renamingFilesLayout.marginHeight = 0;
            renamingFilesLayout.horizontalSpacing = 0;
            renamingFilesLayout.verticalSpacing = 3;
            renamingFilesLayout.marginHeight = 0;
            renamingFilesLayout.marginWidth = 0;
            renamingFilesComponent.setLayout((Layout)renamingFilesLayout);
            SchemePreferencesPage.setHorizontalIndent((Control)renamingFilesComponent, 20);
            label = new Label(renamingFilesComponent, 16384);
            label.setText(Messages.SchemePropertyPage_Scheme);
            this.schemeCombos[i] = new Combo(renamingFilesComponent, 12);
            GridData data = new GridData();
            data.horizontalSpan = 1;
            data.widthHint = 300;
            this.schemeCombos[i].setLayoutData((Object)data);
            this.schemeCombos[i].addSelectionListener((SelectionListener)this);
            this.populateList(this.schemeCombos[i], artifact.getId());
            this.schemeFileTextLabels[i] = new Label(renamingFilesComponent, 16384);
            this.schemeFileTextLabels[i].setText(Messages.SchemePropertyPage_File);
            this.schemeFileTexts[i] = new Text(renamingFilesComponent, 18432);
            data = new GridData();
            data.horizontalSpan = 1;
            data.widthHint = 316;
            this.schemeFileTexts[i].setLayoutData((Object)data);
            this.updateFilePath(i);
            ++i;
        }
        return composite;
    }

    private void updateFilePath(int artifactIndex) {
        ContributedScheme scheme = this.getSchemeByName(this.schemeCombos[artifactIndex].getText());
        if (scheme != null) {
            if (scheme.getHasExplicitFilePath()) {
                String filePath = FacesConfigPlugin.getPlugin().getPreferenceStore().getString(JSF_SCHEME_PREF_PREFIX_ID + ((ContributedArtifact)this.artifacts.get(artifactIndex)).getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID);
                if (filePath != null) {
                    this.schemeFileTexts[artifactIndex].setText(filePath);
                } else {
                    this.schemeFileTexts[artifactIndex].setText("");
                }
                this.schemeFileTexts[artifactIndex].setEnabled(true);
                this.schemeFileTextLabels[artifactIndex].setEnabled(true);
            } else {
                this.schemeFileTexts[artifactIndex].setText("");
                this.schemeFileTexts[artifactIndex].setEnabled(false);
                this.schemeFileTextLabels[artifactIndex].setEnabled(false);
            }
        }
    }

    private void populateList(Combo comboList, String artifactID) {
        String storedScheme = FacesConfigPlugin.getPlugin().getPreferenceStore().getString(JSF_SCHEME_PREF_PREFIX_ID + artifactID);
        block0: for (ContributedScheme scheme : this.schemes) {
            String[] enabledArtifacts = scheme.getEnabledForArtifacts();
            int i = 0;
            while (i < enabledArtifacts.length) {
                if (artifactID.equals(enabledArtifacts[i])) {
                    comboList.add(scheme.getName());
                    if (storedScheme == null || !scheme.getId().equals(storedScheme)) continue block0;
                    comboList.select(comboList.getItemCount() - 1);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public boolean performOk() {
        int size = this.artifacts.size();
        int i = 0;
        while (i < size) {
            ContributedArtifact artifact = (ContributedArtifact)this.artifacts.get(i);
            ContributedScheme scheme = this.getSchemeByName(this.schemeCombos[i].getText());
            if (scheme != null) {
                FacesConfigPlugin.getPlugin().getPreferenceStore().setValue(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId(), scheme.getId());
                if (scheme.getHasExplicitFilePath()) {
                    FacesConfigPlugin.getPlugin().getPreferenceStore().setValue(JSF_SCHEME_PREF_PREFIX_ID + artifact.getId() + JSF_SCHEME_FILE_PATH_PREF_SUFFIX_ID, this.schemeFileTexts[i].getText());
                }
            }
            ++i;
        }
        return super.performOk();
    }

    private ContributedScheme getSchemeByName(String schemeName) {
        for (ContributedScheme scheme : this.schemes) {
            if (!schemeName.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int i = 0;
        while (i < this.schemeCombos.length) {
            if (e.getSource() == this.schemeCombos[i]) {
                this.updateFilePath(i);
                break;
            }
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }
}

