/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.server.outofideprojectdeletion;

import com.ibm.etools.j2ee.J2eePlugin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.DeletedModule;

public final class ServerRefreshOnRefactoringListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    HashMap projectsToRefresh = new HashMap();

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() == 4) {
                this.cacheDeletedProjectMetadata((IProject)event.getResource());
            } else {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException e) {
            J2eePlugin.logError(e);
        }
    }

    private synchronized void cacheDeletedProjectMetadata(IProject project) {
        ProjectRefactorMetadata metadata = new ProjectRefactorMetadata(project, ProjectRefactorMetadata.REFERER_CACHING);
        metadata.computeMetadata();
        metadata.computeServers();
        this.projectsToRefresh.put(project.getName(), metadata);
    }

    private void updateServerRefs(final ProjectRefactorMetadata refactorMetadata) {
        WorkspaceJob job = new WorkspaceJob("ServerRefreshJob"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IModule moduleToRemove = refactorMetadata.getModule();
                if (moduleToRemove == null) {
                    return Status.OK_STATUS;
                }
                IModule[] toUpdate = new IModule[]{new DeletedModule(moduleToRemove.getId(), moduleToRemove.getName(), moduleToRemove.getModuleType())};
                IServer[] affectedServers = refactorMetadata.getServers();
                IServerWorkingCopy wc = null;
                int i = 0;
                while (i < affectedServers.length) {
                    block17: {
                        try {
                            try {
                                wc = affectedServers[i].createWorkingCopy();
                                List<IModule> list = Arrays.asList(affectedServers[i].getModules());
                                if (list.contains(moduleToRemove)) {
                                    ServerUtil.modifyModules((IServerWorkingCopy)wc, null, (IModule[])toUpdate, null);
                                }
                            }
                            catch (CoreException ce) {
                                J2eePlugin.logError(ce);
                                try {
                                    if (wc != null) {
                                        wc.saveAll(true, null);
                                    }
                                    break block17;
                                }
                                catch (CoreException ce2) {
                                    J2eePlugin.logError(ce2);
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (wc != null) {
                                    wc.saveAll(true, null);
                                }
                            }
                            catch (CoreException ce) {
                                J2eePlugin.logError(ce);
                            }
                            throw throwable;
                        }
                        try {
                            if (wc != null) {
                                wc.saveAll(true, null);
                            }
                        }
                        catch (CoreException ce) {
                            J2eePlugin.logError(ce);
                        }
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "org.eclipse.jst.j2ee.refactor.project".equals(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                int kind = delta.getKind();
                int flags = delta.getFlags();
                if (kind != 2 || !this.hasDeletedRemovedFlags(flags)) break;
                this.updateServerRefs((ProjectRefactorMetadata)this.projectsToRefresh.remove(((IProject)resource).getName()));
            }
        }
        return false;
    }

    private boolean hasDeletedRemovedFlags(int flags) {
        return (flags & 0x2000) == 0 && (flags & 0x40000) == 0;
    }
}

