/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.ltk.core.change;

import com.ibm.etools.javaee.ltk.core.nls.RefactoringResourceHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class NonEARModuleReferenceRemoveChange
extends Change {
    IProject referencingModuleProject = null;
    VirtualComponent referencingModuleProjectComp = null;
    IProject projectToRemove = null;
    IVirtualComponent projectToRemoveComp = null;
    IVirtualReference[] cachedRefs = null;

    public NonEARModuleReferenceRemoveChange(IProject referencingEARProject, IProject projectToRemove) {
        this.referencingModuleProject = referencingEARProject;
        this.projectToRemove = projectToRemove;
        this.referencingModuleProjectComp = (VirtualComponent)ComponentCore.createComponent((IProject)referencingEARProject);
        this.cachedRefs = this.referencingModuleProjectComp.getReferences();
        this.projectToRemoveComp = ComponentCore.createComponent((IProject)projectToRemove);
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        String name = NLS.bind((String)RefactoringResourceHandler.Remove_JavaEE_References, (Object[])new Object[]{this.projectToRemove.getName()});
        name = String.valueOf(name) + this.referencingModuleProject.getName();
        return name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            this.removeModuleDependency();
            if (this.isEJBClientDeletion()) {
                this.updateEJBDDWithEJBClientDeletion();
            }
        }
        catch (java.util.concurrent.ExecutionException e) {
            J2EEPlugin.logError((Throwable)e);
        }
        return null;
    }

    public ChangeDescriptor getDescriptor() {
        return null;
    }

    private boolean isEJBClientDeletion() {
        if (!JavaEEProjectUtilities.isEJBProject((IProject)this.referencingModuleProject)) {
            return false;
        }
        Properties props = this.referencingModuleProjectComp.getMetaProperties();
        String clientCompName = props.getProperty("ClientProject");
        if (clientCompName == null || clientCompName.length() == 0) {
            return false;
        }
        return clientCompName.equals(this.projectToRemove.getName());
    }

    private void updateEJBDDWithEJBClientDeletion() {
        IModelProvider ejbModel = ModelProviderManager.getModelProvider((IProject)this.referencingModuleProject);
        ejbModel.modify(new Runnable(){

            @Override
            public void run() {
                EJBJar ejbres;
                IModelProvider writableEjbModel = ModelProviderManager.getModelProvider((IProject)NonEARModuleReferenceRemoveChange.this.referencingModuleProject);
                Object modelObject = writableEjbModel.getModelObject();
                if (modelObject instanceof EJBJar) {
                    ejbres = (EJBJar)writableEjbModel.getModelObject();
                    if (ejbres != null) {
                        ejbres.setEjbClientJar(null);
                    }
                } else {
                    ejbres = (org.eclipse.jst.j2ee.ejb.EJBJar)writableEjbModel.getModelObject();
                    ejbres.setEjbClientJar(null);
                }
                Properties props = NonEARModuleReferenceRemoveChange.this.referencingModuleProjectComp.getMetaProperties();
                props.remove("ClientJARURI");
                props.remove("ClientProject");
                NonEARModuleReferenceRemoveChange.this.referencingModuleProjectComp.clearMetaProperties();
                NonEARModuleReferenceRemoveChange.this.referencingModuleProjectComp.setMetaProperties(props);
            }
        }, null);
    }

    protected void removeModuleDependency() throws java.util.concurrent.ExecutionException {
        IVirtualComponent refactoredComp = this.projectToRemoveComp;
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (refactoredComp != null) {
            this.removeReferencedComponents((IProgressMonitor)monitor);
        }
        this.updateManifestDependency(true);
    }

    protected void updateManifestDependency(boolean remove) throws java.util.concurrent.ExecutionException {
        VirtualComponent dependentComp = this.referencingModuleProjectComp;
        IProject project = dependentComp.getProject();
        if (project.isAccessible()) {
            String dependentProjName = this.referencingModuleProject.getName();
            String refactoredProjName = this.projectToRemove.getName();
            IVirtualFile vf = dependentComp.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            IFile manifestmf = vf.getUnderlyingFile();
            if (!manifestmf.exists()) {
                return;
            }
            NullProgressMonitor monitor = new NullProgressMonitor();
            IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
            updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)dependentProjName);
            updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
            updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
            ArchiveManifest manifest = J2EEProjectUtilities.readManifest((IFile)manifestmf);
            String[] cp = manifest.getClassPathTokenized();
            ArrayList<String> cpList = new ArrayList<String>();
            String newjarCp = String.valueOf(refactoredProjName) + ".jar";
            String newrarCp = String.valueOf(refactoredProjName) + ".rar";
            int i = 0;
            while (i < cp.length) {
                if (!cp[i].equals(newjarCp) && !cp[i].equals(newrarCp)) {
                    cpList.add(cp[i]);
                }
                ++i;
            }
            updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
            try {
                updateManifestDataModel.getDefaultOperation().execute((IProgressMonitor)monitor, null);
            }
            catch (ExecutionException e) {
                J2EEPlugin.logError((Throwable)e);
            }
        }
    }

    protected void removeReferencedComponents(IProgressMonitor monitor) {
        if (this.referencingModuleProjectComp == null || !this.referencingModuleProjectComp.getProject().isAccessible() || this.referencingModuleProjectComp.isBinary()) {
            return;
        }
        IVirtualReference[] existingReferencesArray = this.cachedRefs;
        if (existingReferencesArray == null || existingReferencesArray.length == 0) {
            return;
        }
        ArrayList<IVirtualReference> existingReferences = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < existingReferencesArray.length) {
            existingReferences.add(existingReferencesArray[i]);
            ++i;
        }
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        if (this.projectToRemoveComp == null) {
            return;
        }
        IVirtualReference ref = this.findMatchingReference(existingReferences, this.projectToRemoveComp, null);
        if (ref != null) {
            this.removeRefereneceInComponent((IVirtualComponent)this.referencingModuleProjectComp, ref);
            existingReferences.remove(ref);
            ref = this.findMatchingReference(existingReferences, this.projectToRemoveComp);
            if (ref == null) {
                IProject targetProject = this.projectToRemoveComp.getProject();
                targetprojectList.add(targetProject);
            }
        }
        try {
            ProjectUtilities.removeReferenceProjects((IProject)this.referencingModuleProjectComp.getProject(), targetprojectList);
        }
        catch (CoreException e) {
            J2EEPlugin.logError((CoreException)e);
        }
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp) {
        return this.findMatchingReference(existingReferences, comp, null);
    }

    protected void removeRefereneceInComponent(IVirtualComponent component, IVirtualReference reference) {
        ((VirtualComponent)component.getComponent()).removeReference(reference);
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp, IPath path) {
        int i = 0;
        while (i < existingReferences.size()) {
            IVirtualReference ref = (IVirtualReference)existingReferences.get(i);
            IVirtualComponent c = ref.getReferencedComponent();
            if (c != null && c.getName().equals(comp.getName())) {
                if (path == null) {
                    return ref;
                }
                if (path.equals((Object)ref.getRuntimePath())) {
                    return ref;
                }
            }
            ++i;
        }
        return null;
    }

    protected IVirtualReference hadReference() {
        IVirtualComponent refactoredComp = this.projectToRemoveComp;
        if (refactoredComp == null) {
            return null;
        }
        IVirtualReference[] refs = this.cachedRefs;
        IVirtualReference ref = null;
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getReferencedComponent().equals(refactoredComp)) {
                ref = refs[i];
                break;
            }
            ++i;
        }
        return ref;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hadProjectReference() {
        try {
            IProject[] refs = this.referencingModuleProject.getDescription().getReferencedProjects();
            IProject refactoredProject = this.projectToRemove;
            int i = 0;
            while (true) {
                if (i >= refs.length) {
                    return false;
                }
                if (refs[i].equals((Object)refactoredProject)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            J2EEPlugin.logError((CoreException)ce);
        }
        return false;
    }

    protected static boolean hasWebLibDependency(IVirtualReference ref) {
        if (ref == null) {
            return false;
        }
        return ref.getRuntimePath().equals((Object)new Path("/WEB-INF/lib"));
    }
}

