/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.webservice.operation;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.webservice.operation.AddWebServiceHandlerOperation;
import com.ibm.etools.j2ee.internal.webservice.operation.WebServiceMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddWebServiceHandlerDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String SERVICE_REF = "AddWebServiceHandlerOperationDataModel.SERVICE_REF";
    public static final String DISPLAY_NAME = "AddWebServiceHandlerOperationDataModel.DISPLAY_NAME";
    public static final String DESCRIPTION = "AddWebServiceHandlerOperationDataModel.DESCRIPTION";
    public static final String HANDLER_NAME = "AddWebServiceHandlerOperationDataModel.HANDLER_NAME";
    public static final String HANDLER_CLASS_NAME = "AddWebServiceHandlerOperationDataModel.HANDLER_CLASS_NAME";

    @Override
    public WTPOperation getDefaultOperation() {
        return new AddWebServiceHandlerOperation(this);
    }

    @Override
    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SERVICE_REF);
        this.addValidBaseProperty(DISPLAY_NAME);
        this.addValidBaseProperty(DESCRIPTION);
        this.addValidBaseProperty(HANDLER_NAME);
        this.addValidBaseProperty(HANDLER_CLASS_NAME);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(HANDLER_NAME)) {
            return this.validateParameterName(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateParameterName(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebServiceMessages.getResourceString("ERR_HANDLER_DISPLAY_NAME_EMPTY", new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        ServiceRef serviceRef = (ServiceRef)this.getProperty(SERVICE_REF);
        EList handlers = serviceRef.getHandlers();
        boolean exists = false;
        if (handlers != null) {
            int size = handlers.size();
            int i = 0;
            while (i < size) {
                String parName = ((Handler)handlers.get(i)).getHandlerName();
                if (name.equals(parName)) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        if (exists) {
            String msg = WebServiceMessages.getResourceString("ERR_HANDLER_DISPLAY_NAME_EXIST", new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

