/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.webservice.operation;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.webservice.operation.AddHandlerSOAPHeaderOperation;
import com.ibm.etools.j2ee.internal.webservice.operation.WebServiceMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wscommon.SOAPHeader;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddHandlerSOAPHeaderDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String HANDLER = "AddHandlerSOAPHeaderDataModel.HANDLER";
    public static final String NAMESPACE_URL = "AddHandlerSOAPHeaderDataModel.NAMESPACE_URL";
    public static final String LOCAL_PART = "AddHandlerSOAPHeaderDataModel.LOCAL_PART";

    @Override
    public WTPOperation getDefaultOperation() {
        return new AddHandlerSOAPHeaderOperation(this);
    }

    @Override
    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(NAMESPACE_URL);
        this.addValidBaseProperty(LOCAL_PART);
        this.addValidBaseProperty(HANDLER);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(NAMESPACE_URL)) {
            return this.validateNamespaceURL(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateNamespaceURL(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebServiceMessages.getResourceString("ERR_HANDLER_NAMESPACE_URL_EMPTY", new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        Handler handler = (Handler)this.getProperty(HANDLER);
        EList headers = handler.getSoapHeaders();
        int i = 0;
        while (i < headers.size()) {
            Object header = headers.get(i);
            String namespaceURL = null;
            if (header instanceof SOAPHeader) {
                namespaceURL = ((SOAPHeader)header).getNamespaceURI();
            } else if (header instanceof QName) {
                namespaceURL = ((QName)header).getNamespaceURI();
            }
            if (namespaceURL != null && namespaceURL.equals(name)) {
                return WTPCommonPlugin.createErrorStatus((String)"ERR_HANDLER_NAMESPACE_URL_EXISTS");
            }
            ++i;
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public int getVersionID() {
        return J2EEVersionUtil.convertVersionStringToInt((IVirtualComponent)this.getComponent());
    }
}

