/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.project;

import com.ibm.etools.j2ee.internal.project.J2EENature;
import com.ibm.etools.j2ee.internal.project.J2EEWorkbenchURIConverterImpl;
import com.ibm.etools.j2ee.internal.project.ZipFileEntryInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResouceFactorySaxRegistry;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.AppClient12ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.EjbJar11ImportStrategyImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;

public class J2EEModuleWorkbenchURIConverterImpl
extends J2EEWorkbenchURIConverterImpl {
    protected IPath inputJARLocation;
    protected IPath inputJARProjectRelativePath;

    public J2EEModuleWorkbenchURIConverterImpl(J2EENature aNature, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        super(aNature, aSynchronizer);
    }

    @Override
    protected void initialize() {
        this.recomputeInputsIfNecessary();
        super.initialize();
    }

    protected ArchiveTypeDiscriminator getArchiveDiscriminator() {
        if (this.nature.getNatureID().equals("org.eclipse.jst.j2ee.ejb.EJBNature")) {
            return EjbJar11ImportStrategyImpl.getDiscriminator();
        }
        if (this.nature.getNatureID().equals("org.eclipse.jst.j2ee.ApplicationClientNature")) {
            return AppClient12ImportStrategyImpl.getDiscriminator();
        }
        return null;
    }

    protected boolean isJ2EEArchive(IResource resource) {
        String uri = resource.getLocation().toOSString();
        ArchiveTypeDiscriminator disc = this.getArchiveDiscriminator();
        if (disc == null) {
            return false;
        }
        Archive anArchive = null;
        try {
            anArchive = this.getArchiveFactory().primOpenArchive(uri);
            boolean bl = disc.canImport(anArchive);
            return bl;
        }
        catch (OpenFailureException openFailureException) {
            return false;
        }
        finally {
            if (anArchive != null) {
                anArchive.close();
            }
        }
    }

    protected CommonarchiveFactory getArchiveFactory() {
        return CommonarchiveFactory.eINSTANCE;
    }

    public boolean recomputeInputsIfNecessary() {
        boolean containersChanged = this.recomputeContainersIfNecessary();
        boolean inputJARChanged = this.recomputeInputJARLocation();
        return containersChanged || inputJARChanged;
    }

    public boolean recomputeContainersIfNecessary() {
        IContainer newInput;
        boolean changed;
        IContainer input = this.getInputContainer();
        boolean bl = changed = !this.objectsEqual(input, newInput = this.nature.getEMFRoot());
        if (changed && this.getNature() != null && this.getNature().getProject() != null && this.getNature().getProject().isAccessible()) {
            EList resources = this.getNature().getResourceSet().getResources();
            this.deNormalize((List)resources);
            this.getInputContainers().clear();
            this.setOutputContainer(null);
            this.resetNormalizedResourceCache();
            if (newInput != null) {
                this.addInputContainer(newInput);
            }
            this.addOtherInputContainerIfExist(this.getNature().getProject());
            this.normalize((List)resources);
        }
        return changed;
    }

    private void addOtherInputContainerIfExist(IProject project) {
        List srcContainers = JemProjectUtilities.getSourceContainers((IProject)project);
        int i = 0;
        while (i < srcContainers.size()) {
            IContainer srcContainer = (IContainer)srcContainers.get(i);
            if (!this.getInputContainers().contains(srcContainer)) {
                this.addInputContainer(srcContainer);
            }
            ++i;
        }
    }

    private void resetNormalizedResourceCache() {
        ResourceSet set;
        J2EENature aNature = this.getNature();
        if (aNature != null && (set = aNature.getResourceSet()) instanceof ProjectResourceSet) {
            ((ProjectResourceSet)set).resetNormalizedURICache();
        }
    }

    public boolean recomputeInputJARLocation() {
        IPath existing = this.inputJARLocation;
        IPath newLoc = null;
        boolean changed = false;
        IResource resource = null;
        if (JemProjectUtilities.isBinaryProject((IProject)this.nature.getProject())) {
            resource = this.getInputJARResource();
            IPath iPath = newLoc = resource == null ? null : resource.getLocation();
        }
        if (!this.objectsEqual(existing, newLoc)) {
            changed = true;
            this.inputJARLocation = newLoc;
            this.inputJARProjectRelativePath = resource == null ? null : resource.getProjectRelativePath();
            this.nature.getResourceSet().setResourceFactoryRegistry((Resource.Factory.Registry)(this.inputJARLocation == null ? J2EEResourceFactoryRegistry.INSTANCE : J2EEResouceFactorySaxRegistry.INSTANCE));
        }
        return changed;
    }

    protected IResource getInputJARResource() {
        IProject project = this.nature.getProject();
        if (project == null) {
            return null;
        }
        List jarPaths = JemProjectUtilities.getLocalJARPathsFromClasspath((IProject)project);
        int i = 0;
        while (i < jarPaths.size()) {
            IPath path = (IPath)jarPaths.get(i);
            IResource resource = project.findMember(path);
            if (resource != null && resource.exists() && resource instanceof IFile && this.isJ2EEArchive(resource)) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        if (this.isBinary()) {
            return this.createBinaryInputStream(uri);
        }
        return super.createInputStream(uri);
    }

    protected InputStream createBinaryInputStream(URI uri) throws IOException {
        if (!((URIConverterImpl.URIMap)this.getURIMap()).getURI(uri).equals((Object)uri)) {
            return super.createInputStream(uri);
        }
        ZipFile zip = null;
        boolean forceClose = true;
        try {
            zip = ArchiveUtil.newZipFile((String)this.inputJARLocation.toOSString());
            InputStream result = this.searchZipFile(zip, uri.toString());
            if (result == null) {
                throw new FileNotFoundException(uri.toString());
            }
            ZipFileEntryInputStream inputStream = new ZipFileEntryInputStream(result, zip);
            forceClose = false;
            ZipFileEntryInputStream zipFileEntryInputStream = inputStream;
            return zipFileEntryInputStream;
        }
        finally {
            if (forceClose && zip != null) {
                zip.close();
            }
        }
    }

    public IPath getInputJARLocation() {
        return this.inputJARLocation;
    }

    public IPath getInputJARProjectRelativePath() {
        return this.inputJARProjectRelativePath;
    }

    @Override
    protected boolean isBroken() {
        return super.isBroken() && this.getInputJARLocation() == null;
    }

    public boolean isBinary() {
        return this.inputJARLocation != null;
    }

    public boolean canGetUnderlyingResource(String aFileName) {
        if (this.isBinary()) {
            return this.hasZipEntry(aFileName);
        }
        return super.canGetUnderlyingResource(aFileName);
    }

    protected boolean isClasspathChanged(IResourceDelta delta) {
        IResourceDelta child = delta.findMember((IPath)new Path(".classpath"));
        return child != null && child.getFlags() != 131072;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasZipEntry(String aFileName) {
        boolean bl;
        ZipFile zip = null;
        zip = ArchiveUtil.newZipFile((String)this.inputJARLocation.toOSString());
        boolean bl2 = bl = zip.getEntry(aFileName) != null;
        if (zip == null) return bl;
        try {
            zip.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException iOException) {
            try {
                if (zip == null) return false;
            }
            catch (Throwable throwable) {
                if (zip == null) throw throwable;
                try {
                    zip.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                zip.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    protected InputStream searchZipFile(ZipFile zip, String filename) throws IOException {
        ZipEntry entry = zip.getEntry(filename);
        if (entry == null) {
            return null;
        }
        return zip.getInputStream(entry);
    }

    @Override
    protected boolean shouldNotifyChangedListeners(IResourceDelta delta) {
        return (this.isClasspathChanged(delta) || super.shouldNotifyChangedListeners(delta)) && this.recomputeInputsIfNecessary();
    }
}

