/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.binary;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.binary.IBinaryEARZipDataModelProperties;
import com.ibm.etools.j2ee.internal.binary.J2EEUtilityComponentExportDataModelProvider;
import com.ibm.etools.j2ee.internal.binary.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.AppClientComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentExportDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class BinaryEARRepackageDataModelOperation
extends AbstractDataModelOperation
implements IBinaryEARZipDataModelProperties {
    private int WORK_TO_ZIP_MODULE = 1000;
    private int WORK_TO_FIND_ARCHIVE = 10;
    private int WORK_TO_SETUP_ZIP = 100;
    private int WORK_TO_DELETE_PROJECTS = 1000;
    private int WORK_TO_REFRESH = 5;

    public BinaryEARRepackageDataModelOperation(IDataModel dataModel) {
        super(dataModel);
    }

    protected int computeTotalWork() {
        int totalWork = 0;
        List binaryComponents = (List)this.getDataModel().getProperty("COMPONENTS");
        totalWork += binaryComponents.size() * this.WORK_TO_FIND_ARCHIVE;
        totalWork += binaryComponents.size() * this.WORK_TO_SETUP_ZIP;
        totalWork += binaryComponents.size() * this.WORK_TO_ZIP_MODULE;
        totalWork += binaryComponents.size() * this.WORK_TO_REFRESH;
        if (this.getDataModel().getBooleanProperty("DELETE_PROJECTS")) {
            totalWork += binaryComponents.size() * this.WORK_TO_DELETE_PROJECTS;
        }
        return totalWork;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List componentsToZip = (List)this.getDataModel().getProperty("COMPONENTS");
        monitor.beginTask(Messages.BinaryEARRepackageDataModelOperation_0, this.computeTotalWork());
        IVirtualComponent earComponent = (IVirtualComponent)this.getDataModel().getProperty("EAR_COMPONENT");
        IVirtualFolder earRootFolder = earComponent.getRootFolder();
        IPath rootEARPath = earRootFolder.getUnderlyingFolder().getLocation();
        ArrayList<IVirtualComponent> failedToExport = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < componentsToZip.size()) {
            if (monitor.isCanceled()) break;
            int subWork = this.WORK_TO_FIND_ARCHIVE + this.WORK_TO_SETUP_ZIP + this.WORK_TO_ZIP_MODULE + this.WORK_TO_REFRESH;
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, subWork);
            try {
                subMonitor.beginTask(Messages.BinaryEARRepackageDataModelOperation_0, subWork);
                IVirtualComponent component = (IVirtualComponent)componentsToZip.get(i);
                String archiveName = "";
                EARArtifactEdit earEdit = null;
                try {
                    earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earComponent.getProject());
                    archiveName = earEdit.getModuleURI(component);
                }
                finally {
                    if (earEdit != null) {
                        earEdit.dispose();
                    }
                }
                if (archiveName == null || archiveName == "") {
                    archiveName = component.getName();
                }
                IVirtualFile vFile = earRootFolder.getFile((IPath)new Path(archiveName));
                IFile iFile = vFile.getUnderlyingFile();
                IPath archiveDestination = rootEARPath.append(archiveName);
                IDataModel exportDataModel = this.getExportModel(component, archiveDestination.toOSString());
                subMonitor.worked(this.WORK_TO_SETUP_ZIP);
                try {
                    exportDataModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, this.WORK_TO_ZIP_MODULE), null);
                }
                catch (ExecutionException e) {
                    failedToExport.add(component);
                    J2eePlugin.logError(e);
                }
                try {
                    iFile.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, this.WORK_TO_REFRESH));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            finally {
                subMonitor.done();
            }
            ++i;
        }
        if (this.getDataModel().getBooleanProperty("DELETE_PROJECTS")) {
            i = 0;
            while (i < componentsToZip.size()) {
                if (monitor.isCanceled()) break;
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.WORK_TO_DELETE_PROJECTS);
                try {
                    IVirtualComponent component = (IVirtualComponent)componentsToZip.get(i);
                    if (!failedToExport.contains(component)) {
                        try {
                            component.getProject().delete(true, (IProgressMonitor)subMonitor);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    subMonitor.done();
                }
                ++i;
            }
        }
        monitor.done();
        return OK_STATUS;
    }

    protected IDataModel getExportModel(IVirtualComponent component, String archiveDestination) {
        IDataModel exportModel = null;
        if (J2EEProjectUtilities.isEJBComponent((IVirtualComponent)component)) {
            exportModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentExportDataModelProvider());
        } else if (J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component)) {
            exportModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentExportDataModelProvider());
        } else if (J2EEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component)) {
            exportModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentExportDataModelProvider());
        } else if (J2EEProjectUtilities.isJCAComponent((IVirtualComponent)component)) {
            exportModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentExportDataModelProvider());
        } else if (J2EEProjectUtilities.isUtilityProject((IProject)component.getProject())) {
            exportModel = DataModelFactory.createDataModel((IDataModelProvider)new J2EEUtilityComponentExportDataModelProvider());
        }
        if (exportModel == null) {
            throw new NullPointerException();
        }
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)component);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)archiveDestination);
        exportModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", true);
        exportModel.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", true);
        return exportModel;
    }
}

