/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.binary;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.binary.AbstractBinaryEARModifyDataModelProvider;
import com.ibm.etools.j2ee.internal.binary.BinaryEARExpandDataModelOperation;
import com.ibm.etools.j2ee.internal.binary.IBinaryEARExpandDataModelProperties;
import com.ibm.etools.j2ee.internal.binary.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class BinaryEARExpandDataModelProvider
extends AbstractBinaryEARModifyDataModelProvider
implements IBinaryEARExpandDataModelProperties {
    @Override
    protected boolean isBinary() {
        return true;
    }

    @Override
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("PROJECT_NAME_MAP");
        return propertyNames;
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if ("PROJECT_NAME_MAP".equals(propertyName)) {
            return new HashMap();
        }
        return super.getDefaultProperty(propertyName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("EAR_COMPONENT".equals(propertyName)) {
            HashMap<IVirtualComponent, String> componentToProjectNameMap;
            block19: {
                IVirtualComponent earComponent = (IVirtualComponent)propertyValue;
                IVirtualComponent[] binaryComponents = this.getValidComponents(earComponent);
                String[] componentURIs = new String[binaryComponents.length];
                EARArtifactEdit earEdit = null;
                try {
                    earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earComponent.getProject());
                    int i = 0;
                    while (i < binaryComponents.length) {
                        componentURIs[i] = earEdit.getModuleURI(binaryComponents[i]);
                        ++i;
                    }
                }
                finally {
                    if (earEdit != null) {
                        earEdit.dispose();
                    }
                }
                componentToProjectNameMap = new HashMap<IVirtualComponent, String>();
                StructureEdit core = null;
                try {
                    WorkbenchComponent component;
                    core = StructureEdit.getStructureEditForRead((IProject)earComponent.getProject());
                    if (core == null || core.getComponent() == null || (component = core.getComponent()) == null) break block19;
                    EList referencedComponents = component.getReferencedComponents();
                    Iterator iter = referencedComponents.iterator();
                    block9: while (iter.hasNext() && componentToProjectNameMap.size() < componentURIs.length) {
                        ReferencedComponent referencedComponent = (ReferencedComponent)iter.next();
                        if (referencedComponent == null) continue;
                        String moduleURI = null;
                        EObject depObject = referencedComponent.getDependentObject();
                        if (depObject instanceof Module) {
                            Module module = (Module)depObject;
                            moduleURI = module.getUri();
                        } else if (referencedComponent.getArchiveName() != null) {
                            moduleURI = referencedComponent.getArchiveName();
                        }
                        if (moduleURI == null) continue;
                        int i = 0;
                        while (i < componentURIs.length) {
                            if (moduleURI.equals(componentURIs[i])) {
                                URI uri = referencedComponent.getHandle();
                                if (uri == null) continue block9;
                                try {
                                    ModuleURIUtil.ensureValidFullyQualifiedModuleURI((URI)uri);
                                }
                                catch (UnresolveableURIException e) {
                                    J2eePlugin.logError(e);
                                }
                                String projectName = uri.segment(1);
                                componentToProjectNameMap.put(binaryComponents[i], projectName);
                                continue block9;
                            }
                            ++i;
                        }
                    }
                }
                finally {
                    if (core != null) {
                        core.dispose();
                    }
                }
            }
            this.setProperty("PROJECT_NAME_MAP", componentToProjectNameMap);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        List components;
        if ("COMPONENTS".equals(name) && (components = (List)this.getProperty("COMPONENTS")).size() == 0) {
            return new Status(4, "com.ibm.etools.j2ee", 0, Messages.BinaryEARExpandDataModelProvider_1, null);
        }
        return super.validate(name);
    }

    public IDataModelOperation getDefaultOperation() {
        return new BinaryEARExpandDataModelOperation(this.getDataModel());
    }
}

