/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.binary;

import com.ibm.etools.j2ee.internal.binary.BinaryEARComponentArchiveLoadAdapter;
import com.ibm.etools.j2ee.internal.binary.BinaryEARComponentLoadStrategyImpl;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.archive.operations.AppClientArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentExportOperation;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class BinaryEARComponentExportOperation
extends EARComponentExportOperation {
    public BinaryEARComponentExportOperation(IDataModel model) {
        super(model);
    }

    protected void export() throws SaveFailureException, CoreException, InvocationTargetException, InterruptedException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.progressMonitor, 1000);
        String versionStr = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.getComponent().getProject());
        if (versionStr.equals("5.0")) {
            IArchive archiveFromComponent = null;
            try {
                try {
                    ArchiveOptions options = new ArchiveOptions();
                    options.setOption((Object)"LOAD_ADAPTER", (Object)new BinaryEARComponentArchiveLoadAdapter(this.getComponent()));
                    archiveFromComponent = JavaEEArchiveUtilities.INSTANCE.openArchive(options);
                    this.saveArchive(archiveFromComponent, this.getDestinationPath().toOSString(), (IProgressMonitor)subMonitor);
                }
                catch (Exception e) {
                    throw new SaveFailureException(AppClientArchiveOpsResourceHandler.ARCHIVE_OPERATION_OpeningArchive, e);
                }
            }
            catch (Throwable throwable) {
                if (archiveFromComponent != null) {
                    JavaEEArchiveUtilities.INSTANCE.closeArchive(archiveFromComponent);
                }
                subMonitor.done();
                throw throwable;
            }
            if (archiveFromComponent != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archiveFromComponent);
            }
            subMonitor.done();
        } else {
            EnterpriseArtifactEdit artifactEdit = null;
            try {
                try {
                    artifactEdit = (EnterpriseArtifactEdit)ComponentUtilities.getArtifactEditForRead((IVirtualComponent)this.getComponent());
                    EARFile archive = (EARFile)this.asArchive(artifactEdit.getComponent());
                    String destination = this.getDestinationPath().toOSString();
                    archive.setURI(destination);
                    this.setModuleFile((ModuleFile)archive);
                    ComponentLoadStrategyImpl ls = (ComponentLoadStrategyImpl)archive.getLoadStrategy();
                    ls.setExportSource(true);
                    ls.setProgressMonitor((IProgressMonitor)subMonitor);
                    archive.saveAsNoReopen(destination);
                }
                catch (SaveFailureException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    throw new SaveFailureException(AppClientArchiveOpsResourceHandler.ARCHIVE_OPERATION_OpeningArchive, e);
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                subMonitor.done();
            }
        }
    }

    public Archive asArchive(IVirtualComponent component) throws OpenFailureException {
        BinaryEARComponentLoadStrategyImpl loader = new BinaryEARComponentLoadStrategyImpl(component);
        loader.setExportSource(false);
        String uri = ModuleURIUtil.getHandleString((IVirtualComponent)component);
        return CommonarchiveFactory.eINSTANCE.openEARFile((LoadStrategy)loader, uri);
    }
}

