/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.project.EAREditModel;
import com.ibm.etools.j2ee.internal.project.EARNatureRuntime;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;

public abstract class UtilityJARInEARProjectCommand
extends AbstractCommand {
    protected EAREditModel editModel;
    protected IProject earProject;
    protected String uri;
    protected IProject project;
    protected UtilityJARMapping map;

    protected UtilityJARInEARProjectCommand() {
    }

    public UtilityJARInEARProjectCommand(EAREditModel earEditModel, String aUri, IProject aProject, String label) {
        super(label);
        this.editModel = earEditModel;
        if (earEditModel != null) {
            this.earProject = earEditModel.getProject();
        }
        this.project = aProject;
        this.uri = aUri;
    }

    public UtilityJARInEARProjectCommand(IProject anEarProject, String aUri, IProject aProject, String label) {
        super(label);
        this.earProject = anEarProject;
        this.project = aProject;
        this.uri = aUri;
    }

    protected IFile[] getAffectedFiles() {
        return new IFile[]{this.earProject.getFile("META-INF/.modulemaps"), this.earProject.getFile(".project")};
    }

    public boolean canUndo() {
        return this.map != null;
    }

    public void execute() {
        boolean createdEditModel = this.editModel == null;
        this.setupEditModel();
        try {
            this.primExecute();
            if (createdEditModel) {
                this.editModel.saveIfNecessary((Object)this);
            }
        }
        finally {
            if (createdEditModel) {
                this.editModel.releaseAccess((Object)this);
                this.editModel = null;
            }
        }
    }

    public void undo() {
        boolean createdEditModel = this.editModel == null;
        this.setupEditModel();
        try {
            this.primUndo();
            if (createdEditModel) {
                this.editModel.saveIfNecessary((Object)this);
            }
        }
        finally {
            if (createdEditModel) {
                this.editModel.releaseAccess((Object)this);
                this.editModel = null;
            }
        }
    }

    protected abstract void primUndo();

    protected abstract void primExecute();

    protected void setupEditModel() {
        EARNatureRuntime nature;
        ResourcesPlugin.getWorkspace().validateEdit(this.getAffectedFiles(), null);
        if (this.editModel == null && this.earProject != null && (nature = EARNatureRuntime.getRuntime(this.earProject)) != null) {
            this.editModel = nature.getEarEditModelForWrite((Object)this);
        }
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        this.execute();
    }

    protected void addLibCopyBuilder(IProject aProject) {
        try {
            ProjectUtilities.addToBuildSpec((String)"org.eclipse.jst.j2ee.LibCopyBuilder", (IProject)aProject);
        }
        catch (CoreException e) {
            J2eePlugin.logError(e);
        }
    }

    protected void removeLibCopyBuilder(IProject aProject) {
        try {
            ProjectUtilities.removeFromBuildSpec((String)"org.eclipse.jst.j2ee.LibCopyBuilder", (IProject)aProject);
        }
        catch (ResourceException resourceException) {
        }
        catch (CoreException e) {
            J2eePlugin.logError(e);
        }
    }

    public void addMapping() {
        this.setExistingMap();
        if (this.map == null) {
            this.map = this.editModel.addUtilityJARMapping(this.uri, this.project);
        } else {
            this.editModel.getUtilityJARMappings().add(this.map);
        }
        this.addLibCopyBuilder(this.project);
    }

    protected void removeMapping() {
        this.setExistingMap();
        if (this.map != null) {
            this.editModel.getUtilityJARMappings().remove(this.map);
        }
        this.removeLibCopyBuilder(this.project);
    }

    protected void setExistingMap() {
        if (this.map == null) {
            this.map = this.editModel.getUtilityJARMapping(this.uri, this.project);
        }
    }
}

