/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPPropertyDescriptor;
import com.ibm.etools.j2ee.common.operations.ServerTargetHelper;
import com.ibm.etools.j2ee.common.operations.ServerTargetOperation;
import com.ibm.etools.j2ee.internal.project.J2EENature;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.ResourceManager;

public class ServerTargetDataModel
extends WTPOperationDataModel {
    private static final String DEFAULT_TARGET_ID = "org.eclipse.jst.server.core.runtimeType";
    public static final String PROJECT_NAME = "ServerTargetDataModel.PROJECT_NAME";
    public static final String RUNTIME_TARGET_ID = "ServerTargetDataModel.RUNTIME_TARGET_ID";
    public static final String J2EE_VERSION_ID = "ServerTargetDataModel.J2EE_VERSION_ID";
    public static final String UPDATE_MODULES = "ServerTargetDataModel.UPDATE_MODULES";
    public static final String DEPLOYMENT_TYPE_ID = "ServerTargetDataModel.DD_TYPE_ID";

    public WTPOperation getDefaultOperation() {
        return new ServerTargetOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(PROJECT_NAME);
        this.addValidBaseProperty(RUNTIME_TARGET_ID);
        this.addValidBaseProperty(J2EE_VERSION_ID);
        this.addValidBaseProperty(DEPLOYMENT_TYPE_ID);
        this.addValidBaseProperty(UPDATE_MODULES);
    }

    public IProject getProject() {
        String name = (String)this.getProperty(PROJECT_NAME);
        if (name != null && name.length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        return null;
    }

    public IRuntime getRuntimeTarget() {
        String serverTargetId = (String)this.getProperty(RUNTIME_TARGET_ID);
        return ResourceManager.getInstance().getRuntime(serverTargetId);
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(RUNTIME_TARGET_ID)) {
            return this.getDefaultServerTargetID();
        }
        if (propertyName.equals(J2EE_VERSION_ID)) {
            return this.getDefaultVersionID();
        }
        if (propertyName.equals(UPDATE_MODULES)) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Integer getDefaultVersionID() {
        return new Integer(14);
    }

    private Object getDefaultServerTargetID() {
        List targets = this.getValidServerTargets();
        if (!targets.isEmpty()) {
            IRuntime target = null;
            int i = targets.size() - 1;
            while (i < targets.size() && i >= 0) {
                target = (IRuntime)targets.get(i);
                if (DEFAULT_TARGET_ID.equals(target.getId())) {
                    return target.getId();
                }
                --i;
            }
            if (target != null) {
                return target.getId();
            }
        }
        return null;
    }

    public String computeTypeId() {
        J2EENature nature;
        int type = -1;
        type = this.isSet(DEPLOYMENT_TYPE_ID) ? this.getIntProperty(DEPLOYMENT_TYPE_ID) : ((nature = J2EENature.getRegisteredRuntime(this.getProject())) != null ? nature.getDeploymentDescriptorType() : this.getIntProperty(DEPLOYMENT_TYPE_ID));
        return this.computeTypeId(type);
    }

    private String computeTypeId(int deploymentDescriptorType) {
        switch (deploymentDescriptorType) {
            case 2: {
                return "j2ee.ear";
            }
            case 1: {
                return "j2ee.appclient";
            }
            case 3: {
                return "j2ee.ejb";
            }
            case 4: {
                return "j2ee.web";
            }
            case 5: {
                return "j2ee.connector";
            }
        }
        return null;
    }

    public String computeVersionId() {
        J2EENature nature;
        int version = -1;
        version = this.isSet(J2EE_VERSION_ID) ? this.getIntProperty(J2EE_VERSION_ID) : ((nature = J2EENature.getRegisteredRuntime(this.getProject())) != null ? nature.getJ2EEVersion() : this.getIntProperty(J2EE_VERSION_ID));
        return this.computeVersionId(version);
    }

    private String computeVersionId(int version) {
        switch (version) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return null;
    }

    protected WTPPropertyDescriptor[] doGetValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals(RUNTIME_TARGET_ID)) {
            return this.getValidServerTargetDescriptors();
        }
        return super.doGetValidPropertyDescriptors(propertyName);
    }

    private WTPPropertyDescriptor[] getValidServerTargetDescriptors() {
        List targets = this.getValidServerTargets();
        WTPPropertyDescriptor[] descriptors = null;
        if (!targets.isEmpty()) {
            int serverTargetListSize = targets.size();
            descriptors = new WTPPropertyDescriptor[serverTargetListSize];
            int i = 0;
            while (i < targets.size()) {
                IRuntime runtime = (IRuntime)targets.get(i);
                descriptors[i] = new WTPPropertyDescriptor((Object)runtime.getId(), runtime.getName());
                ++i;
            }
        } else {
            descriptors = new WTPPropertyDescriptor[]{};
        }
        return descriptors;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(J2EE_VERSION_ID)) {
            IRuntime target = this.getServerTargetByID(this.getStringProperty(RUNTIME_TARGET_ID));
            if (target == null) {
                this.setProperty(RUNTIME_TARGET_ID, null);
            }
            this.notifyValidValuesChange(RUNTIME_TARGET_ID);
        }
        return true;
    }

    private IRuntime getServerTargetByID(String id) {
        List targets = this.getValidServerTargets();
        int i = 0;
        while (i < targets.size()) {
            IRuntime target = (IRuntime)targets.get(i);
            if (id.equals(target.getId())) {
                return target;
            }
            ++i;
        }
        return null;
    }

    private List getValidServerTargets() {
        String version;
        List validServerTargets = null;
        String type = this.computeTypeId();
        if (type != null && (version = this.computeVersionId()) != null && (validServerTargets = ServerTargetHelper.getServerTargets(type, version)) != null && validServerTargets.isEmpty()) {
            validServerTargets = null;
        }
        if (validServerTargets == null) {
            return Collections.EMPTY_LIST;
        }
        return validServerTargets;
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(RUNTIME_TARGET_ID)) {
            return this.validateServerTarget();
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateServerTarget() {
        List targets = this.getValidServerTargets();
        if (targets.isEmpty()) {
            return J2EEPlugin.newErrorStatus((String)J2EECreationResourceHandler.ServerTargetDataModel_UI_7, null);
        }
        IRuntime target = this.getRuntimeTarget();
        if (target == null) {
            return J2EEPlugin.newErrorStatus((String)J2EECreationResourceHandler.ServerTargetDataModel_UI_8, null);
        }
        if (!targets.contains(target)) {
            return J2EEPlugin.newErrorStatus((String)J2EECreationResourceHandler.ServerTargetDataModel_UI_9, null);
        }
        return OK_STATUS;
    }
}

