/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPPropertyDescriptor;
import com.ibm.etools.j2ee.common.operations.J2EEProjectServerTargetOperation;
import com.ibm.etools.j2ee.common.operations.ServerTargetHelper;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.ResourceManager;

public class J2EEProjectServerTargetDataModel
extends WTPOperationDataModel {
    private static final String DEFAULT_TARGET_ID = "org.eclipse.jst.server.core.runtimeType";
    public static final String PROJECT_NAME = "J2EEProjectServerTargetDataModel.PROJECT_NAME";
    public static final String RUNTIME_TARGET_ID = "J2EEProjectServerTargetDataModel.RUNTIME_TARGET_ID";
    public static final String UPDATE_MODULES = "J2EEProjectServerTargetDataModel.UPDATE_MODULES";

    public WTPOperation getDefaultOperation() {
        return new J2EEProjectServerTargetOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(PROJECT_NAME);
        this.addValidBaseProperty(RUNTIME_TARGET_ID);
        this.addValidBaseProperty(UPDATE_MODULES);
    }

    public IProject getProject() {
        String name = (String)this.getProperty(PROJECT_NAME);
        if (name != null && name.length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        return null;
    }

    public IRuntime getRuntimeTarget() {
        String serverTargetId = (String)this.getProperty(RUNTIME_TARGET_ID);
        return ResourceManager.getInstance().getRuntime(serverTargetId);
    }

    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(RUNTIME_TARGET_ID)) {
            return this.getDefaultServerTargetID();
        }
        if (propertyName.equals(UPDATE_MODULES)) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultServerTargetID() {
        List targets = this.getValidServerTargets();
        if (!targets.isEmpty()) {
            IRuntime target = null;
            int i = targets.size() - 1;
            while (i < targets.size() && i >= 0) {
                target = (IRuntime)targets.get(i);
                String id = target.getRuntimeType().getId();
                if (DEFAULT_TARGET_ID.equals(id)) {
                    return target.getId();
                }
                --i;
            }
            if (target != null) {
                return target.getId();
            }
        }
        return null;
    }

    protected WTPPropertyDescriptor[] doGetValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals(RUNTIME_TARGET_ID)) {
            return this.getValidServerTargetDescriptors();
        }
        return super.doGetValidPropertyDescriptors(propertyName);
    }

    private WTPPropertyDescriptor[] getValidServerTargetDescriptors() {
        List targets = this.getValidServerTargets();
        WTPPropertyDescriptor[] descriptors = null;
        if (!targets.isEmpty()) {
            int serverTargetListSize = targets.size();
            descriptors = new WTPPropertyDescriptor[serverTargetListSize];
            int i = 0;
            while (i < targets.size()) {
                IRuntime runtime = (IRuntime)targets.get(i);
                descriptors[i] = new WTPPropertyDescriptor((Object)runtime.getId(), runtime.getName());
                ++i;
            }
        } else {
            descriptors = new WTPPropertyDescriptor[]{};
        }
        return descriptors;
    }

    private List getValidServerTargets() {
        List validServerTargets = null;
        validServerTargets = ServerTargetHelper.getServerTargets("", "");
        if (validServerTargets != null && validServerTargets.isEmpty()) {
            validServerTargets = null;
        }
        if (validServerTargets == null) {
            return Collections.EMPTY_LIST;
        }
        return validServerTargets;
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(RUNTIME_TARGET_ID)) {
            return this.validateServerTarget();
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateServerTarget() {
        List targets = this.getValidServerTargets();
        if (targets.isEmpty()) {
            return J2EEPlugin.newErrorStatus((String)J2EECreationResourceHandler.ServerTargetDataModel_UI_7, null);
        }
        IRuntime target = this.getRuntimeTarget();
        if (target == null) {
            return J2EEPlugin.newErrorStatus((String)J2EECreationResourceHandler.ServerTargetDataModel_UI_8, null);
        }
        if (!targets.contains(target)) {
            return J2EEPlugin.newErrorStatus((String)J2EECreationResourceHandler.ServerTargetDataModel_UI_9, null);
        }
        return OK_STATUS;
    }
}

